/*
    eval.c -- Eval.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

/******************************* EXPORTS ******************************/

object Sapply;
object Sfuncall;

/******************************* ------- ******************************/

struct nil3 { object nil3_self[3]; } three_nils;

#define SYMBOL_VALUE(sym)       (sym->s.s_dbind == OBJNULL ? \
				 (FEunbound_variable(sym),Cnil) : sym->s.s_dbind)
#define SYMBOL_FUNCTION(sym)    (sym->s.s_gfdef == OBJNULL ? \
				 (FEundefined_function(sym),Cnil) : sym->s.s_gfdef)

#define LEX_BLOCK_BIND(x, fun)  lex_env[2] = CONS(list(3, x, Sblock, fun), \
						  lex_env[2])


#ifdef THREADS
#define eval1            clwp->lwp_eval1
#else
int eval1 = 0;          /*  = 1 during one-shot bypass of evalhook/applyhook  */
#endif THREADS

object Vevalhook;
object Vapplyhook;

#ifdef CLOS
extern gfun();
#endif

void bds_unwind(new_bds_top)
     bds_ptr new_bds_top;
{       register bds_ptr bds = bds_top;
	for (;  bds > new_bds_top;  bds--)
		(bds->bds_sym)->s.s_dbind = bds->bds_val;
	bds_top = new_bds_top;
}

/* Calling conventions:
   Compiled C code calls lisp function supplying #args, and args.
   Linking function performs check_args, gets jmp_buf with _setjmp, then
    if cfun then stores C code address into function link location
	    and transfers to jmp_buf at cf_self
    if cclosure then replaces #args with cc_env and calls cc_self
    otherwise, it emulates funcall.
 */

lambda_apply(int narg, object fun, object *args)
{       object *lex_old = lex_env; lex_dcl;
	object x; volatile object body;
	bds_ptr old_bds_top;
	volatile bool block, closure;
	int nr;

	ihs_check;
	ihs_push(fun, lex);     /* lex will be filled later */
	old_bds_top = bds_top;
	x = CAR(fun);
	if (x == Slambda_block) {
		block = TRUE;
		closure = FALSE;
		fun = CDR(fun);
	} else if (x == Slambda_closure) {
		block = FALSE;
		closure = TRUE;
		fun = CDR(fun);
	} else if (x == Slambda) {
		block = closure = FALSE;
		fun = CDR(fun);
	} else if (x == Slambda_block_closure) {
		block = closure = TRUE;
		fun = CDR(fun);
	} else
		block = closure = TRUE;
	lex_env = lex;
	if (closure) {
		lex[0] = kar(fun);
		fun = CDR(fun);
		lex[1] = kar(fun);
		fun = CDR(fun);
		lex[2] = kar(fun);
		fun = CDR(fun);
	} else
		*(struct nil3 *)lex = three_nils;
	if (block) {
		x = kar(fun);  /* block name */
		fun = CDR(fun);
	}
	body = lambda_bind(narg, fun, args);
	if (block) {
		fun = new_frame_id();
		LEX_BLOCK_BIND(x, fun);
		if ((nr = frs_push(FRS_CATCH, fun)) != 0) {
		  --nr; /* 1 was added because longjmp cannot return 0 */
		  goto END;
		}
	}
	VALUES(0) = Cnil;
	nr = 0;
	for (; !ENDP(body); body = CDR(body))
	  nr = eval(CAR(body));

END:    if (block) frs_pop();
	bds_unwind(old_bds_top);
	lex_env = lex_old;
	ihs_pop();
	return(nr);
}

/*
 *----------------------------------------------------------------------
 *
 *     apply --
 *	    applies a Lisp function to the arguments in array args.
 *	    narg is their count.
 *
 *     Results:
 *	    number of values
 *
 *     Side Effect:
 *	    values are placed into the array Values
 *----------------------------------------------------------------------
 */
apply(int narg, object fun, object *args)
{     object x = fun;

      AGAIN:
	if (fun == OBJNULL)
		FEundefined_function(x);

	switch (type_of(fun)) {
	case t_cfun:
		return(APPLY(narg, fun->cf.cf_self, args));

	case t_cclosure:
		{ int i; CSTACK(narg+1);
		  CPUSH(fun->cc.cc_env);
		  for (i = 0; i < narg; i++)
		    CPUSH(*args++);
#ifdef CCALL
		  return(CCALL(narg+1, fun->cc.cc_self));
#else
		  return(APPLY(narg+1, fun->cc.cc_self, CSTACK_BOT));
#endif CCALL
		}
#ifdef CLOS
	case t_gfun:
		return(gcall(narg, fun, args));
#endif

	case t_symbol:
		fun = fun->s.s_gfdef;
		goto AGAIN;

	case t_cons:
#ifdef CLOS
		{  object setf_sym;
		   if ((setf_sym=setf_namep(fun)) != OBJNULL)
		     if (setf_sym->s.s_gfdef != OBJNULL) {
		       fun = setf_sym->s.s_gfdef;
		       goto AGAIN;
		     }
		     else
		       FEundefined_function(fun);
		 }
#endif
		{ object mv_values[narg]; /* __GNUC__ */
		  /* move args out of VALUES, or macroexpand of fun's body
		     will clobber them */
		  memcpy(mv_values, args, narg * sizeof(object));
		  return(lambda_apply(narg, fun, mv_values));
		}
	default:
		FEinvalid_function(fun);
	}
}

funcall(int narg, ...)
{
	object fun;
	va_list funargs;
	va_start(funargs, narg);
	fun = va_arg(funargs, object);

      AGAIN:
	if (fun == OBJNULL) {
		va_start(funargs, narg);
		FEundefined_function(va_arg(funargs, object));
	      }
	switch (type_of(fun)) {
	case t_cfun:
		return(APPLY(narg-1, fun->cf.cf_self, funargs));

	case t_cclosure:
		va_start(funargs, narg);
		((object *)funargs)[0] = fun->cc.cc_env;
		return(APPLY(narg, fun->cc.cc_self, funargs));

#ifdef CLOS
	case t_gfun:
		return(gcall(narg-1, fun, funargs));
#endif

	case t_symbol:
		fun = fun->s.s_gfdef;
		goto AGAIN;

	case t_cons:
#ifdef CLOS
		{  object setf_sym;
		   if ((setf_sym=setf_namep(fun)) != OBJNULL)
		     if (setf_sym->s.s_gfdef != OBJNULL) {
		       fun = setf_sym->s.s_gfdef;
		       goto AGAIN;
		     }
		     else
		       FEundefined_function(fun);
		 }
#endif
		return(lambda_apply(narg-1, fun, (object *)funargs));

	default:
		FEinvalid_function(fun);
	}
}

object
get_function(object fun)
{
	if (type_of(fun) == t_symbol) {
		if (SPECIAL(fun) || fun->s.s_mflag)
			FEinvalid_function(fun);
		return(SYMBOL_FUNCTION(fun));
	}
#ifdef CLOS
	{  object setf_sym;
	   if ((setf_sym=setf_namep(fun)) != OBJNULL)
	     return(SYMBOL_FUNCTION(setf_sym));
	 }
#endif CLOS
	return(fun);
}

/*----------------------------------------------------------------------*
 *	Linking mechanism						*
 *----------------------------------------------------------------------*/

static object siSlink_to;
static object siSlink_from;

#ifdef CLOS
link_call(object sym, int (**pLK)(), object *gfun, object *args)
#else
link_call(object sym, int (**pLK)(), object *args)
#endif CLOS
{       int narg = (int)args[0];
	object fun = symbol_function(sym);

	if (fun == OBJNULL) FEerror("Undefined function.", 0);

	switch (type_of(fun)) {
	case t_cfun:
	  putprop(sym, CONS(CONS(MAKE_FIXNUM((int)pLK),
				 MAKE_FIXNUM((int)*pLK)),
			    getf(sym->s.s_plist, siSlink_from, Cnil)),
		  siSlink_from);
	  *pLK = fun->cf.cf_self;
	  return(APPLY(narg, fun->cf.cf_self, &args[1]));
#ifdef CLOS
	case t_gfun:
	  putprop(sym, CONS(CONS(MAKE_FIXNUM((int)gfun),
				 MAKE_FIXNUM((int)OBJNULL)),
			    getf(sym->s.s_plist, siSlink_from, Cnil)),
		  siSlink_from);
	  *gfun = fun;
	  return(gcall(narg, fun, &args[1]));
#endif CLOS
	case t_cclosure:
		args[0] = (object)fun->cc.cc_env;
		return(APPLY(narg+1, fun->cc.cc_self, args));

	case t_cons:
		return(lambda_apply(narg, fun, &args[1]));

	default:
		FEinvalid_function(fun);
	}
}

siLunlink_symbol(int narg, object s)
{  object pl;
   check_arg(1);
   if (type_of(s) != t_symbol)
     not_a_symbol(s);
   pl = getf(s->s.s_plist, siSlink_from, Cnil);
   if (!endp(pl)) {
     for (; !endp(pl); pl = CDR(pl))
       *(int *)(fix(CAAR(pl))) = fix(CDAR(pl));
     remf(&s->s.s_plist, siSlink_from);
   }
 }

/*----------------------------------------------------------------------*/

eval(object form)
{
  object fun, x;
  int nr;

  cs_check(form);

 EVAL:
  if (Vevalhook->s.s_dbind != Cnil && eval1 == 0) {
    bds_ptr old_bds_top = bds_top;
    object hookfun = get_function(symbol_value(Vevalhook)); /*  checks whether unbound  */
    bds_bind(Vevalhook, Cnil);
    nr = funcall(3, hookfun, form,
		 list(3, lex_env[0], lex_env[1], lex_env[2]));
    bds_unwind(old_bds_top);
    return(nr);
  } else
    eval1 = 0;

  switch (type_of(form)) {
  case t_symbol:
    switch ((enum stype)form->s.s_stype) {
    case stp_constant:
      VALUES(0) = form->s.s_dbind;
      RETURN(1);
	
    case stp_special:
      VALUES(0) = SYMBOL_VALUE(form);
      RETURN(1);
	
    default:
      /*  x = lex_var_sch(form);  */
      for (x = lex_env[0];  type_of(x) == t_cons;  x = CDR(x))
	if (CAAR(x) == form) {
	  x = CDAR(x);
	  if (ENDP(x)) break;
	  VALUES(0) = CAR(x);
	  RETURN(1);
	}
      VALUES(0) = SYMBOL_VALUE(form);
      RETURN(1);
    }

  case t_cons:
    fun = CAR(form);
    if (type_of(fun) != t_symbol)
      if (type_of(fun) == t_cons && CAR(fun) == Slambda) {
	x = CONS(Slambda_closure,
		 listA(4, lex_env[0], lex_env[1], lex_env[2], CDR(fun)));
	goto EVAL_ARGS;
      } else
	FEinvalid_function(fun);

    if (SPECIAL(fun)) {
      ihs_check;
      ihs_push(fun, lex_env);
      nr = (*fun->s.s_sfdef)(CDR(form));
      ihs_pop();
      return(nr);
    }
    /*  x = lex_fd_sch(fun);  */
    for (x = lex_env[1];  type_of(x) == t_cons;  x = CDR(x))
      if (CAAR(x) == fun) {
	x = CAR(x);
	if (CADR(x) == Smacro) {
	  x = CADDR(x);
	  goto EVAL_MACRO;
	}
	x = CADDR(x);
	goto EVAL_ARGS;
      }
    x = SYMBOL_FUNCTION(fun);   
    if (fun->s.s_mflag) {
    EVAL_MACRO:
      macro_expand1(x, form);
      form = VALUES(0);
      goto EVAL;
    }
	
  EVAL_ARGS:
    form = CDR(form);
    {   bool is_closure = (type_of(x) == t_cclosure);
	int narg = length(form);
	CSTACK(is_closure ? narg+1 : narg);
	if (is_closure) CPUSH(x->cc.cc_env);
	while (!ENDP(form)) {
	  eval(CAR(form));
	  CPUSH(VALUES(0));
	  form = CDR(form);
	}
	if (Vapplyhook->s.s_dbind != Cnil) {
	  object arglist = Cnil;
	  while (narg-- > 0)
	    arglist = CONS(*(--CSTACK_TOP), arglist);
	  return(funcall(4, symbol_value(Vapplyhook),
			 fun, arglist,
			 list(3, lex_env[0], lex_env[1], lex_env[2])));
	}
	if (is_closure)
#ifdef CCALL
	  nr = CCALL(narg+1, x->cc.cc_self);
#else
	  nr = APPLY(narg+1, x->cc.cc_self, CSTACK_BOT);
#endif CCALL
	else
	  nr = apply(narg, x, CSTACK_BOT);
	return(nr);
      }

  default:
    VALUES(0) = form;
    RETURN(1);
  }
}

Lfuncall(int narg, object fun, ...)
{       va_list args;

	if (narg < 1)
		FEtoo_few_arguments(&narg);
	va_start(args, fun);
	return(apply(narg-1, fun, (object *)args));
}

Lapply(int narg, object fun, ...)
{
	register int i; int len;
	register object lastarg;
	va_list args;
	va_start(args, fun);
	if (narg < 2) FEtoo_few_arguments(&narg);
	narg -= 2;
	for (i = 0; i < narg; i++) va_arg(args, object);
	lastarg = va_arg(args, object);
	/* can't leave args on VALUES since it may be used before
	   function is called: e.g. computing effective method of generic
	   function */
	{ object savargs[i + length(lastarg)]; /* __GNUC__ */
	  va_start(args, fun);
	  for (i = 0; i < narg; i++) savargs[i] = va_arg(args, object);
	  while (!ENDP(lastarg)) {
	    savargs[i++] = CAR(lastarg);
	    lastarg = CDR(lastarg);
	  }
	  return(apply(i, fun, savargs));
	}
}

Leval(int narg, object form)
{       int nr;
	object *lex_old = lex_env; lex_dcl;

	check_arg(1);
	ihs_top->ihs_base = lex_env = lex;      /* lex_new(); */
	*(struct nil3 *)lex = three_nils;       /*    ''      */
	nr = eval(form);
	lex_env = lex_old;
	return(nr);
}

Levalhook(int n, object form, object evalhookfn, object applyhookfn,
	  object env)
{
	object *lex_old = lex_env; lex_dcl;
	bds_ptr old_bds_top = bds_top;

	lex_env = lex;
	if (n < 3)
		FEtoo_few_arguments(&n);
	else if (n > 4)
		FEtoo_many_arguments(&n);
	bds_bind(Vevalhook, evalhookfn);
	bds_bind(Vapplyhook, applyhookfn);
	if (n == 3)
		*(struct nil3 *)lex = three_nils;
	else {
		lex_env[0] = car(env);
		lex_env[1] = car(env = cdr(env));
		lex_env[2] = cadr(env);
	}
	eval1 = 1;
	n = eval(form);
	bds_unwind(old_bds_top);
	lex_env = lex_old;
	return(n);
}

Lapplyhook(int narg, object fun, object args, object evalhookfn,
	   object applyhookfn)
{       int len = length(args);
	bds_ptr old_bds_top = bds_top;

	check_arg(4);
	bds_bind(Vevalhook, evalhookfn);
	bds_bind(Vapplyhook, applyhookfn);
	narg = Lapply(2, fun, args);
	bds_unwind(old_bds_top);
	return(narg);
}

Lconstantp(int narg, object arg)
{
	check_arg(1);

	switch (type_of(arg)) {
	case t_cons:
		VALUES(0) = (CAR(arg) == Squote) ? Ct : Cnil;
		break;
	case t_symbol:
		VALUES(0) =
		  ((enum stype)arg->s.s_stype == stp_constant) ? Ct : Cnil;
		break;
	default:
		VALUES(0) = Ct;
	}
	RETURN(1);
}

init_eval()
{
	make_constant("CALL-ARGUMENTS-LIMIT", MAKE_FIXNUM(64));

	Sapply = make_function("APPLY", Lapply);
	enter_mark_origin(&Sapply);
	Sfuncall = make_function("FUNCALL", Lfuncall);
	enter_mark_origin(&Sfuncall);

	Vevalhook = make_special("*EVALHOOK*", Cnil);
	Vapplyhook = make_special("*APPLYHOOK*", Cnil);

	eval1 = 0;

	three_nils.nil3_self[0] = Cnil;
	three_nils.nil3_self[1] = Cnil;
	three_nils.nil3_self[2] = Cnil;

	make_function("EVAL", Leval);
	make_function("EVALHOOK", Levalhook);
	make_function("APPLYHOOK", Lapplyhook);
	make_function("CONSTANTP", Lconstantp);

	siSlink_from = make_si_ordinary("LINK-FROM");
	enter_mark_origin(&siSlink_from);
	siSlink_to = make_si_ordinary("LINK-TO");
	enter_mark_origin(&siSlink_to);
	make_si_function("UNLINK-SYMBOL", siLunlink_symbol);
}
