/*
    external.h -- External variable definitions.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


/*  alloc.c  */
char *alloc_page();
object alloc_object();
char *alloc_contblock();
char *alloc_relblock();
int insert_contblock();
object make_cons();

/*  array.c  */
enum aelttype array_elttype();
void array_allocself();
object aref();
object aset();
object aref1();
object aset1();
void adjust_displaced();
void undisplace();

/*  assignment.s  */
extern object siSsetf_symbol;
object setf_namep();
void setq();

/*  backq.c  */
#ifdef MTCL
#define backq_level     clwp->lwp_backq_level
#else
extern int backq_level;
#endif

/*  bds.c  */
void bds_unwind();

/*  big.c  */
struct bignum *stretch_big();
struct bignum *copy_big();
struct bignum *copy_to_big();
bool big_zerop();
int big_sign();
int big_compare();
int complement_big();
struct bignum *big_minus();
void add_int_big();
void sub_int_big();
void mul_int_big();
int div_int_big();
struct bignum *big_plus();
struct bignum *big_times();
int big_length();
int big_quotient_remainder();
void normalize_big();
object normalize_big_to_object();
double big_to_double();

/* bind.c */
extern object ANDoptional;
extern object ANDrest;
extern object ANDkey;
extern object ANDallow_other_keys;
extern object ANDaux;
extern object Kallow_other_keys;
object lambda_bind();
object process_decl();
object let_bind();
object letA_bind();

/* block.c */
extern object Sblock;

/*  cfun.c  */
object make_cfun();
object MF();
object MM();
object make_function();
object make_si_function();
object make_special_form();

/*  character.d  */
extern object STreturn;
extern object STspace;
extern object STrubout;
extern object STpage;
extern object STtab;
extern object STbackspace;
extern object STlinefeed;
extern object STnewline;
int digitp();
int digit_weight();
bool char_eq();
bool char_equal();
object coerce_to_character();

#ifdef CLOS

/*  instance.c  */
extern object class_object;
extern object Sprint_object;
#endif CLOS

/*  cmpaux.c  */
char object_to_char();
void set_VV();
int object_to_int();
float object_to_float();
double object_to_double();

/*  error.c  */
extern object Kerror;
extern object Kwrong_type_argument;
extern object Ktoo_few_arguments;
extern object Ktoo_many_arguments;
extern object Kunexpected_keyword;
extern object Kinvalid_form;
extern object Kunbound_variable;
extern object Kinvalid_variable;
extern object Kundefined_function;
extern object Kinvalid_function;
extern object Kcatch;
extern object Kcatchall;
extern object Kprotect;
int CEerror(char *, char *, int, ...);
int FEerror(char *, int, ...);
int FEwrong_type_argument(object, object);
int FEtoo_few_arguments(int *);
int FEtoo_few_argumentsF(object);
int FEtoo_many_arguments(int *);
int FEtoo_many_argumentsF(object);
int FEunexpected_keyword(object);
int FEinvalid_form(char *, object);
int FEunbound_variable(object);
int FEinvalid_variable(char *, object);
int FEundefined_function(object);
int FEinvalid_function(object);

int check_arg_failed(int, int);
int illegal_declare(object);
int illegal_index(object, object);
int not_a_symbol(object);
int not_a_variable(object);
object wrong_type_argument(object, object);

/*  eval.c  */
extern object Sapply;
extern object Sfuncall;
int funcall(int, ...);
int apply();
int eval();
object get_function();
extern object Vevalhook;
extern object Vapplyhook;

/*  file.d  */
extern object Vstandard_input;
extern object Vstandard_output;
extern object Verror_output;
extern object Vquery_io;
extern object Vdebug_io;
extern object Vterminal_io;
extern object Vtrace_output;
extern object Kabort;
extern object Kdirection;
extern object Kinput;
extern object Koutput;
extern object Kio;
extern object Kprobe;
extern object Kelement_type;
extern object Kdefault;
extern object Kif_exists;
extern object Kerror;
extern object Knew_version;
extern object Krename;
extern object Krename_and_delete;
extern object Koverwrite;
extern object Kappend;
extern object Ksupersede;
extern object Kif_does_not_exist;
extern object Kerror;
extern object Kcreate;
extern object Kprint;
extern object Kverbose;
extern object Kif_does_not_exist;
extern object Kset_default_pathname;
extern object Vload_verbose;
extern object FASL_string;
void end_of_stream();
bool input_stream_p();
bool output_stream_p();
object stream_element_type();
object open_stream();
void close_stream();
object make_two_way_stream();
object make_echo_stream();
object make_string_input_stream();
object make_string_output_stream();
object get_output_stream_string();
int readc_stream();
void unreadc_stream();
int writec_stream();
void writestr_stream();
void flush_stream();
bool stream_at_end();
bool listen_stream();
int file_position();
int file_position_set();
int file_length();
int file_column();

/*  frame.c  */
void unwind();
frame_ptr frs_sch();
frame_ptr frs_sch_catch();

/*  gc.c  */
bool GC_enable;
void GC();

/*  lex.c  */
#ifndef MTCL
extern object *lex_env;
#endif
extern object Smacro;
extern object Sblock;
extern object assoc_eq();
void lex_fun_bind();
void lex_macro_bind();
void lex_tag_bind();
void lex_block_bind();
object lex_tag_sch();
object lex_block_sch();

/*  list.d  */
extern object Ktest;
extern object Ktest_not;
extern object Kkey;
bool endp1();
object car();
object cdr();
object kar();
object kdr();
object caar();
object cadr();
object cdar();
object cddr();
object caaar();
object caadr();
object cadar();
object caddr();
object cdaar();
object cdadr();
object cddar();
object cdddr();
object caaaar();
object caaadr();
object caadar();
object caaddr();
object cadaar();
object cadadr();
object caddar();
object cadddr();
object cdaaar();
object cdaadr();
object cdadar();
object cdaddr();
object cddaar();
object cddadr();
object cdddar();
object cddddr();
object nth();
object nthcdr();
object list(int, ...);
object listA(int, ...);
object append();
object copy_list();
bool member_eq();
void delete_eq();
object nconc();

/* lwp.c	*/
#ifdef MTCL
extern lpd main_lpd;
extern lpd *clwp;
extern pd *running_head;
extern pd *running_tail;
extern pd main_pd;
#endif MTCL

/*  macros.c  */
extern object Vmacroexpand_hook;
extern object siSexpand_defmacro;
object macro_expand();
void macro_expand1();

/*  main.c  */

extern object Squote;
extern object Sfunction;
extern object Slambda;
extern object Slambda_block;
extern object Slambda_closure;
extern object Slambda_block_closure;
extern object Sspecial;
extern int ARGC;
extern char **ARGV;
#ifdef unix
extern char **ENVP;
#endif
extern int interrupt_flag;
extern int interrupt_enable;
extern char system_directory[];
extern object siVsystem_directory;
#ifdef unix
extern char *ecl_self;
#endif
extern bool initflag;
void error();
void bds_overflow();
int frs_overflow();
void ihs_overflow();
void cs_overflow();

/*  number.c  */
int fixint();
int fixnnint();
object shortfloat_zero;
object longfloat_zero;
object make_fixnum();
object make_ratio();
object make_shortfloat(float);
object make_longfloat(double);
object make_complex(object, object);
double number_to_double(object);

/*  num_pred.c  */
int number_zerop();
int number_plusp();
int number_mimusp();

/*  num_comp.c  */
int number_compare();

/*  num_arith  */
object bignum2();
object bignum3();
object number_to_complex();
object complex_plus();
object number_plus();
object number_negate();
object number_minus();
object number_times();
object number_divide();
object integer_divide1();
object get_gcd();
object one_plus();
object one_minus();

/*  num_co.c  */
object double_to_integer();
object remainder();

/*  num_log.c  */
int double_shift();
object shift_integer();

/*  package.d  */
extern object lisp_package;
extern object user_package;
extern object keyword_package;
extern object system_package;
#ifdef CLOS
extern object clos_package;
#endif
extern object Vpackage;		/*  *package*  */
#ifdef MTCL
#define intern_flag     clwp->lwp_intern_flag
#else
extern int intern_flag;
#endif
extern object uninterned_list;
bool member_string_equal();
object make_package();
object in_package();
object rename_package();
object find_package();
object coerce_to_package();
object current_package();
int pack_hash();
object intern();
object find_symbol();

/*  pathname.d  */
extern object Vdefault_pathname_defaults;
extern object Kwild;
extern object Knewest;
extern object Kstart;
extern object Kend;
extern object Kjunk_allowed;
object parse_namestring();
object coerce_to_pathname();
object default_device();
object merge_pathnames();
object namestring();
object coerce_to_namestring();

/*  prediate.c  */
bool eql();
bool equal();
bool equalp();

/*  print.d  */
extern object Kupcase;
extern object Kdowncase;
extern object Kcapitalize;
extern object Kstream;
extern object Kescape;
extern object Kpretty;
extern object Kcircle;
extern object Kbase;
extern object Kradix;
extern object Kcase;
extern object Kgensym;
extern object Klevel;
extern object Klength;
extern object Karray;
extern object Vprint_escape;
extern object Vprint_pretty;
extern object Vprint_circle;
extern object Vprint_base;
extern object Vprint_radix;
extern object Vprint_case;
extern object Vprint_gensym;
extern object Vprint_level;
extern object Vprint_length;
extern object Vprint_array;

#ifdef MTCL
#define PRINTstream     clwp->lwp_PRINTstream
#define PRINTescape     clwp->lwp_PRINTescape
#define PRINTpretty     clwp->lwp_PRINTpretty
#define PRINTcircle     clwp->lwp_PRINTcircle
#define PRINTbase	clwp->lwp_PRINTbase
#define PRINTradix	clwp->lwp_PRINTradix
#define PRINTcase	clwp->lwp_PRINTcase
#define PRINTgensym     clwp->lwp_PRINTgensym
#define PRINTlevel	clwp->lwp_PRINTlevel
#define PRINTlength     clwp->lwp_PRINTlength
#define PRINTarray	clwp->lwp_PRINTarray
#define write_ch_fun    (clwp->lwp_write_ch_fun)
#define output_ch_fun   (clwp->lwp_output_ch_fun)
#define read_ch_fun	(clwp->lwp_read_ch_fun)
#else
extern object	PRINTstream;
extern bool	PRINTescape;
extern bool	PRINTpretty;
extern bool	PRINTcircle;
extern int	PRINTbase;
extern bool	PRINTradix;
extern object	PRINTcase;
extern bool	PRINTgensym;
extern int	PRINTlevel;
extern int	PRINTlength;
extern bool	PRINTarray;
extern int	(*write_ch_fun)();
extern object	(*read_ch_fun)();
#endif MTCL

void edit_double();
void write_object();
void setupPRINT();
void cleanupPRINT();
bool potential_number_p();
object princ();
object prin1();
object print();
object terpri();
object siSpretty_print_format;

/* prog.c */
int Fprogn();

/*  read.d  */
extern object standard_readtable;
extern object Vreadtable;
extern object Vread_default_float_format;
extern object Vread_base;
extern object Vread_suppress;
extern object Kradix;
extern object Kjunk_allowed;
extern object siSsharp_comma;
#ifdef MTCL
#define READtable           clwp->lwp_READtable
#define READdefault_float_format  clwp->lwp_READdefault_float_format
#define READbase  clwp->lwp_READbase
#define READsuppress  clwp->lwp_READsuppress
#define preserving_whitespace_flag  clwp->lwp_preserving_whitespace_flag
#define escape_flag  clwp->lwp_escape_flag
#define delimiting_char  clwp->lwp_delimiting_char
#define detect_eos_flag  clwp->lwp_detect_eos_flag
#define in_list_flag  clwp->lwp_in_list_flag
#define dot_flag  clwp->lwp_dot_flag
#define default_dispatch_macro  clwp->lwp_default_dispatch_macro
#define big_register_0  clwp->lwp_big_register_0
#define sharp_eq_context_max  clwp->lwp_sharp_eq_context_max
#else
extern object READtable;
extern int READdefault_float_format;
extern int READbase;
extern bool READsuppress;
extern bool preserving_whitespace_flag;
extern bool escape_flag;
extern object delimiting_char;
extern bool detect_eos_flag;
extern bool in_list_flag;
extern bool dot_flag;
extern object default_dispatch_macro;
extern object big_register_0;
extern int sharp_eq_context_max;
#endif MTCL
#ifdef CLOS
extern object Sstream_read_line;
extern object Sstream_read_char;
extern object Sstream_unread_char;
extern object Sstream_peek_char;
extern object Sstream_listen;
extern object Sstream_clear_input;
#endif
void setup_READtable();
void setup_READ();
void setup_standard_READ();
object read_char();
void unread_char();
object peek_char();
object read_object_recursive();
object read_object_non_recursive();
object read_object();
object parse_number();
object parse_integer();
object copy_readtable();
object current_readtable();
object patch_sharp();
object read_VV();

/*  reference.c  */
object symbol_function();

/*  sequence.d  */
object alloc_simple_vector();
object alloc_simple_bitvector();
object elt();
object elt_set();
int length();
object reverse();
object nreverse();

/*  structure.c  */
extern object siSstructure_print_function;
extern object siSstructure_slot_descriptions;
object structure_ref();
object structure_set();
object structure_to_list();

/*  string.d  */
object alloc_simple_string();
object make_simple_string();
bool string_eq();
bool string_equal();
object copy_simple_string();
object coerce_to_string();
bool member_char();

/*  symbol.d  */
#ifdef MTCL
#define string_register  clwp->lwp_string_register
#define gensym_prefix  clwp->lwp_gensym_prefix
#define gentemp_prefix  clwp->lwp_gentemp_prefix
#define token  clwp->lwp_token
#else
extern object string_register;
extern object gensym_prefix;
extern object gentemp_prefix;
extern object token;
#endif MTCL
struct symbol Cnil_body, Ct_body;

void setup_string_register(char *);
object make_symbol();
object make_ordinary();
object make_special();
object make_constant();
object make_si_ordinary();
object make_si_special();
object make_si_constant();
object make_keyword();
object symbol_name();
object symbol_value();
object getf();
object get();
object putf();
object putprop();
bool remf();
object remprop();
bool keywordp();

/*  dld.d  */
int dld();

/*  unixfsys.c  */
void coerce_to_filename();
FILE *backup_fopen();
int file_exists();
int file_len();

/*  unexec.c  */
int unexec();

/*  unixtime.c  */
object unix_time_to_universal_time();
int runtime();

/*  toplevel.c  */
extern object Sdeclare;
extern object siSvariable_documentation;
extern object siSfunction_documentation;

/*  typespec.c  */
extern object
St,		Snil,		Scommon,	Ssequence,
Snull,		Scons,		Slist,		Ssymbol,
Sarray,		Svector,	Sbit_vector,	Sstring,
Ssimple_array,	Ssimple_vector,	Ssimple_string,	Ssimple_bit_vector,
Sfunction,	Spathname,	Scharacter,	Scompiled_function,
Snumber,	Srational,	Sfloat,		Sstring_char,
Sinteger,	Sratio,		Sshort_float,	Sstandard_char,
Sfixnum,	Scomplex,	Ssingle_float,	Spackage,
Sbignum,	Srandom_state,	Sdouble_float,	Sstream,
Sbit,		Sreadtable,	Slong_float,	Shash_table,
Ssigned_char,	Sunsigned_char,	Ssigned_short,	Sunsigned_short;
extern object Sstructure;
extern object Ssatisfies;
extern object Smember;
extern object Snot;
extern object Sor;
extern object Sand;
extern object Svalues;
extern object Smod;
extern object Ssigned_byte;
extern object Sunsigned_byte;
extern object SA;
extern object TSor_symbol_string;
extern object TSor_string_symbol;
extern object TSor_symbol_string_package;
extern object TSnon_negative_integer;
extern object TSpositive_number;
extern object TSor_integer_float;
extern object TSor_rational_float;
#ifdef MTCL
extern object Scont;
extern object Sthread;
#endif MTCL
#ifdef CLOS
extern object Sinstance;
extern object Sdispatch_function;
#endif
#ifdef unix
object TSor_pathname_string_symbol;
#endif
object TSor_pathname_string_symbol_stream;
int check_type_array();
int check_type_vector();
int check_type_integer();
int check_type_character();
int check_type_string();
int check_type_stream();

struct let {
	object	let_var;
	object	let_spp;
	object	let_init;
};

struct iterator {
	object	iter_var;
	object	iter_spp;
	object	iter_init;
	object	iter_incr;
};
