/*
    prog.c -- Prog feature.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

/*
	anarray tinf is used in tagbody:

	   tinf_base ->	| tag1	|	where 'bodyi' is the part of tag-body
			| body1	|	that follows the tag 'tagi'.
			|   :	|
			    :		i.e.
			|   :	|	tag-body
			| tagn	|	= (...tag1..........tagn.............)
			| bodyn	|		  |		|<- bodyn ->|
	     new_top ->	|	|		  |			    |
			   VS			  |<-------- body1 -------->|
*/

Ftagbody(object body)
{
	object *tinf;
	object *lex_old = lex_env; lex_dcl;
	object id = new_frame_id();
	object bodysv = body;
	object label;
	enum type item_type;
	int r, nt;

	lex_copy();
	/* count the tags */
	for (nt = 0; !endp(body); body = CDR(body)) {
		label = CAR(body);
		item_type = type_of(label);
		if (item_type == t_symbol || item_type == t_fixnum ||
	            item_type == t_bignum) nt += 2;
	}
	{ object *tinfend, tinfs[nt];	/*  __GNUC__  */
	  tinfend = &tinfs[nt];
	  for (body = bodysv, nt = 0; !endp(body); body = CDR(body)) {
		label = CAR(body);
		item_type = type_of(label);
		if (item_type == t_symbol || item_type == t_fixnum ||
	            item_type == t_bignum) {
			lex_tag_bind(label, id);
			tinfs[nt++] = label;
			tinfs[nt++] = CDR(body);
		}
	      }
	  r = frs_push(FRS_CATCH, id);
	  body = bodysv;
	  if (r != 0) {
	    label = cdr(nlj_tag);
	    for (tinf = tinfs;
		 tinf < tinfend && !eql(tinf[0],label);
		 tinf += 2)
	      ;
	    if (tinf >= tinfend)
	      FEerror("Someone tried to RETURN-FROM a TAGBODY.",0);
	    body = tinf[1];
	  }
	  while (body != Cnil) {
	    item_type = type_of(CAR(body));
	    if (item_type != t_symbol && item_type != t_fixnum &&
		item_type != t_bignum)
	      eval(CAR(body));
	    body = CDR(body);
	  }
	}
	frs_pop();
	lex_env = lex_old;
	VALUES(0) = Cnil;
	RETURN(1);
}

Fprog(object arg)
{
	object body;
	object *lex_old = lex_env; lex_dcl;
	bds_ptr old_bds_top = bds_top;
	int nr;

	if (endp(arg))
		FEtoo_few_argumentsF(arg);

	make_nil_block(nr);

	if (nr != 0) {
		nr--;
		goto END;
	}

	{ object var_list = CAR(arg);
	  int vl = length(var_list);
	  struct let bindings[vl]; /*  __GNUC__  */

	  let_bindings(var_list, bindings);
	  body = let_bind(CDR(arg), bindings, &bindings[vl], sizeof(struct let));
	}

	nr = Ftagbody(body);

END:
	frs_pop();
	lex_env = lex_old;
	bds_unwind(old_bds_top);
	RETURN(nr);
}

FprogA(object arg)
{
	object body;
	object *lex_old = lex_env; lex_dcl;
	bds_ptr old_bds_top = bds_top;
	int nr;

	if (endp(arg))
		FEtoo_few_argumentsF(arg);

	make_nil_block(nr);

	if (nr != 0) { nr--; goto END; }

	{ object var_list = CAR(arg);
	  int vl = length(var_list);
	  struct let bindings[vl]; /*  __GNUC__  */

	  let_bindings(var_list, bindings);
	  body = letA_bind(CDR(arg), bindings, &bindings[vl], sizeof(struct let));
	}

	nr = Ftagbody(body);

END:
	frs_pop();
	lex_env = lex_old;
	bds_unwind(old_bds_top);
	RETURN(nr);
}

Fgo(object args)
{
	object lex_tag;
	frame_ptr fr;
	if (endp(args))
		FEtoo_few_argumentsF(args);
	if (!endp(CDR(args)))
		FEtoo_many_argumentsF(args);
	lex_tag = lex_tag_sch(CAR(args));
	if (Null(lex_tag))
		FEerror("~S is an undefined tag.", 1, CAR(args));
	fr = frs_sch(CADDR(lex_tag));
	if (fr == NULL)
		FEerror("The tag ~S is missing.", 1, CAR(args));
	unwind(fr, CONS(CADDR(lex_tag), CAR(lex_tag)), 1);
	/*  never reached  */
}

Fprogv(object args)
{
	object symbols, values, var;
	bds_ptr old_bds_top;
	int nr;

	if (endp(args) || endp(CDR(args)))
 		FEtoo_few_argumentsF(args);

	old_bds_top=bds_top;

	eval(CAR(args));
	symbols = VALUES(0);
	eval(CADR(args));
	values = VALUES(0);
	for (; !endp(symbols); symbols = CDR(symbols)) {
		var = CAR(symbols);

		if (type_of(var)!=t_symbol) not_a_symbol(var);
		if ((enum stype)var->s.s_stype == stp_constant)
			FEerror("Cannot bind the constant ~S.", 1, var);

		if (endp(values)) {
			bds_bind(var, OBJNULL);
		} else {
			bds_bind(var, CAR(values));
			values=CDR(values);
		}
	}

	nr = Fprogn(CDDR(args));

	bds_unwind(old_bds_top);
	RETURN(nr);
}

Fprogn(object body)
{
	if (endp(body)) {
	  	VALUES(0) = Cnil;
		RETURN(1);
	} else {
		int nr;
		do {
			nr = eval(CAR(body));
			body=CDR(body);
		} while (!endp(body));
		RETURN(nr);
	}
}

/* should be a macro. Beppe */
Fprog1(object arg)
{
	object value;

	if (endp(arg))
		FEtoo_few_argumentsF(arg);
	eval(CAR(arg));
	value = VALUES(0);
	for(arg = CDR(arg);  !endp(arg); arg = CDR(arg))
		eval(CAR(arg));
	VALUES(0) = value;
	RETURN(1);
}

/* should be a macro. Beppe */
Fprog2(object arg)
{
	object value;

	if (endp(arg) || endp(CDR(arg)))
		FEtoo_few_argumentsF(arg);
	eval(CAR(arg));
	arg = CDR(arg);
	eval(CAR(arg));
	value = VALUES(0);
	for(arg = CDR(arg);  !endp(arg); arg = CDR(arg))
		eval(CAR(arg));
	VALUES(0) = value;
	RETURN(1);
}

init_prog()
{
	make_special_form("TAGBODY", Ftagbody);
	make_special_form("PROG", Fprog);
	make_special_form("PROG*", FprogA);
	make_special_form("GO", Fgo);
	make_special_form("PROGV", Fprogv);
	make_special_form("PROGN",Fprogn);
	make_special_form("PROG1",Fprog1);
	make_special_form("PROG2",Fprog2);
}
