/*
    init.c  -- Lisp Initialization.
*/
/*
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/

#include "config.h"

extern char system_directory[];

init_lisp()
{
	init_alloc();
	init_symbol();
	init_package();
	init_typespec();
	init_number();
	init_character();
	init_file();
	init_read();
	init_print();
	init_bind();
	init_pathname();
	init_GC();
#ifdef unix
	init_load();
	init_unixsys();
#endif unix
	init_alloc_function();
	init_array_function();
	init_character_function();
	init_file_function();
	init_list_function();
	init_package_function();
	init_predicate_function();
	init_pathname_function();
	init_print_function();
	init_read_function();
	init_cfun();
	init_sequence_function();
	init_structure_function();
	init_string_function();
	init_symbol_function();
	init_typespec_function();
#ifdef TCP
	init_tcp();
#endif TCP
#ifdef THREADS
	init_lwp();
#endif THREADS
#ifdef CLOS
	init_instance();
	init_clos();
	init_gfun();
#endif CLOS
#ifdef LOCATIVE
	init_unify();
#endif LOCATIVE
	init_hash();
#ifdef unix
	init_unixfsys();
	init_unixtime();
#endif unix
	init_eval();
	init_lex();
	init_reference();
	init_assignment();
	init_error();
	init_toplevel();
	init_conditional();
	init_catch();
	init_macros();
	init_let();
	init_prog();
	init_block();
	init_multival();
	init_mapfun();
	init_iteration();
	init_cmpaux();
	init_main();
	init_format();
	init_interrupt();

	init_libs();
#ifdef COMPILER_IN_KERNEL
	init_compiler();
#endif COMPILER_IN_KERNEL
	Vpackage->s.s_dbind = user_package;
}

static object
merge_system_directory(char *s)
{
	static char buff[MAXPATHLEN];
	extern char *strcat();

	strcpy(buff, system_directory);
	return(make_simple_string(strcat(buff, s)));
}

init_libs()
{
	object stream;

	Lload(3, merge_system_directory("lsp/export.lsp"), Kverbose, Cnil);
	stream = open_stream(make_simple_string("lsp/defmacro.data"),
			     smm_input, Cnil, Kerror);
	init_defmacro(0, stream);
#ifndef RUNTIME
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/evalmacros.data"),
			     smm_input, Cnil, Kerror);
	init_evalmacros(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/top.data"),
			     smm_input, Cnil, Kerror);
	init_top(0, stream);
	close_stream(stream, TRUE);
#endif RUNTIME
	stream = open_stream(make_simple_string("lsp/module.data"),
			     smm_input, Cnil, Kerror);
	init_module(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/setf.data"),
			     smm_input, Cnil, Kerror);
	init_setf(0, stream);
	close_stream(stream, TRUE);
	Lload(3, merge_system_directory("lsp/autoload.lsp"), Kverbose, Cnil);


	stream = open_stream(make_simple_string("lsp/predlib.data"),
			     smm_input, Cnil, Kerror);
	init_predlib(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/arraylib.data"),
			     smm_input, Cnil, Kerror);
	init_arraylib(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/assert.data"),
			     smm_input, Cnil, Kerror);
	init_assert(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/defstruct.data"),
			     smm_input, Cnil, Kerror);
	init_defstruct(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/describe.data"),
			     smm_input, Cnil, Kerror);
	init_describe(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/iolib.data"),
			     smm_input, Cnil, Kerror);
	init_iolib(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/listlib.data"),
			     smm_input, Cnil, Kerror);
	init_listlib(0, stream);
	close_stream(stream, TRUE);
#ifdef ANSI
	stream = open_stream(make_simple_string("lsp/loop.data"),
			     smm_input, Cnil, Kerror);
	init_loop(0, stream);
	close_stream(stream, TRUE);
#endif ANSI
	stream = open_stream(make_simple_string("lsp/mislib.data"),
			     smm_input, Cnil, Kerror);
	init_mislib(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/numlib.data"),
			     smm_input, Cnil, Kerror);
	init_numlib(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/packlib.data"),
			     smm_input, Cnil, Kerror);
	init_packlib(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/seq.data"),
			     smm_input, Cnil, Kerror);
	init_seq(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/seqlib.data"),
			     smm_input, Cnil, Kerror);
	init_seqlib(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("lsp/trace.data"),
			     smm_input, Cnil, Kerror);
	init_trace(0, stream);
	close_stream(stream, TRUE);
#ifdef THREADS
	stream = open_stream(make_simple_string("lsp/thread.data"),
			     smm_input, Cnil, Kerror);
	init_thread(0, stream);
	close_stream(stream, TRUE);
#endif THREADS
      }

#ifdef COMPILER_IN_KERNEL
init_compiler()
{
	object stream;

	stream = open_stream(make_simple_string("cmp/cmpdefs.data"),
			     smm_input, Cnil, Kerror);
	init_cmpdefs(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpinline.data"),
			     smm_input, Cnil, Kerror);
	init_cmpinline(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmputil.data"),
			     smm_input, Cnil, Kerror);
	init_cmputil(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmptype.data"),
			     smm_input, Cnil, Kerror);
	init_cmptype(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpbind.data"),
			     smm_input, Cnil, Kerror);
	init_cmpbind(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpblock.data"),
			     smm_input, Cnil, Kerror);
	init_cmpblock(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpcall.data"),
			     smm_input, Cnil, Kerror);
	init_cmpcall(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpcatch.data"),
			     smm_input, Cnil, Kerror);
	init_cmpcatch(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpenv.data"),
			     smm_input, Cnil, Kerror);
	init_cmpenv(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpeval.data"),
			     smm_input, Cnil, Kerror);
	init_cmpeval(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpflet.data"),
			     smm_input, Cnil, Kerror);
	init_cmpflet(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpfun.data"),
			     smm_input, Cnil, Kerror);
	init_cmpfun(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpif.data"),
			     smm_input, Cnil, Kerror);
	init_cmpif(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpexit.data"),
			     smm_input, Cnil, Kerror);
	init_cmpexit(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmplam.data"),
			     smm_input, Cnil, Kerror);
	init_cmplam(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmplet.data"),
			     smm_input, Cnil, Kerror);
	init_cmplet(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmploc.data"),
			     smm_input, Cnil, Kerror);
	init_cmploc(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpmap.data"),
			     smm_input, Cnil, Kerror);
	init_cmpmap(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpmulti.data"),
			     smm_input, Cnil, Kerror);
	init_cmpmulti(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpspecial.data"),
			     smm_input, Cnil, Kerror);
	init_cmpspecial(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmptag.data"),
			     smm_input, Cnil, Kerror);
	init_cmptag(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmptop.data"),
			     smm_input, Cnil, Kerror);
	init_cmptop(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpvar.data"),
			     smm_input, Cnil, Kerror);
	init_cmpvar(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpwt.data"),
			     smm_input, Cnil, Kerror);
	init_cmpwt(0, stream);
	close_stream(stream, TRUE);
	stream = open_stream(make_simple_string("cmp/cmpmain.data"),
			     smm_input, Cnil, Kerror);
	init_cmpmain(0, stream);
	close_stream(stream, TRUE);
}
#endif COMPILER_IN_KERNEL
