/*
    frame.c -- Frame and non-local jump.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

int frame_id = 0;

void unwind(frame_ptr fr, object tag, int nr)
{
	nlj_fr = fr;
	nlj_tag = tag;
	while (frs_top != fr
		&& frs_top->frs_class == FRS_CATCH)
	  --frs_top;
	lex_env = frs_top->frs_lex;
	ihs_top = frs_top->frs_ihs;
	bds_unwind(frs_top->frs_bds_top);
	_longjmp(frs_top->frs_jmpbuf, nr);
	/* never reached */
}

frame_ptr frs_sch (object frame_id)
{
	frame_ptr top;

	for (top = frs_top;  top >= frs_org;  top--)
		if (top->frs_val == frame_id && top->frs_class == FRS_CATCH)
			return(top);
	return(NULL);
}

frame_ptr frs_sch_catch(object frame_id)
{
	frame_ptr top;

	for(top = frs_top;  top >= frs_org  ;top--)
		if (top->frs_val == frame_id && top->frs_class == FRS_CATCH
		    || top->frs_class == FRS_CATCHALL
		   )
			return(top);
	return(NULL);
}

object
new_frame_id()
{
  return(MAKE_FIXNUM(frame_id++));
}
