/* keymaps.c -- changed by Bruno Haible, 31 October 1993 */

/* keymaps.c -- Functions and keymaps for the GNU Readline library. */

/* Copyright (C) 1988, 1989, 1991 Free Software Foundation, Inc.

   This file is part of GNU Readline, a library for reading lines
   of text with interactive input and history editing.

   Readline is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Readline is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "sysdep.h"
#include <stdio.h>
#include "readline.h"
#include "keymaps.h"
#include "emacs_keymap.c"

#ifdef VI_MODE
#include "vi_keymap.c"
#endif

/* Remove these declarations when we have a complete libgnu.a. */
/* #define STATIC_MALLOC */
#if !defined (STATIC_MALLOC)
extern char *xmalloc RL((int bytes));
extern char *xrealloc RL((void *pointer, int bytes));
#else
static char *xmalloc RL((int bytes));
static char *xrealloc RL((void *pointer, int bytes));
#endif /* STATIC_MALLOC */

/* **************************************************************** */
/*								    */
/*		      Functions for manipulating Keymaps.	    */
/*								    */
/* **************************************************************** */


/* Return a new, empty keymap.
   Free it with free() when you are done. */
Keymap
rl_make_bare_keymap ()
{
  register int i;
  Keymap keymap = (Keymap)xmalloc (NUMCHARS * sizeof (KEYMAP_ENTRY));

  for (i = 0; i < NUMCHARS; i++)
    {
      keymap[i].type = ISFUNC;
      keymap[i].function = (Function *)NULL;
    }

  for (i = 'A'; i < ('Z' + 1); i++)
    {
      keymap[i].type = ISFUNC;
      keymap[i].function = (Function *)rl_do_lowercase_version;
    }

  return (keymap);
}

/* Return a new keymap which is a copy of MAP. */
Keymap
rl_copy_keymap (map)
     Keymap map;
{
  register int i;
  Keymap temp = rl_make_bare_keymap ();

  for (i = 0; i < NUMCHARS; i++)
    {
      temp[i].type = map[i].type;
      temp[i].function = map[i].function;
    }
  return (temp);
}

/* Return a new keymap with the printing characters bound to rl_insert,
   the uppercase Meta characters bound to run their lowercase equivalents,
   and the Meta digits bound to produce numeric arguments. */
Keymap
rl_make_keymap ()
{
  register int i;
  Keymap newmap;

  newmap = rl_make_bare_keymap ();

  /* All printing characters are self-inserting. */
  for (i = ' '; i < NUMCHARS; i++)
    if (i != 127)
      newmap[i].function = (Function *)rl_insert;

  newmap[TAB].function = (Function *)rl_insert;
  newmap[RUBOUT].function = (Function *)rl_rubout;
  newmap[CTRL('H')].function = (Function *)rl_rubout;

  return (newmap);
}

/* Free the storage associated with MAP. */
usable void
rl_discard_keymap (map)
     Keymap (map);
{
  int i;

  if (!map)
    return;

  for (i = 0; i < NUMCHARS; i++)
    {
      switch (map[i].type)
	{
	case ISFUNC:
	  break;

	case ISKMAP:
	  rl_discard_keymap ((Keymap)map[i].function);
	  break;

	case ISMACR:
	  free ((char *)map[i].function);
	  break;
	}
    }
}

#ifdef STATIC_MALLOC

/* **************************************************************** */
/*								    */
/*			xmalloc and xrealloc ()		     	    */
/*								    */
/* **************************************************************** */

static void memory_error_and_abort RL((void));

static char *
xmalloc (bytes)
     int bytes;
{
  char *temp = (char *)malloc (bytes);

  if (!temp)
    memory_error_and_abort ();
  return (temp);
}

static char *
xrealloc (pointer, bytes)
     char *pointer;
     int bytes;
{
  char *temp;

  if (!pointer)
    temp = (char *)malloc (bytes);
  else
    temp = (char *)realloc (pointer, bytes);

  if (!temp)
    memory_error_and_abort ();
  return (temp);
}

static void
memory_error_and_abort ()
{
  fprintf (stderr, "readline: Out of virtual memory!\n");
  abort ();
}
#endif /* STATIC_MALLOC */
