;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Module: timers
;;;                       Version: 1.0
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/kernel/timers.lisp
;;; File Creation Date: 07/21/92 08:44:59
;;; Last Modification Time: 07/22/92 11:27:17
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :xit)

#||
;;Example:

(make-gio 'text-dispel
	  :x 100 :y 100
	  :text "Blink" :font '(:size 24)
	  :border-width 2
	  :background "white"
	  :timer 1 ;; means 1 second interval
	  :reactivity-entries '((:timer (call :self flash-window))))
||#

(defvar *default-timer-name* :default)

(defclass timer-mixin ()
  ())

(defmethod initialize-instance :after ((self timer-mixin)
				       &rest init-list
				       &key timer)
  (declare (ignore init-list))
  (when timer
    (set-timer self timer)))

(defmethod set-timer ((self timer-mixin) interval
		      &key (name *default-timer-name*) value)
  (add-timer self name interval value))

(defmethod remove-timer ((self timer-mixin) &optional (name *default-timer-name*))
  (delete-timer self name))

(defmethod timers ((self timer-mixin))
  (with-slots (display) self
    (delete nil
	    (mapcar #'(lambda (timer)
			(when (eq (cluei::timer-contact timer) self)
			  timer))
		    (cluei::timer-queue display)))))

(defmethod timer-names ((self timer-mixin))
  (mapcar #'cluei::timer-name (timers self)))

(defmethod timer ((self timer-mixin) &optional (name *default-timer-name*))
  (with-slots (display) self
    (find-if #'(lambda (timer)
		 (and (eq (cluei::timer-contact timer) self)
		      (equal (cluei::timer-name timer) name)))
	     (cluei::timer-queue display))))

(defmethod timer-value ((self timer-mixin) &optional (name *default-timer-name*))
  (let ((timer (timer self name)))
    (when timer
      (cluei::timer-data timer))))

(defmethod (setf timer-value) (value (self timer-mixin)
			       &optional (name *default-timer-name*))
  (let ((timer (timer self name)))
    (when timer
      (setf (cluei::timer-data timer) value)))
  value)

(defmethod timer-interval ((self timer-mixin)
			   &optional (name *default-timer-name*))
  (let ((timer (timer self name)))
    (when timer
      (/ (cluei::timer-interval timer) internal-time-units-per-second))))

(defmethod (setf timer-interval) (value (self timer-mixin)
				  &optional (name *default-timer-name*))
  (let ((timer (timer self name)))
    (when timer
      (add-timer self name value (cluei::timer-data timer))))
  value)
