;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Module: Examples
;;;                       (Version 1.0)
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/examples/slider-examples.lisp
;;; File Creation Date: 09/14/90 10:33:57
;;; Last Modification Time: 06/02/92 16:03:57
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :xit)

;_______________________________________________________________________________
(proclaim '(special demo-window icon-menu slider-window
	    slider-1   *display*))

(setq slider-window
      (make-window 'intel-example-window
		   :x 200 :y 80 :width 550 :height 300
		   :window-icon `(intel-example-icon :parent ,icon-menu
						     :text "Sliders")
		   :title "Sliders"))

(setq slider-1
  (make-window 'captioned-slider
			    :parent slider-window
			    :view-of demo-window
			    :x 45 :y 35
			    :labelled-slider-part
			    `(:low-label-part (:text "0")
			      :high-label-part (:text "10")
			      :orientation :up
			      :slider-part
			      (:class integer-slider
				      :width 100 :height 160
				      :max 10 :min 0
				      :move-action change-window-border-width
				      :knob-part (:background "LightSteelBlue")
				      ))
			    :caption-part '(:text "Border Width")))

(setq slider-2
  (make-window 'captioned-slider
			    :parent slider-window
			    :x 200 :y 100
			    :view-of demo-window
			    :labelled-slider-part
			    `(:low-label-part (:text "left")
			      :high-label-part (:text "right")
			      :orientation :right
			      :slider-part
			      (:class integer-slider
				      :orientation :right
				      :width 250 :height 50
				      :max 400 :min 0
				      :move-action change-window-x
				      :knob-part (:background "Wheat3"
						  :width 20)
				      ))
			    :caption-part '(:text "X Position")))


    
				   
(update-state *display*)
(process-all-events *display*)

(shrink slider-window)

(update-state *display*)
(process-all-events *display*)
