


CLISP(1)                 USER COMMANDS                   CLISP(1)



NAME
     clisp - Common Lisp language interpreter and compiler

SYNOPSIS
     clisp [ -h ] [ -m _m_e_m_s_i_z_e ] [ -M _m_e_m_f_i_l_e ] [ -q ] [ -i _i_n_i_t_-
     _f_i_l_e ...  ] [ -c [ -l ] _l_i_s_p_f_i_l_e ...  ] [ -x _e_x_p_r_e_s_s_i_o_n ]

DESCRIPTION
     Invokes the common lisp interpreter and  compiler.   Invoked
     without arguments, executes a read-eval-print loop, in which
     expressions are in turn read from standard input,  evaluated
     by  the  lisp interpreter, and their results output to stan-
     dard output.  Invoked with -c, the specified lisp files  are
     compiled  to  a  bytecode  that  can  be executed more effi-
     ciently.

OPTIONS
     -h   Displays a help message on how to use clisp.

     -m _m_e_m_s_i_z_e
          Sets the amount  of  memory  clisp  tries  to  grab  on
          startup.   The amount may be given as _n_n_n_n_n_n_n (measured
          in bytes), _n_n_n_nK or _n_n_n_nKB (measured in  kilobytes)  or
          _nM  or  _nMB  (measured  in  megabytes).  Default is 2.5
          megabytes.  The argument is constrained between 100  KB
          and  16  MB.  -- This version of _c_l_i_s_p allocates memory
          dynamically.  _m_e_m_s_i_z_e is essentially ignored.

     -M _m_e_m_f_i_l_e
          Specifies the initial memory image.   This  must  be  a
          memory dump produced by the _s_a_v_e_i_n_i_t_m_e_m function.  This
          option is normally already  set  by  the  shell  script
          /usr/local/bin/clisp.

     -q   Quiet: clisp displays  no  banner  at  startup  and  no
          good-bye message when quitting.

     -i _i_n_i_t_f_i_l_e ...
          Specifies initialization files to be _l_o_a_ded at startup.
          These should be lisp files (source or compiled).

     -c _l_i_s_p_f_i_l_e ...
          Compiles the specified lispfiles to bytecode. The  com-
          piled  files  can then be _l_o_a_ded instead of the sources
          to gain efficiency.

     -l   A bytecode listing of the files being compiled will  be
          produced.  Useful only for debugging purposes.

     -x _e_x_p_r_e_s_s_i_o_n_s
          Executes a series of arbitrary expressions instead of a
          read-eval-print  loop.   The  values of the expressions



Sun Release 4.1    Last change: 16 August 1993                  1






CLISP(1)                 USER COMMANDS                   CLISP(1)



          will be output to standard output.  Due to the argument
          processing  done  by the shell, the _e_x_p_r_e_s_s_i_o_n_s must be
          enclosed  in  single  quotes,  and  double  quotes  and
          backslashes must be preceded by backslashes.

REFERENCE
     The language implemented conforms to
            Guy L. Steele Jr.: Common Lisp - The Language.
            Digital Press. 1st edition 1984, 465 pages.
            ("CLtL1" for short)
     and to the older parts of
            Guy L. Steele Jr.: Common Lisp - The Language.
            Digital Press. 2nd edition 1990, 1032 pages.
            ("CLtL2" for short)

USE
     help to get some on-line help.

     (apropos _n_a_m_e)
          lists the symbols relating to _n_a_m_e.

     (exit) or (quit) or (bye)
          to quit clisp.

     EOF (Ctrl-D)
          to leave the current read-eval-print loop.

     arrow keys
          for editing and viewing the input history.

     Tab key
          to complete the symbol's name you are just typing.

FILES
     _c_l_i_s_p
          startup script

     _l_i_s_p._r_u_n
          main executable

     _l_i_s_p_i_n_i_t._m_e_m
          initial memory image

     _c_o_n_f_i_g._l_s_p
          site-dependent configuration

     *._l_s_p
          lisp source

     *._f_a_s
          lisp code, compiled by clisp




Sun Release 4.1    Last change: 16 August 1993                  2






CLISP(1)                 USER COMMANDS                   CLISP(1)



     *._l_i_b
          lisp source library information, generated and used  by
          the clisp compiler

ENVIRONMENT
     HOME and USER
          are used for determining  the  value  of  the  function
          _u_s_e_r-_h_o_m_e_d_i_r-_p_a_t_h_n_a_m_e.  (Unix implementation only.)

     SHELL (Unix implementation only)
          is used to find the command interpreter called  by  the
          function _s_h_e_l_l.

     TERM determines the screen size  recognized  by  the  pretty
          printer.   This  environment variable is also mandatory
          for the built-in screen editor.

SEE ALSO
     _c_m_u_l_i_s_p(1), _e_m_a_c_s(1).

BUGS
     The function _i_n_s_p_e_c_t is not implemented.

     Only very few extensions from CLtL2 are supported.

     No on-line documentation  beyond  _a_p_r_o_p_o_s  and  _d_e_s_c_r_i_b_e  is
     available.

PROJECTS
     Writing on-line documentation.

     Building a foreign function interface  (ability  to  call  C
     code directly).

     Write _i_n_s_p_e_c_t.

     Enhance the compiler such that it  can  inline  local  func-
     tions.

     Specify a portable set of window and graphics operations.

AUTHORS
     Bruno Haible <haible@ma2s2.mathematik.uni-karlsruhe.de>  and
     Michael Stoll.











Sun Release 4.1    Last change: 16 August 1993                  3



