;;; CLtL2-kompatible Definitionen
;;; Bruno Haible 20.5.1993

; List of X3J13 votes and their current status in CLISP
;
; Number: from CLtL2, Index of X3J13 Votes.
; Status: indicates whether CLISP supports code that makes use of this vote.
;
; Number Title                               Status          Files affected
;
;   <1>  ADJUST-ARRAY displacement           yes             array.d
;   <2>  ADJUST-ARRAY :FILL-POINTER          yes             array.d
;   <3>  ADJUST-ARRAY not adjustable         no              array.d
;   <4>  allow local INLINE                  yes             compiler.lsp, init.lsp
;   <5>  APPLYHOOK environment               yes             eval.d
;   <6>  AREF 1D                             no              array.d
;   <7>  arguments underspecified            yes
;   <8>  array type/element type semantics   yes for arrays  type.lsp
;                                            no for complex numbers
;   <9>  ASSOC/RASSOC-IF :KEY                yes             list.d
;  <10>  *BREAK-ON-WARNINGS* obsolete        no              user1.lsp
;  <11>  character proposal                  no
;  <12>  CLOS                                no
;  <13>  CLOS macro compilation              no
;  <14>  CLOSE constructed stream            yes             stream.d
;  <15>  closed stream operations            yes             stream.d
;  <16>  colon-number                        yes             io.d
;  <17>  COMMON type                         no              predtype.d, type.lsp
;  <18>  COMPILE argument problems           yes             compiler.lsp
;  <19>  compile environment consistency     yes             compiler.lsp
;  <20>  COMPILE-FILE handling of top-level forms
;                                            yes             compiler.lsp
;  <21>  COMPILE-FILE & *PACKAGE*            yes             compiler.lsp
;  <22>  COMPILE-FILE symbol handling        yes             compiler.lsp
;  <23>  COMPILED-FUNCTION requirements      yes             compiler.lsp
;  <24>  compiler diagnostics                no              compiler.lsp
;  <25>  COMPILER-LET confusion              no              control.d, init.lsp, compiler.lsp
;  <26>  compiler verbosity                  no              compiler.lsp
;  <27>  compiler warning stream             yes             compiler.lsp
;  <28>  complex ATAN branch cut             yes             comptran.d
;  <28a> complex ATANH branch cut            yes             comptran.d
;  <29>  (COMPLEX RATIONAL) result           yes             compelem.d, comptran.d
;  <30>  condition system                    no              user1.lsp
;  <31>  condition restarts                  no              user1.lsp
;  <32>  constant circular compilation       yes             compiler.lsp
;  <33>  constant collapsing                 yes             compiler.lsp
;  <34>  constant compilable types           no for packages
;                                            yes for anything else
;  <35>  constant function compilation       yes
;  <36>  constant modification               yes
;  <37>  contagion on numerical comparisons  yes             realelem.d, flo_rest.d
;  <38>  COPY-SYMBOL copy plist              yes             defs1.lsp
;  <39>  COPY-SYMBOL print name              yes             defs1.lsp, package.d
;  <40>  data I/O                            no              io.d
;  <41>  data types hierarchy unspecified    yes             lispbibl.d
;  <42>  declaration scope                   no
;  <43>  declare array type & element references
;                                            yes
;  <44>  declare function ambiguity          yes
;  <45>  declare macros                      no              eval.d, compiler.lsp
;  <46>  declare type free                   yes
;  <47>  DECODE-UNIVERSAL-TIME daylight      yes             defs1.lsp
;  <48>  DEFCONSTANT special                 yes             control.d, compiler.lsp
;  <49>  DEFINE-COMPILER-MACRO               no              defs2.lsp
;  <50>  defining macros non top-level       no
;  <51>  DEFMACRO lambda-list                yes             defmacro.lsp
;  <52>  DEFPACKAGE                          yes             defs2.lsp
;  <53>  DEFSTRUCT constructor/key mixture   no              defstruc.lsp
;  <54>  DEFSTRUCT default value evaluation  yes             defstruc.lsp
;  <55>  DEFSTRUCT :PRINT-FUNCTION inheritance
;                                            no              defstruc.lsp
;  <56>  DEFSTRUCT redefinition              yes             defstruc.lsp
;  <57>  DEFSTRUCT slots constraints: name   no              defstruc.lsp
;  <58>  DEFSTRUCT slots constraints: number yes             defstruc.lsp
;  <59>  DEFVAR documentation                yes             macros1.lsp
;  <60>  DEFVAR init time                    yes             macros1.lsp
;  <61>  DEFVAR initialization               yes             macros1.lsp
;  <62>  DESCRIBE interactive                yes             user2.lsp
;  <63>  DESCRIBE underspecified             no              user2.lsp, clos.lsp
;  <64>  DESTRUCTURING-BIND                  no              defmacro.lsp
;  <65>  DISASSEMBLE side effect             yes             compiler.lsp
;  <66>  DO-SYMBOLS duplicates               yes             defs1.lsp, package.d
;  <67>  dotted macro forms                  yes
;  <68>  DRIBBLE technique                   yes             user2.lsp
;  <69>  DYNAMIC-EXTENT                      no
;  <70>  DYNAMIC-EXTENT & function           no
;  <71>  EQUAL & structure                   yes for EQUAL   predtype.d
;                                            no for EQUALP
;  <72>  EVAL other                          no              eval.d, compiler.lsp
;  <73>  EVAL-WHEN non top-level             no              control.d, init.lsp, compiler.lsp
;  <74>  exit extent                         yes
;  <75>  EXPT & ratio                        yes             comptran.d
;  <76>  FIXNUM non-portable                 no              array.d
;  <77>  FLET declarations                   no
;  <78>  FLET implicit block                 no
;  <79>  float underflow                     no
;  <80>  FORMAT atsign & colon               yes             format.lsp
;  <81>  FORMAT colon uparrow scope          no              format.lsp
;  <82>  FORMAT comma-interval               no              format.lsp
;  <83>  FORMAT ~E exponent-sign             yes             format.lsp
;  <84>  FORMAT op C                         no              format.lsp
;  <85>  FORMAT & pretty print               yes             format.lsp
;                                            no: ~E, ~F, ~G, ~$ also bind *PRINT-BASE* to 10 and *PRINT-RADIX* to NIL
;  <86>  function call & evaluation order    yes
;  <87>  function composition                no              defs2.lsp
;  <88>  function definition                 yes             defs2.lsp
;  <89>  function name                       no
;  <90>  FUNCTION type                       no              predtype.d, type.lsp, compiler.lsp
;  <91>  FUNCTION type: argument type semantics
;                                            yes
;  <92>  FUNCTION type: &KEY name            yes
;  <93>  FUNCTION type: &REST list element   yes
;  <94>  GENSYM name stickiness              no              symbol.d
;  <95>  GET-MACRO-CHARACTER readtable       no              io.d
;  <96>  GET-SETF-METHOD environment         yes             places.lsp
;  <97>  hash-table access                   no              hashtabl.d
;  <98>  hash-table & package generators     no              hashtabl.d, package.d, defs2.lsp
;  <99>  hash-table size                     yes             hashtabl.d
; <100>  hash-table tests                    no              hashtabl.d
; <101>  IEEE & ATAN branch cut              yes
; <102>  IMPORT & SETF SYMBOL-PACKAGE        no              package.d
; <103>  IN-PACKAGE functionality            no              package.d, compiler.lsp
; <104>  in syntax                           yes             init.lsp, compiler.lsp
; <105>  keyword argument name package       no
; <106>  LAST n                              no              list.d
; <107>  LCM no arguments                    yes             lisparit.d
; <108>  LISP package name                   no
; <109>  LISP symbol redefinition            yes
; <110>  LOAD & objects                      no
; <111>  LOAD-TIME-VALUE                     yes             control.d, init.lsp, compiler.lsp
; <112>  *LOAD-TRUENAME*                     no              init.lsp
; <113>  LOCALLY top level                   no              control.d, init.lsp, compiler.lsp
; <114>  LOOP AND discrepancy                no              loop.lsp
; <115>  LOOP facility                       no              loop.lsp
; <116>  macro caching                       yes
; <117>  macro environment extent            yes
; <118>  MACRO-FUNCTION environment          no              control.d, compiler.lsp
; <119>  MAKE-PACKAGE :USE default           yes
; <120>  MAP-INTO                            no              sequence.d
; <121>  mapping & destructive: interaction  yes             sequence.d, list.d, hashtabl.d, package.d
; <122>  more character proposal             no              charstrg.d, stream.d
; <123>  NTH-VALUE                           yes             defs2.lsp
; <124>  OPTIMIZE DEBUG info                 no              init.lsp
; <125>  package clutter                     no              init.lsp
; <126>  package deletion                    no              package.d
; <127>  package function consistency        no              package.d
; <128>  pathname: component case            no              pathname.d
; <129>  pathname: component value           no              pathname.d
; <130>  pathname: logical                   no              pathname.d
; <131>  pathname: print & read              no              io.d
; <132>  pathname: stream                    no              pathname.d, stream.d
; <133>  pathname: subdirectory list         no              pathname.d
; <134>  pathname: symbol                    no              pathname.d, stream.d
; <135>  pathname: syntax error time         yes             pathname.d
; <136>  pathname: unspecific component      no              pathname.d
; <137>  pathname: :WILD                     no              pathname.d
; <138>  PEEK-CHAR, READ-CHAR & echo         no              io.d, stream.d
; <139>  pretty-print interface              no              xp.lsp
; <140>  PRINC character                     yes             io.d
; <141>  *PRINT-CASE* / *PRINT-ESCAPE* interaction
;                                            no              io.d
; <142>  *PRINT-CIRCLE* shared               yes             io.d
; <143>  *PRINT-CIRCLE* structure            yes             io.d
; <144>  PROCLAIM etc. in COMPILE-FILE       no              defs2.lsp
; <145>  PROCLAIM INLINE: where              yes             compiler.lsp
; <146>  PUSH & evaluation order             yes             places.lsp
; <147>  QUOTE semantics                     yes
; <148>  range of :COUNT keyword             no              sequence.d
; <149>  range of start and end parameters   no for SUBSEQ   sequence.d
;                                            yes for anything else
; <150>  READ: case sensitivity              no              io.d
; <151>  REAL number type                    yes             predtype.d, type.lsp
; <152>  REDUCE argument extraction          no              sequence.d
; <153>  REMF & destruction: unspecified     no for NRECONC  list.d
;                                            yes for anything else
; <154>  REQUIRE pathname defaults           no              defs1.lsp
; <155>  &REST list allocation               yes             eval.d
; <156>  return values unspecified           yes             macros1.lsp, package.d, io.d
; <157>  ROOM :DEFAULT argument              no              debug.d
; <158>  sequence type & length              no              sequence.d, predtype.d
; <159>  SETF & multiple store variables     yes for SETF    places.lsp
;                                            no for SHIFTF, ROTATEF, ASSERT
; <160>  SETF & sub-methods                  yes             places.lsp
; <161>  SHADOW: already present             yes             package.d
; <162>  sharp-comma confusion               no              io.d
; <163>  sharpsign-plus/minus package        no              io.d, spvw.d, init.lsp, compiler.lsp
; <164>  special type-shadowing              yes
; <165>  *STANDARD-INPUT* initial binding    yes             stream.d
; <166>  STEP environment                    yes             user1.lsp, macros2.lsp
; <167>  stream access                       no              stream.d
; <168>  stream capabilities                 yes             stream.d
; <169>  string coercion                     yes             charstrg.d
; <170>  SUBSEQ out of bounds                yes             sequence.d
; <171>  SUBTYPEP too vague                  yes             type.lsp
; <172>  SYMBOL-MACROLET & DECLARE           no
; <173>  SYMBOL-MACROLET semantics           no
; <174>  syntactic environment access        no
; <175>  TAILP & NIL                         no              list.d
; <176>  :TEST-NOT, -IF-NOT                  no              sequence.d, list.d
; <177>  THE ambiguity                       yes
; <178>  time-zone non-integer               yes             defs1.lsp
; <179>  TYPE-OF underconstrained            yes             predtype.d
; <180>  undefined variables and functions   yes
; <181>  UNREAD-CHAR after PEEK-CHAR         yes             stream.d
; <182>  variable list asymmetry             yes             macros1.lsp
; <183>  WITH-COMPILATION-UNIT               no              compiler.lsp
; <184>  WITH-OPEN-FILE & does-not-exist     yes             macros2.lsp
; <185>  WITH-OUTPUT-TO-STRING append style  yes             macros2.lsp
; <186>  ZLOS conditions                     no              user1.lsp

;===============================================================================

(in-package "LISP")
(export '(nth-value function-lambda-expression defpackage))
(in-package "SYSTEM")

;-------------------------------------------------------------------------------

;; Macro (nth-value n form) == (nth n (multiple-value-list form)), CLtL2 S. 184
(defmacro nth-value (n form)
  (if (and (integerp n) (>= n 0))
    (if (< n (1- multiple-values-limit))
      (if (= n 0)
        `(PROG1 ,form)
        (let ((resultvar (gensym)))
          (do ((vars (list resultvar))
               (ignores nil)
               (i n (1- i)))
              ((zerop i)
               `(MULTIPLE-VALUE-BIND ,vars ,form
                  (DECLARE (IGNORE ,@ignores))
                  ,resultvar
              ) )
            (let ((g (gensym))) (push g vars) (push g ignores))
      ) ) )
      `(PROGN ,form NIL)
    )
    `(NTH ,n (MULTIPLE-VALUE-LIST ,form))
) )

;-------------------------------------------------------------------------------

;; Interpretierte Funktion in Lambda-Ausdruck umwandeln, CLtL2 S. 682
(defun function-lambda-expression (obj)
  (unless (sys::closurep obj)
    (error #+DEUTSCH "~: ~ ist keine Funktion."
           #+ENGLISH "~: ~ is not a function"
           'function-lambda-expression obj
  ) )
  (if (not (compiled-function-p obj))
    (values (cons 'LAMBDA (sys::%record-ref obj 1)) ; Lambda-Ausdruck ohne Docstring
            (vector ; Environment
                    (sys::%record-ref obj 4) ; venv
                    (sys::%record-ref obj 5) ; fenv
                    (sys::%record-ref obj 6) ; benv
                    (sys::%record-ref obj 7) ; genv
                    (sys::%record-ref obj 8) ; denv
            )
            (sys::%record-ref obj 0) ; Name
    )
    (values nil t nil)
) )

;-------------------------------------------------------------------------------

;; Package-Definition und -Installation, CLtL2 S. 270
(defmacro defpackage (packname &rest options)
  (flet ((check-packname (name)
           (cond ((stringp name) name)
                 ((symbolp name) (symbol-name name))
                 (t (error #+DEUTSCH "~S: Package-Name mu ein String oder Symbol sein, nicht ~S."
                           #+ENGLISH "~S: package name ~S should be a string or a symbol"
                           #+FRANCAIS "~S : Le nom d'un paquetage doit tre une chane ou un symbole et non ~S."
                           'defpackage name
         ) )     )  )
         (check-symname (name)
           (cond ((stringp name) name)
                 ((symbolp name) (symbol-name name))
                 (t (error #+DEUTSCH "~S ~A: Symbol-Name mu ein String oder Symbol sein, nicht ~S."
                           #+ENGLISH "~S ~A: symbol name ~S should be a string or a symbol"
                           #+FRANCAIS "~S ~A : Le nom d'un symbole doit tre une chane ou un symbole et non ~S."
                           'defpackage packname name
        )) )     )  )
    (setq packname (check-packname packname))
    ; Optionen abarbeiten:
    (let ((size nil) ; Flag ob :SIZE schon da war
          (nickname-list '()) ; Liste von Nicknames
          (shadow-list '()) ; Liste von Symbolnamen fr shadow
          (shadowing-list '()) ; Listen von Paaren (Symbolname . Paketname) fr shadowing-import
          (use-list '()) ; Liste von Paketnamen fr use-package
          (use-default '("LISP")) ; Default-Wert fr use-list
          (import-list '()) ; Listen von Paaren (Symbolname . Paketname) fr import
          (intern-list '()) ; Liste von Symbolnamen fr intern
          (symname-list '()) ; Liste aller bisher aufgefhrten Symbolnamen
          (export-list '())) ; Liste von Symbolnamen fr export
      (flet ((record-symname (name)
               (if (member name symname-list :test #'string=)
                 (error #+DEUTSCH "~S ~A: Symbol ~A darf nur einmal aufgefhrt werden."
                        #+ENGLISH "~S ~A: the symbol ~A must not be specified more than once"
                        #+FRANCAIS "~S ~A : Le symbole ~A ne peut tre mentionn qu'une seule fois."
                        'defpackage packname name
                 )
                 (push name symname-list)
               )
               name
            ))
        (dolist (option options)
          (if (listp option)
            (if (keywordp (car option))
              (case (first option)
                (:SIZE
                  (if size
                    (error #+DEUTSCH "~S ~A: Die Option ~S darf nur einmal angegeben werden."
                           #+ENGLISH "~S ~A: the ~S option must not be given more than once"
                           #+FRANCAIS "~S ~A : L'option ~S ne doit apparatre qu'une seule fois."
                           'defpackage packname ':SIZE
                    )
                    (setq size t) ; Argument wird ignoriert
                ) )
                (:NICKNAMES
                  (dolist (name (rest option))
                    (push (check-packname name) nickname-list)
                ) )
                (:SHADOW
                  (dolist (name (rest option))
                    (push (record-symname (check-symname name)) shadow-list)
                ) )
                (:SHADOWING-IMPORT-FROM
                  (let ((pack (check-packname (second option))))
                    (dolist (name (cddr option))
                      (push (cons (record-symname (check-symname name)) pack)
                            shadowing-list
                ) ) ) )
                (:USE
                  (dolist (name (rest option))
                    (push (check-packname name) use-list)
                  )
                  (setq use-default nil)
                )
                (:IMPORT-FROM
                  (let ((pack (check-packname (second option))))
                    (dolist (name (cddr option))
                      (push (cons (record-symname (check-symname name)) pack)
                            import-list
                ) ) ) )
                (:INTERN
                  (dolist (name (rest option))
                    (push (record-symname (check-symname name)) intern-list)
                ) )
                (:EXPORT
                  (dolist (name (rest option))
                    (push (check-symname name) export-list)
                ) )
                (T (error #+DEUTSCH "~S ~A: Die Option ~S gibt es nicht."
                          #+ENGLISH "~S ~A: unknown option ~S"
                          #+FRANCAIS "~S ~A : Option ~S non reconnue."
                          'defpackage packname (first option)
              ) )  )
              (error #+DEUTSCH "~S ~A: Falsche Syntax in ~S-Option: ~S"
                     #+ENGLISH "~S ~A: invalid syntax in ~S option: ~S"
                     #+FRANCAIS "~S ~A : Mauvaise syntaxe dans l'option ~S: ~S"
                     'defpackage packname 'defpackage option
            ) )
            (error #+DEUTSCH "~S ~A: Das ist keine ~S-Option: ~S"
                   #+ENGLISH "~S ~A: not a ~S option: ~S"
                   #+FRANCAIS "~S ~A : Ceci n'est pas une option ~S: ~S"
                   'defpackage packname 'defpackage option
        ) ) )
        ; Auf berschneidungen zwischen intern-list und export-list prfen:
        (setq symname-list intern-list)
        (mapc #'record-symname export-list)
      )
      ; Listen umdrehen und Default-Werte eintragen:
      (setq nickname-list (nreverse nickname-list))
      (setq shadow-list (nreverse shadow-list))
      (setq shadowing-list (nreverse shadowing-list))
      (setq use-list (or use-default (nreverse use-list)))
      (setq import-list (nreverse import-list))
      (setq intern-list (nreverse intern-list))
      (setq export-list (nreverse export-list))
      ; Expansion produzieren:
      `(EVAL-WHEN (LOAD COMPILE EVAL)
         (IN-PACKAGE ,packname :NICKNAMES ',nickname-list)
         ; Schritt 1
         ,@(if shadow-list
             `((SHADOW ',(mapcar #'make-symbol shadow-list) ,packname))
           )
         ,@(mapcar
             #'(lambda (pair)
                 `(SHADOWING-IMPORT-CERROR ,(car pair) ,(cdr pair) ,packname)
               )
             shadowing-list
           )
         ; Schritt 2
         ,@(if use-list `((USE-PACKAGE ',use-list ,packname)))
         ; Schritt 3
         ,@(mapcar
             #'(lambda (pair)
                 `(IMPORT-CERROR ,(car pair) ,(cdr pair) ,packname)
               )
             import-list
           )
         ,@(if intern-list
             `((MAPCAR #'INTERN ',(mapcar #'car intern-list) ',(mapcar #'cdr intern-list)))
           )
         ; Schritt 4
         ,@(if export-list
             `((INTERN-EXPORT ',export-list ,packname))
           )
         (FIND-PACKAGE ,packname)
       )
) ) )
; Hilfsfunktionen:
(defun find-symbol-cerror (string packname calling-packname)
  (multiple-value-bind (sym found) (find-symbol string packname)
    (unless found
      (cerror #+DEUTSCH "Dieses Symbol wird erzeugt."
              #+ENGLISH "This symbol will be created."
              #+FRANCAIS "Ce symbole sera cr."
              #+DEUTSCH "~S ~A: Es gibt kein Symbol ~A::~A ."
              #+ENGLISH "~S ~A: There is no symbol ~A::~A ."
              #+FRANCAIS "~S ~A : Il n'y a pas de symbole ~A::~A ."
              'defpackage calling-packname packname string
      )
      (setq sym (intern string packname))
    )
    sym
) )
(defun shadowing-import-cerror (string packname calling-packname)
  (shadowing-import (find-symbol-cerror string packname calling-packname)
                    calling-packname
) )
(defun import-cerror (string packname calling-packname)
  (import (find-symbol-cerror string packname calling-packname)
          calling-packname
) )
(defun intern-export (string-list packname)
  (export (mapcar #'(lambda (string) (intern string packname)) string-list)
          packname
) )

;-------------------------------------------------------------------------------

