;;; -*- Mode: Lisp; Package: ph-lib -*-
;;;
;;;	(c) Copyright 1989, 1990, 1991 Sun Microsystems, Inc. 
;;;	Sun design patents pending in the U.S. and foreign countries. 
;;;	See LEGAL_NOTICE file for terms of the license.
;;;	
;;; Polyhedra library.
;;;
;;; Author: Conal Elliott.  Last Modified Mon Nov  5 16:07:33 1990
;;;
;;; Sccs Id %W% %G%
;;;

(in-package :ph-lib :use '(:ph :point :generic :clos :lisp))

(export '(tetrahedron octahedron hexahedron icosahedron dodecahedron))


;;;; Various Platonic solids, taken from Polyhedra.m in Mathematica 1.2.  Note
;;;; that the vertex numbering scheme is 1-based, not 0-based.

(defun fix-indexed-faces (indexed-faces)
  (mapcar #'(lambda (indexed-face)
              (mapcar #'1- indexed-face))
          indexed-faces))

(defparameter tetrahedron
  (make-instance
   'ph
   :indexed-faces
   (fix-indexed-faces '((1 2 3) (1 3 4) (1 4 2) (2 4 3)))
   :vertex-points
   (list (point 0. 0. 1.73205)
         (point 0. 1.63299 -0.57735) 
         (point -1.41421 -0.816497 -0.57735)
         (point 1.41421 -0.816497 -0.57735))))

(defparameter octahedron
  (make-instance
   'ph
   :indexed-faces
   (fix-indexed-faces
    '((1 2 3) (1 3 5) (1 5 6) (1 6 2)
      (2 6 4) (2 4 3) (4 6 5) (3 4 5)))
   :vertex-points
   (list (point 0 0 1) (point 1 0 0) (point 0 1 0)
         (point 0 0 -1) (point -1 0 0) (point 0 -1 0))))

(defparameter hexahedron
  (make-instance
   'ph
   :indexed-faces
   (fix-indexed-faces
    '((1 2 3 4) (1 4 6 7) (1 7 8 2)
      (2 8 5 3) (5 8 7 6) (3 5 6 4)))
   :vertex-points
   (list (point 0.707107 0.707107 0.707107)
         (point -0.707107 0.707107 0.707107) 
         (point -0.707107 -0.707107 0.707107)
         (point 0.707107 -0.707107 0.707107) 
         (point -0.707107 -0.707107 -0.707107)
         (point 0.707107 -0.707107 -0.707107) 
         (point 0.707107 0.707107 -0.707107)
         (point -0.707107 0.707107 -0.707107))))


(defparameter dodecahedron
  (make-instance
   'ph
   :indexed-faces
   (fix-indexed-faces
    '((3 1 2 5 6) (12 11 5 2 7) (17 13 6 5 11) 
      (14 9 3 6 13) (10 4 1 3 9) (8 7 2 1 4) 
      (4 10 16 15 8) (9 14 19 16 10) (13 17 20 19 14) 
      (11 12 18 20 17) (7 8 15 18 12) (18 15 16 19 20)))
   :vertex-points
   (list (point 0.1171133902139618 -1.000511576276664 -0.3621589273242113) 
         (point -0.2984036824225265 -0.5817988070943417 -0.847563231579627) 
         (point 0.7957196239318588 -0.6599726122576239 -0.2777850442631916) 
         (point -0.2354424399154574 -0.995440477478119 0.3155362956874772) 
         (point 0.1233988775001608 0.01751887980296279 -1.063185706833948) 
         (point 0.7996042687105845 -0.03079518881785797 -0.7110434210240867) 
         (point -0.907763186347153 -0.3179489854175332 -0.4698643668832807) 
         (point -0.868850998503861 -0.5735935968779865 0.2489706732667203) 
         (point 0.862565511217654 -0.4444368592016375 0.4520561062430151) 
         (point 0.2252723078505214 -0.6517674020412752 0.81874886058316) 
         (point -0.2252723078505258 0.6517674020412736 -0.818748860583157) 
         (point -0.862565511217653 0.4444368592016384 -0.4520561062430158) 
         (point 0.868850998503857 0.5735935968779876 -0.2489706732667215) 
         (point 0.907763186347152 0.317948985417531 0.469864366883284) 
         (point -0.7996042687105915 0.03079518881786086 0.7110434210240858) 
         (point -0.1233988775001686 -0.01751887980296174 1.063185706833949) 
         (point 0.2354424399154601 0.99544047747812 -0.315536295687476) 
         (point -0.7957196239318574 0.6599726122576284 0.2777850442631883) 
         (point 0.2984036824225249 0.5817988070943394 0.847563231579629) 
         (point -0.1171133902139571 1.000511576276665 0.3621589273242109))))

(defparameter icosahedron
  (make-instance
   'ph
   :indexed-faces
   (fix-indexed-faces
    '((1 2 6) (1 3 2) (1 4 3) (1 5 4) (1 6 5) (2 3 11) 
      (2 10 6) (2 11 10) (3 4 12) (3 12 11) (4 5 8) 
      (4 8 12) (5 6 9) (5 9 8) (6 10 9) (7 8 9) (7 9 10) 
      (7 10 11) (7 11 12) (7 12 8)))
   :vertex-points
   (list (point 0.4249358858193742 -0.6234212590752522 -0.901521749427252) 
         (point -0.5999406907417391 0.05914133178387721 -1.009227188986324) 
         (point 0.4980672603913731 0.6101449500603583 -0.872707378430782) 
         (point 1.170388006823068 -0.06734654200022822 -0.0873067158600265) 
         (point 0.4878971283264427 -1.037062929459035 0.2615777778398508) 
         (point -0.606226178027942 -0.958889124295748 -0.3082004094765843) 
         (point -0.4249358858193759 0.6234212590752533 0.90152174942725) 
         (point 0.5999406907417364 -0.05914133178387813 1.009227188986327) 
         (point -0.4980672603913764 -0.6101449500603557 0.87270737843078) 
         (point -1.170388006823072 0.0673465420002311 0.0873067158600247) 
         (point -0.4878971283264417 1.037062929459036 -0.2615777778398516) 
         (point 0.606226178027942 0.958889124295747 0.3082004094765856))))
