;;;	(c) Copyright 1989, 1990, 1991 Sun Microsystems, Inc. 
;;;	Sun design patents pending in the U.S. and foreign countries. 
;;;	See LEGAL_NOTICE file for terms of the license.

;;;@(#)region.lisp	3.15 10/11/91


(in-package "LISPVIEW")


;;; DEF-REGION-EDGE 
;;;
;;; The macro below defines an accessor and a setf method for one of the
;;; left,right,top,bottom min-x,max-x,min-y,max-y edges.  The arguments are:
;;;   region-edge - name of the accessor
;;;   edge1, edge1 - internal region accessors for the axis that 
;;;      region-edge lies on, the first one corresponds to region-edge.
;;;
;;; The code generated by this macro for 
;;;    (def-region-edge region-left region-min-x region-max-x)
;;; looks like this:
;;;   (progn 
;;;     (defun region-left (r)
;;;   	  (region-min-x r))
;;;     (def-compiler-macro region-left (r) 
;;;        `(region-min-x ,r))
;;;     (defsetf region-left (r &optional stretch) (value)
;;;       (if stretch
;;;           `(setf (region-%min-x ,r) ,value)
;;;         `(let ((dx/dy (- (region-left ,r) ,value)) )
;;;            (decf (region-min-x ,r) dx/dy)
;;;  	       (decf (region-max-x ,r) dx/dy)
;;;  	       ,value))))

(defmacro def-region-edge (region-edge edge1 edge2)
  `(progn 
     (defun ,region-edge (r)
       (check-type r region)
       (the region-dimension (,edge1 r)))
     (def-compiler-macro ,region-edge (r)
       `(the region-dimension (,',edge1 ,r)))
     (defsetf ,region-edge (r &optional stretch) (value)
       `(progn
	  (check-type ,value region-dimension)
	  (if (eq ,stretch :stretch)
	      (setf (,',edge1 ,r) ,value)
	    (let ((dx/dy (- (,',region-edge ,r) ,value)) )
	      (declare (type region-dimension dx/dy))
	      (decf (,',edge1 ,r) dx/dy)
	      (decf (,',edge2 ,r) dx/dy)
	      ,value))))))

(def-region-edge region-left   region-min-x region-max-x)
(def-region-edge region-right  region-max-x region-min-x)
(def-region-edge region-bottom region-max-y region-min-y)
(def-region-edge region-top    region-min-y region-max-y)


(defun region-width (r)
  (check-type r region)
  (the region-dimension (- (region-max-x r) (region-min-x r))))

(def-compiler-macro region-width (r)
  `(the region-dimension (- (region-max-x ,r) (region-min-x ,r))))

(defsetf region-width (r) (width)
  `(progn
     (check-type ,width region-dimension)
     (setf (region-max-x ,r) (+ (region-min-x ,r) ,width))
     ,width))


(defun region-height (r)
  (check-type r region)
  (the region-dimension (- (region-max-y r) (region-min-y r))))

(def-compiler-macro region-height (r)
  `(the region-dimension (- (region-max-y ,r) (region-min-y ,r))))

(defsetf region-height (r) (height)
  `(progn
     (check-type ,height region-dimension)
     (setf (region-max-y ,r) (+ (region-min-y ,r) ,height))
     ,height))



(defun region-equal (r &rest regions)
  (declare (dynamic-extent regions))

  (check-type r region)
  (dolist (r regions)
    (check-type r region))

  (if regions
      (let ((min-x (region-min-x r))
	    (min-y (region-min-y r))
	    (max-x (region-max-x r))
	    (max-y (region-max-y r)))
	(declare (type region-dimension min-x min-y max-x max-y))
	(dolist (r regions T)
	  (declare (type region r)
		   (type-reduce number region-dimension))
	  (unless (and (= min-x (region-min-x r))
		       (= min-y (region-min-y r))
		       (= max-x (region-max-x r))
		       (= max-y (region-max-y r)))
	    (return NIL))) )
      T))


(defun region-contains-xy-p (r x y)
  (check-arglist (r region) (x region-dimension) (y region-dimension))

  (and (>= x (region-min-x r))
       (>= y (region-min-y r))
       (<= x (region-max-x r))
       (<= y (region-max-y r))))


(defun region-contains-region-p (r1 r2)
   (check-arglist (r1 region) (r2 region))

   (and (>= (region-min-x r2) (region-min-x r1))
	(>= (region-min-y r2) (region-min-y r1))
	(<= (region-max-x r2) (region-max-x r1))
	(<= (region-max-y r2) (region-max-y r1)) ))


(defun region-bounding-region (&rest regions)
  (declare (dynamic-extent regions))
  (when regions
    (dolist (r regions)
      (check-type r region))

    (let* ((r (car regions))
	   (min-x (region-min-x r))
	   (min-y (region-min-y r))
	   (max-x (region-max-x r))
	   (max-y (region-max-y r)) )
      (declare (type region-dimension min-x min-y max-x max-y)
	       (type-reduce number region-dimension))
      (dolist (r regions (%make-region :min-x min-x
				       :min-y min-y
				       :max-x max-x
				       :max-y max-y))
	(declare (type region r))
	(when (< (region-min-x r) min-x)
	  (setq min-x (region-min-x r)))
	(when (< (region-min-y r) min-y)
	  (setq min-y (region-min-y r)))
	(when (> (region-max-x r) max-x)
	  (setq max-x (region-max-x r)))
	(when (> (region-max-y r) max-y)
	  (setq max-y (region-max-y r)))))))


(defun region-intersection (&rest regions)
  (declare (dynamic-extent regions))

  (when regions
    (dolist (r regions)
      (check-type r region))

    (let* ((r (car regions))
	   (min-x (region-min-x r))
	   (min-y (region-min-y r))
	   (max-x (region-max-x r))
	   (max-y (region-max-y r)) )
      (declare (type region-dimension min-x min-y max-x max-y)
	       (type-reduce number region-dimension))
      (dolist (r regions (%make-region :min-x min-x
				       :min-y min-y
				       :max-x max-x
				       :max-y max-y))
	(declare (type region r))
	(when (> (region-min-x r) min-x)
	  (setq min-x (region-min-x r)))
	(when (< (region-max-x r) max-x)
	  (setq max-x (region-max-x r)))
	(when (> min-x max-x)
	  (return nil))

	(when (> (region-min-y r) min-y)
	  (setq min-y (region-min-y r)))
	(when (< (region-max-y r) max-y)
	  (setq max-y (region-max-y r)))
	(when (> min-y max-y)
	  (return nil)) ))))



;;; Return t if all of the regions mutually intersect, i.e. return
;;; t if region-intersection would return a region given the same arguments.

(defun regions-intersect-p (&rest regions)
  (declare (dynamic-extent regions))

  (when regions
    (dolist (r regions)
      (check-type r region))

    (let* ((r (car regions))
	   (min-x (region-min-x r))
	   (min-y (region-min-y r))
	   (max-x (region-max-x r))
	   (max-y (region-max-y r)) )
      (declare (type region-dimension min-x min-y max-x max-y)
	       (type-reduce number region-dimension))
      (dolist (r regions T)
	(declare (type region r))
	(when (> (region-min-x r) min-x)
	  (setq min-x (region-min-x r)))
	(when (< (region-max-x r) max-x)
	  (setq max-x (region-max-x r)))
	(when (> min-x max-x)
	  (return nil))

	(when (> (region-min-y r) min-y)
	  (setq min-y (region-min-y r)))
	(when (< (region-max-y r) max-y)
	  (setq max-y (region-max-y r)))
	(when (> min-y max-y)
	  (return nil))))))


;;; If bounding-region is specified and non-nil (at run time), all the other 
;;; region-component args are completely ignored.

(defmacro with-default-region-dimensions 
  ((width height left top right bottom &optional bounding-region) 
   &body body)

  `(let* ((,width ,width)
	  (,height ,height)
	  (,left ,left)
	  (,top ,top)
	  (,right ,right)
	  (,bottom ,bottom)
	  ,@(if bounding-region `((,bounding-region ,bounding-region))))
     (declare (type region-dimension ,width ,left ,height ,top ,right ,bottom)
	      (type-reduce number region-dimension))
     (if ,bounding-region
	 (progn
	   (setf ,width (region-width ,bounding-region))
	   (setf ,height (region-height ,bounding-region))
	   (setf ,left (region-left ,bounding-region))
	   (setf ,top (region-top ,bounding-region))
	   (setf ,right (region-right ,bounding-region))
	   (setf ,bottom (region-bottom ,bounding-region)))
       (progn
	 (when (and (null ,width) ,right ,left)  (setf ,width (- ,right ,left)))
	 (when (and (null ,left) ,right ,width)  (setf ,left (- ,right ,width)))
	 (when (and ,left ,width) (setf ,right (+ ,left ,width)))
	 (when (and (null ,height) ,bottom ,top) (setf ,height (- ,bottom ,top)))
	 (when (and (null ,top) ,bottom ,height) (setf ,top (- ,bottom ,height)))
	 (when (and ,top ,height) (setf ,bottom (+ ,top ,height)))))

     . ,body))




(defun make-region (&key left bottom right top width height)
  (check-arglist (left region-initarg)
		 (bottom region-initarg)
		 (right region-initarg)
		 (top region-initarg)
		 (width region-initarg)
		 (height region-initarg))
  (with-default-region-dimensions (width height left top right bottom)
    (let ((min-x (or left 0))
	  (min-y (or top 0)))
      (%make-region 
       :min-x min-x
       :min-y min-y
       :max-x (+ min-x (or width 0))
       :max-y (+ min-y (or height 0))))))




#|
;;; Old version without macro
(defun make-region (&key left bottom right top width height)
  (check-arglist (left region-initarg)
		 (bottom region-initarg)
		 (right region-initarg)
		 (top region-initarg)
		 (width region-initarg)
		 (height region-initarg))

  (let* ((width (or width (if (and right left) (- right left) 0)))
	 (left (or left (if (and right width) (- right width) 0)))
	 (height (or height (if (and bottom top) (- bottom top) 0)))
	 (top (or top (if (and bottom height) (- bottom height) 0))))
    (declare (type region-dimension width left height top)
	     (type-reduce number region-dimension))
    (%make-region 
       :min-x left
       :min-y top
       :max-x (+ left width)
       :max-y (+ top height))))

|#


(defun copy-region (old &key left bottom right top width height)
  (check-arglist (old region)
		 (left region-initarg)
		 (bottom region-initarg)
		 (right region-initarg)
		 (top region-initarg)
		 (width region-initarg)
		 (height region-initarg))

  (let ((new (%copy-region old))
	(width (or width (if (and right left) (- right left))))
	(height (or height (region-height old) (if (and bottom top) (- bottom top)))))
    (declare (type region new))
    (when width (setf (region-width new) width))
    (when height (setf (region-height new) height))
    (when left (setf (region-left new) left))
    (when top (setf (region-top new) top))
    (when right (setf (region-right new) right))
    (when bottom (setf (region-bottom new) bottom))

    new))


(defvar *print-region-format* :width-height)

(defun print-region (region stream depth)
  (cond 
    ((and (numberp *print-level*) (>= depth *print-level*))
     (write-char #\# stream))
    ((null *print-region-format*)
      (if (or (null *print-length*) (> *print-length* 5))
	  (format stream "#S(~S MIN-X ~D MIN-Y ~D MAX-X ~D MAX-Y ~D)"
		  (type-of region)
		  (region-min-x region)
		  (region-min-y region)
		  (region-max-x region)
		  (region-max-y region))
	(progn
	  (format stream "#S(" (type-of region))
	  (dotimes (i (1- *print-length*))
	    (format stream 
	       (svref '#(" MIN-X ~D" " MIN-Y ~D" 
			 " MAX-X ~D" " MAX-X ~D") i)
	       (funcall (svref '#(region-min-x region-min-y 
				  region-max-x region-max-y) i) region)))
	  (princ " ...)" stream)) ))

    ((eq *print-region-format* :width-height)
     (format stream "#<~S ~Sx~S at (~S,~S) ~X>"
	            (type-of region)
	            (region-width region) (region-height region)
		    (region-min-x region) (region-min-y region)
		    (SYSTEM:%pointer region)) )
    
    (t ;; (eq *print-region-format* :min-max)
     (format stream "#<~S (~S,~S) (~S,~S) ~X>"
	            (type-of region)
		    (region-min-x region) (region-min-y region)
		    (region-max-x region) (region-max-y region)
		    (SYSTEM:%pointer region))) ))


