;;; -*- Mode:Lisp; Package:CLUE; BASE:10; LOWERCASE:T; Syntax:Common-Lisp -*-
;;;
;;;	------ CLUE Grapher ------ 1990
;;;
;;;	by Tomoru Teruuchi (Fuji Xerox)
;;;	written as a part of a project under the Jeida Common Lisp Committee 1990
;;;
;;;	The source code is completely in public domain.
;;;
;;;	The author(s), the organization the author belongs, Jeida,
;;;	Jeida CLC, Masayuki Ida (the chairman), and Aoyama Gakuin University
;;;	have no warranty about the contents, the results caused by the use,
;;;	and any other possible situations.
;;;
;;;	This codes is written as an experimentation.
;;;	This codes do not mean the best functinality the system supports.

;;;
;;; file name : rubber-banding.lisp
;;;
(in-package 'grapher :use '(lisp pcl cluei xlib))

;;; find-node
;;;
;;;
(defun find-node-by-pos (x y)
  (map-over-nodes (a-node)
		  (with-slots (xpos ypos radius) a-node
			      (if (and xpos ypos)
				  (let ((x-left (- xpos radius))
					(x-right (+ xpos radius))
					(y-up (- ypos radius))
					(y-bottom (+ ypos radius)))
				    (if (and (and (>= x x-left)(<= x x-right))
					     (and (>= y y-up)(<= y y-bottom)))
					(return  a-node))))))
)

;;; select-and-start-rubber-banding
;;;
;;;
(defmethod select-and-start-rubber-banding ((contact canvas) &key)
  (with-event (x y)
	      (let ((a-node (find-node-by-pos x y)))
		(if a-node 
		    (progn 
		      (setf (node-sxoff a-node) (- x (node-xpos a-node)))
		      (setf (node-syoff a-node) (- y (node-ypos a-node)))
		      (setf (canvas-snode contact) a-node)
		      (grab-button contact 2  '(:button-press :button-release :button-2-motion)
				   :cursor (my-cursor (if (find-package 'common-lisp) mouse-cursor
							;; This is kludge to solve the CLUE's difference 
							;; between ver 7.1 and 7.2
							"mouse") (contact-display contact)))
		      
		      (start-rubber-banding contact a-node)
		      )
		  )
		)
	      )
)
 
;;; start-rubber-banding
;;;
;;;
(defmethod start-rubber-banding ((contact canvas) (node node) &key)
  (if node
      (with-slots (arcs xpos ypos (sxoff selected-x-offset)
			(syoff selected-y-offset)) node
		  (using-gcontext (gc :drawable contact
				      :foreground (canvas-foreground contact)
				      :function boole-xor)
				  ;; Image Off
				  (present-self-switching node contact gc)
				  (dolist (an-arc arcs)
					  (present-self-switching an-arc contact gc))
				  ;; Image On
				  (present-self-switching node contact gc)
				  (if (and *arc-label-mode* (equal *current-mode* :move-node))
					   (setq *arc-label-mode* 'temp-nil))
				  (dolist (an-arc arcs)
					  (present-self-switching an-arc contact gc))
				  (if (or (equal *current-mode* :add-arc)
					  (equal *current-mode* :delete-arc))
				      ;; Line On
				      (xlib:draw-line contact gc xpos ypos (- xpos sxoff) (- ypos syoff)) )
				  )
		  (if (or (equal *current-mode* :add-arc)
			  (equal *current-mode* :delete-arc))
		      (progn
			(if (null *message-out*)
			    (query-data-msg *i-stream* *current-mode*))
			(stream-write-strings *i-stream*
					    ((or (node-label node)
						 (format nil "~d" (node-unique node))) " <Node2> : ")))
		    (progn
		      (if (null *message-out*)
			  (query-data-msg *i-stream* :move-node))
		      (stream-write-strings *i-stream* 
					   ((or (node-label node)
					       (format nil "~d" (node-unique node))) " New Position <x> : ")))
		    )
		  )
    )
)

(defmethod track-rubber-banding ((contact canvas) &key)
  (let ((a-node (canvas-snode contact)))
    (if a-node
	(if (or (equal *current-mode* :move-node)(null *current-mode*))
	    (with-slots (arcs xpos ypos) a-node
			(using-gcontext (gc :drawable contact
					    :foreground (canvas-foreground contact)
					    :function boole-xor)
					;; Image Off
					(present-self-switching a-node contact gc)
					(dolist (an-arc arcs)
						(present-self-switching an-arc contact gc))
					(allow-events (contact-display contact)
						      :sync-pointer)
					(with-event (x y)
						    (move a-node (- x (node-sxoff a-node))
							  (- y (node-syoff a-node)))
						    ;;Image On
						    (present-self-switching a-node contact gc)
						    (dolist (an-arc arcs)
							    (present-self-switching an-arc contact gc)))))
	  (if (or (equal *current-mode* :add-arc)
		  (equal *current-mode* :delete-arc))
	      (with-slots (arcs xpos ypos (sxoff selected-x-offset)
				(syoff selected-y-offset)) a-node
			  (using-gcontext (gc :drawable contact
					      :foreground (canvas-foreground contact)
					      :function boole-xor)
;					  (present-self-switching a-node contact gc)
					  ;;Line Off
					  (xlib:draw-line contact gc xpos ypos (- xpos sxoff) (- ypos syoff))
					  (allow-events (contact-display contact)
							:sync-pointer)
					  (with-event (x y)
						      ;;Line On
						      (xlib:draw-line contact gc xpos ypos x y)
;						      (present-self-switching a-node contact gc)
						      (setf (node-sxoff a-node) (- xpos x))
						      (setf (node-syoff a-node) (- ypos y)))
					  )))
	  )
      )
    )
)

(defmethod end-rubber-banding ((contact canvas) &key)
  (let ((a-node (canvas-snode contact)))
    (if a-node
	(if (or (equal *current-mode* :move-node)(null *current-mode*))
	    (with-slots (arcs xpos ypos) a-node
			(stream-write-strings *i-stream* ((format nil "~d" xpos) " <y> :" (format nil "~d" xpos)) t)
			(using-gcontext (gc :drawable contact :function boole-xor
					    :foreground (canvas-foreground contact))
					;; Image Off
					(present-self-switching a-node contact gc)
					(dolist (an-arc arcs)
						(present-self-switching an-arc contact gc))
					;; Image On
					(present-self-switching a-node contact gc)
					(if (equal *arc-label-mode* 'temp-nil)
					    (setq *arc-label-mode* t))
					(dolist (an-arc arcs)
						(present-self-switching an-arc contact gc)))
			(stream-write-string *i-stream* ";;; Moved the Node : ")
			(print-object--stream a-node *i-stream*)
			(setq *message-out* nil)
			(setf (canvas-snode contact) nil)
			(ungrab-button contact 2)
			)
	  (if (or (equal *current-mode* :add-arc)
		  (equal *current-mode* :delete-arc))
	      (with-slots (arcs xpos ypos (sxoff selected-x-offset)
				(syoff selected-y-offset)) a-node
			  (using-gcontext (gc :drawable contact
					      :foreground (canvas-foreground contact)
					      :function boole-xor)
					  (if (equal *arc-label-mode* 'temp-nil)(setq *arc-label-mode* t))
;					  (present-self-switching a-node contact gc)
					  (xlib:draw-line contact gc xpos ypos (- xpos sxoff) (- ypos syoff))
					  (let ((dest-node (find-node-by-pos (- xpos sxoff) (- ypos syoff)))
						an-arc)
;					    (present-self-switching a-node contact gc)
					    (if (and dest-node (or (equal *current-mode* :add-arc)
								   (setq an-arc (find-arc dest-node a-node))))
						(progn
						  (if (equal *current-mode* :add-arc)
						      (progn
							(setq an-arc (make-instance 'arc :node1 a-node :node2 dest-node))
							(present-self an-arc contact))
						    (progn 
						      (delete-self an-arc)
						      (present-self an-arc contact t)))
						  (stream-write-string *i-stream*
								       (node-name dest-node))
						  (stream-fresh-line *i-stream*)
						  (if (equal *current-mode* :add-arc)
						      (add-an-arc-after an-arc)
						    (delete-an-arc-after an-arc))
						  )
					      (if dest-node
						  (progn
						    (stream-fresh-line *i-stream*)
						    (stream-write-strings *i-stream* 
									(";;;*** Error *** There is No Arc!!!") t))
						(progn
						  (stream-fresh-line *i-stream*)
						  (stream-write-strings *i-stream*
								       (";;; Destination Node was selected!!!") t)))
					      )
					    )
					  )
			  (setq *message-out* nil)
			  (setf (canvas-snode contact) nil)
			  (ungrab-button contact 2)
			  ))
	  )
      )
    )
)

;;;
;;; Output method for rubber-banding
;;;
(defmethod present-self-switching ((node node) window gc)
  (calculate-radius node window)
  (with-slots (xpos ypos radius label) node
    (draw-circle window xpos ypos radius nil gc)
    (draw-my-label window xpos ypos 
		(or label 
		    (format nil "~d" (node-unique node)))
		nil gc)
    )
)

(defmethod present-self-switching ((arc arc) window gc)
  (with-slots (node1 node2) arc
    (multiple-value-bind (x1 y1 x2 y2)
        (find-edges-of-nodes (node-radius node1)
			     (node-xpos node1) (node-ypos node1)
			     (node-radius node2)
			     (node-xpos node2) (node-ypos node2))
      (draw-my-arc window x1 y1 x2 y2 arc nil gc)
      )))


(defevent canvas (:button-press :button-1) dispatch-mode)
(defevent canvas (:button-press :button-2) select-and-start-rubber-banding)
(defevent canvas (:motion-notify :button-2) track-rubber-banding)
(defevent canvas (:button-release :button-2) end-rubber-banding)

;;;
;;; Redefinition of the tty-base interface
;;;
(defmethod delete-a-node :before ()
  (setq *current-mode* :delete-node))

(defmethod move-a-node :before ()
  (setq *current-mode* :move-node))

(defmethod create-a-node :before ()
  (setq *current-mode* :create-node))

(defmethod set-label :before ()
  (setq *current-mode* :set-label))

(defmethod set-arc-label :before ()
  (setq *current-mode* :set-arc-label))

(defmethod add-an-arc :before ()
  (setq *current-mode* :add-arc))

(defmethod delete-an-arc :before ()
  (setq *current-mode* :delete-arc))

(defmethod clear-all-data :before ()
  (setq *current-mode* :other))

(defmethod dispatch-mode ((contact canvas) &key)
  (ecase *current-mode*
	 (:create-node
	  (if (null *message-out*)(query-data-msg *i-stream* *current-mode*))
	  (with-event (x y)
		      (stream-write-strings *i-stream* ((format nil "~d" x) " <y> : " (format nil "~d" y)) t)
		      (let ((a-node (make-instance 'node)))
			(setf (node-xpos a-node) x)
			(setf (node-ypos a-node) y)
			(create-a-node-after a-node)))
	  (if *message-out* (throw *current-mode* (setq *message-out* nil))))
	 (:delete-node
	  (if (null *message-out*) (query-data-msg *i-stream* *current-mode*))
	  (with-event (x y)
		      (let ((a-node (find-node-by-pos x y)))
			(if a-node
			    (progn
			      (stream-write-string *i-stream*
						   (node-name a-node))
			      (stream-fresh-line *i-stream*)
			      (delete-a-node-after a-node)))))
	  (if *message-out* (throw *current-mode* (setq *message-out* nil)))
	  )
	 (:move-node	  ())
	 (:add-arc	  ())
	 (:delete-arc	  ())
	 (:reset	  ())
	 (:set-label
	  (with-event (x y)
		      (let ((a-node (find-node-by-pos x y)))
			(if a-node
			    (progn
			      (if (null *message-out*) (query-data-msg *i-stream* *current-mode*))
			      (throw 'node-name (progn (stream-write-string 
							*i-stream* 
							(or (node-label a-node) (format nil "~d" (node-unique a-node))))
						       (or (node-label a-node) (format nil "~d" (node-unique a-node))))))))
		      )
	  )
	 (:set-arc-label                        ;added for extension
	  (with-event (x y)                     ;added for extension
	  (let ((an-arc (find-arc-box x y)))    ;added for extension
	    (if an-arc                          ;added for extension
		(progn                          ;added for extension 
		  (if (null *message-out*)(query-data-msg *i-stream* *current-mode*))
		  (throw 'arc-name (list (arc-node1 an-arc) (arc-node2 an-arc)))))
	    )                                   ;added for extension 
	  )                                     ;added for extension
	  )
	 (:other
	  (with-event (x y)
		      (let ((a-node (find-node-by-pos x y)))
			(if (null a-node)
			    (progn
			      (query-data-msg *i-stream* :create-node)
			      (stream-write-strings *i-stream* 
						    ((format nil "~d" x) " <y> : " (format nil "~d" y)) t)
			      (let ((a-node (make-instance 'node)))
				(setf (node-xpos a-node) x)
				(setf (node-ypos a-node) y)
				(create-a-node-after a-node)))
			  )))
	  )
	 )
)
