;;; -*- Mode:LISP; Pacakge:USER; Syntax:COMMON-LISP; Base:10; Lowercase:T -*-

;;;
;;;	------ CLUE Grapher ------ 1990
;;;
;;;	by Tomoru Teruuchi (Fuji Xerox)
;;;	written as a part of a project under the Jeida Common Lisp Committee 1990
;;;
;;;	The source code is completely in public domain.
;;;
;;;	The author(s), the organization the author belongs, Jeida,
;;;	Jeida CLC, Masayuki Ida (the chairman), and Aoyama Gakuin University
;;;	have no warranty about the contents, the results caused by the use,
;;;	and any other possible situations.
;;;
;;;	This codes is written as an experimentation.
;;;	This codes do not mean the best functinality the system supports.

;;;
;;; This file is clue Grapher's defsystem.
;;; Please load this file, and type "(load-grapher)".
;;; So, the Grapher System's file will be compiled and loaded.
;;;
;;; Note: You must edit the global variable *grapher-directory*'s
;;;       contants, or type (load-grapher :directory <directory>)
;;;


(in-package 'user)

(defvar *grapher-directory* '(:root "home5" "lde" "lispclue" "grapher"))

(defun load-grapher (&key (host nil)
			  (directory *grapher-directory*)
			  (compile-p t)
			  (verbose-p t))
  (dolist (file-name 
	   (mapcar #'(lambda (name)
		       (make-pathname
			:host host
			:directory directory
			:name name
			:version :newest))
		   '("menu"
		     "node-and-arcs"
		     "clue-grapher"
		     "rubber-banding")))
	  (when compile-p
		(when verbose-p
		      (format t "~% Compiling ~12t~a..." file-name))
		(compile-file file-name))
	  (when verbose-p
		(format t "~% Loading ~12t~a..." file-name))
	  (load file-name :verbose verbose-p)

	  (when (and compile-p verbose-p)
		(format t "~%"))))

