(in-package 'sys)

(defmacro test(&rest forms &aux result)
(cons 'progn 
      (mapcar #'(lambda(form)
               (cond ((eq form '-) 
                      '(format t "~%~60@{-~}" nil))
                     (result  (setq result nil)
                       `(unless (equal *result* ',form)
                           (format t "~%    ==== FEHLER ====")))
                     (t (setq result t)
                        `(format t "~2%~S~%==> ~S" ',form 
                                 (setq *result* ,form)))))
              forms))) 

(test
(req 1 2)
2

(opt 1 2)
2
(opt 1)
nil
(opt)
nil

(rst 1 2 3)
(1 2 3)
(rst 1)
(1)
(rst)
nil

(req+opt+rst 1)
nil
(req+opt+rst 1 2)
nil
(req+opt+rst 1 2 3)
(3)
(req+opt+rst 1 2 3 4)
(3 4)

(req-d 1 2)
2

(req-typep 1 2)
2

(rst-list-of 1 2)
(1 2)
(rst-list-of)
nil

(rst-d 1 2)
(1 2)
(rst-d)
nil

(fast-link 1)
1
(rlink 1)
(1 1)
(slow-link 1)
1
(mixed-link 1 2)
(2 2 (1 2) (1 2) 2 2 2 (1 2) 1)

(spec)
333
(spec2)
(333 444)
(const)
(1 2 3)
(const2)
((1 2) "ab" 123 abc)
(progn (clos 3)
       (funcall (clos 5) 1))
6
(progn (setq l (clos2 3))
       (list (funcall (car l) 1) 
             (funcall(second l))))
(4 4)
)
