;;|=========================================================================|
;;|                         COPYRIGHT NOTICE                                |
;;|                                                                         |
;;|             Copyright 1990, 1991, 1992, 1993, 1994 Mark Tarver          |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|

(in-package :sequel)

(defun read-file (filename)
  (declare (special mystream) (type stream mystream))
   (prog (contents)
         (if (not (probe-file (my-home-directory filename)))
             (progn (format t ";;Warning: ~A does not exist" filename)
                   (restart)))
         (setq mystream 
           (open (my-home-directory filename) :direction :input))
         loop
         (cond ((null (peek-char nil mystream nil))
                (close mystream)
                (return (read-from-string 
                           (format nil "(~A)"
                                (coerce (nreverse contents) 'string)))))
                 ((equal (peek-char nil mystream nil) #\|)
                  (read-char mystream nil)
                  (if (equal (peek-char nil mystream nil) #\-)
                      (progn (read-char mystream nil)
                             (push #\space contents)
                             (push #\- contents)
                             (push #\- contents)
                             (push #\space contents))  
                      (progn (push #\space contents)
                             (push #\| contents)
                             (push #\| contents)
                             (push #\space contents))))
                 (t (push (read-char mystream) contents)))
           (go loop)))
          
(defun lineread () 
  (prog (contents)
        (if (equal (peek-char nil) #\Newline)
            (read-char))        
        loop
        (cond ((and (equal (peek-char nil) #\Newline) 
                    (brackets-balance (reverse contents) 0))
               (return (read-from-string
                          (format nil "(~A)"
                               (coerce (nreverse contents) 'string)))))
                ((equal (peek-char nil) #\|)
                 (push #\space contents)
                 (push #\| contents)
                 (push #\| contents)
                 (push #\space contents)
                 (read-char))
                (t (push (read-char) contents)))
        (go loop)))

(defun brackets-balance (contents count)
  (cond ((and (null contents) (zerop count)) t)
        ((null contents) nil)
        ((equal (car contents) #\()
         (brackets-balance (cdr contents) (1+ count)))
        ((equal (car contents) #\))
         (brackets-balance (cdr contents) (1- count)))
        (t (brackets-balance (cdr contents) count)))) 

(defun bar (x)
    (eq '|| x))

(defun return-bar () '||)

(defun turnstile (x) (eq x '--))

(defun return-turnstile () '--)

(defun calibrate (x) (/ x 100))

(defun ppx (fp1)
  (setq mystream (make-string-output-stream))
  (describe fp1 mystream)
  (prog1 (massage-to-lexpr (coerce (get-output-stream-string mystream) 'list))
         (close mystream)))

(defun massage-to-lexpr (fp1)
  (make-like-lucid 
    (read-from-string (coerce (massage-to-lexpr1 fp1) 'string))))

(defun make-like-lucid (fp1)
      (cond
       ((and (consp fp1)
             (= (length fp1) 3)
             (eq 'lambda (car fp1))
             (and (consp (caddr fp1)) (> (length (caddr fp1)) 1))
             (eq 'block (caadr (cdr fp1))))
        (list 'named-lambda
              (cadar (cddr fp1))
              (cadr fp1)
              (cons 'block (cdr (car (cdr (cdr fp1)))))))
       ((and (consp fp1)
             (= (length fp1) 4)
             (eq 'lambda (car fp1))
             (consp (caddr fp1))
             (eq 'declare (caadr (cdr fp1)))
             (and (consp (caddr (cdr fp1))) (> (length (caddr (cdr fp1))) 1))
             (eq 'block (caadr (cddr fp1))))
        (list 'named-lambda
              (cadar (cdddr fp1))
              (cadr fp1)
              (cons 'declare (cdadr (cdr fp1)))
              (cons 'block (cdr (car (cdr (cdr (cdr fp1))))))))
       (t (raise "code 13: No Patterns have Fired in make-like-lucid"))))

;;(define make-like-lucid
  ;;[lambda fps? [block f? | code?]] 
  ;;-> [named-lambda f? fps? [block f? | code?]]
  ;;[lambda fps? [declare | declarations?] [block f? | code?]]
  ;;-> [named-lambda f? fps? [declare | declarations?] [block f? | code?]])

(defun massage-to-lexpr1 (fp1)
  (cond ((and (consp fp1)
              (> (length fp1) 6)
              (equal #\( (first fp1))
              (equal #\l (second fp1))
              (equal #\a (third fp1))
              (equal #\m (fourth fp1))
              (equal #\b (fifth fp1))
              (equal #\d (sixth fp1))
              (equal #\a (seventh fp1)))
         (append '(#\( #\l #\a #\m #\b #\d #\a)
           (massage-to-lexpr2 (nthcdr 7 fp1) 1)))
         ((consp fp1) (massage-to-lexpr1 (cdr fp1)))
          (t (raise "code 13: No Patterns have Fired in massage-to-lexpr1"))))

(defun massage-to-lexpr2 (fp1 fp2)
  (cond ((zerop fp2) nil)
        ((and (consp fp1) (equal #\( (car fp1)))
         (cons #\( (massage-to-lexpr2 (cdr fp1) (1+ fp2))))
        ((and (consp fp1) (equal #\) (car fp1)))
         (cons #\) (massage-to-lexpr2 (cdr fp1) (1- fp2))))
        ((consp fp1) (cons (car fp1) (massage-to-lexpr2 (cdr fp1) fp2)))
        (t (raise "code 13: No Patterns have Fired in massage-to-lexpr2"))))

(defun compile-inter-horn-clauses (fp1 fp2)
  (let ((l-c (interprogram fp2)))
  (put-prop fp1 'storage (mapcar 'car l-c))
  (put-prop fp1 'inter (mapcar 'cadr l-c))))

(defun interprogram (info) 
   (mapcar 'ch-to-lambda-fun info))

(defun ch-to-lambda-fun (info)
  (clf1 (list 'function
          (cons 'lambda (cons '(fp1 fp2 fp3 continuation)
                 (logiccode-of info))))))

(defun clf1 (code)
  (list code (eval code)))

(defun get-theory (fp1) (list fp1 'inter (get-prop fp1 'storage nil)))

(defun quit () (system::quit))

(defun lisp-compile-axioms (fp1) (mapcar 'eval fp1))

(defun enter-prooftool-loop (fp1)
  (if (catch 'success (prooftool-loop fp1 1)) 'yes 'no))

(defun connect-widgets () ())
