;;|=========================================================================|
;;|                         COPYRIGHT NOTICE                                |
;;|                                                                         |
;;|             Copyright 1990, 1991, 1992, 1993, 1994 Mark Tarver          |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|

(in-package :sequel)

(defun connect-widgets () 
  (opal::initialize-x11-values (opal::get-full-display-name)))

(defun ppx (fp1) 
  (ppx2 
    (read-from-string 
     (coerce (ppx1 (coerce (write-to-string (symbol-function fp1)) 'list)) 
             'string))))
  
(defun ppx1 (fp1)
   (cond
    ((and (consp fp1) 
          (> (length fp1) 9) 
          (equal #\# (car fp1)) 
          (equal #\< (cadr fp1)) 
          (equal #\c (caddr fp1))
          (equal #\l (caddr (cdr fp1))) 
          (equal #\o (caddr (cddr fp1))) 
          (equal #\s (caddr (cdddr fp1)))
          (equal #\u (caddr (cdddr (cdr fp1)))) 
          (equal #\r (caddr (cdddr (cddr fp1))))
          (equal #\e (caddr (cdddr (cdddr fp1)))) 
          (equal #\space (caddr (cdddr (cdddr (cdr fp1))))))
      (append (cons #\( 
                    (butlast (cdddr (cdddr (cdddr (cdr fp1)))))) 
              (list #\))))
    (t (raise "code 13: No Patterns have Fired in ppx1"))))
 
(defun ppx2 (fp1) 
  (cond
   ((and (consp fp1) 
         (= (length fp1) 4) 
         (and (consp (caddr fp1)) (= (length (caddr fp1)) 2))
         (and (consp (caddr (cdr fp1))) 
              (= (length (caddr (cdr fp1))) 3)) 
              (eq 'block (caadr (cddr fp1)))
     (equal (cadar (cdddr fp1)) (car fp1)))
    (list 'named-lambda 
          (car fp1) 
          (cadr fp1) 
          (list 'block (car fp1) (caddr (caddr (cdr fp1))))))
   ((and (consp fp1) 
         (= (length fp1) 4) 
         (and (consp (caddr fp1)) 
              (> (length (caddr fp1)) 1))
         (eq 'declare (caadr (cdr fp1))) 
         (and (consp (caddr (cdr fp1))) 
              (= (length (caddr (cdr fp1))) 3))
              (eq 'block (caadr (cddr fp1))) 
              (equal (cadar (cdddr fp1)) (car fp1)))
    (list 'named-lambda (car fp1) (cadr fp1) 
           (cons 'declare (cddar (cddr fp1)))
     (list 'block (car fp1) (caddr (caddr (cdr fp1))))))
   (t (raise "code 13: No Patterns have Fired in ppx2"))))

