(defun otter (&rest x) (otter1 x))

(defun freshterm (fp1 fp2) 
  (replace-in-wff fp1 (gentemp) fp2))

(defun external-syntax-out
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '* (cadr fp1))
                   (eq 'thm (caddr fp1)))
              (eso1 (car fp1)))
             (t fp1)))

(defun external-syntax-in
       (fp1)
       (list (esi1 fp1) '* 'thm))

(defun is-osymbol
       (fp1)
       (cond ((and (symbolp fp1)
                   (not
                     (member fp1
                             (list 'thm
                                   '>>
                                   '=
                                   'v
                                   '&
                                   '~
                                   '=>
                                   '<=>
                                   'all
                                   'some))))
              t)
             (t nil)))

(defun external-syntax-in
       (fp1)
       (list (esi1 fp1) '* 'thm))

(defun esi1
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '& (cadr fp1)))
              (mapcar 'esi1
                      (list (car fp1)
                            '&
                            (caddr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq 'v (cadr fp1)))
              (mapcar 'esi1
                      (list (car fp1) 'v (caddr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '=> (cadr fp1)))
              (mapcar 'esi1
                      (list (car fp1) '=> (caddr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '<=> (cadr fp1)))
              (mapcar 'esi1
                      (list (car fp1)
                            '<=>
                            (caddr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (eq '~ (car fp1)))
              (list '~ (esi1 (cadr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 2))
                   (eq 'all (caar fp1)))
              (list (list 'all (cadar fp1))
                    (esi1 (cadr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 2))
                   (eq 'some (caar fp1)))
              (list (list 'some (cadar fp1))
                    (esi1 (cadr fp1))))
             ((consp fp1) (list '>> fp1))
             (t fp1)))

(defun external-syntax-out
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '* (cadr fp1))
                   (eq 'thm (caddr fp1)))
              (eso1 (car fp1)))
             (t fp1)))

(defun eso1
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '& (cadr fp1)))
              (mapcar 'eso1
                      (list (car fp1)
                            '&
                            (caddr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq 'v (cadr fp1)))
              (mapcar 'eso1
                      (list (car fp1) 'v (caddr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '=> (cadr fp1)))
              (mapcar 'eso1
                      (list (car fp1) '=> (caddr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '<=> (cadr fp1)))
              (mapcar 'eso1
                      (list (car fp1)
                            '<=>
                            (caddr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (eq '~ (car fp1)))
              (list '~ (eso1 (cadr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 2))
                   (eq 'all (caar fp1)))
              (list (list 'all (cadar fp1))
                    (eso1 (cadr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 2))
                   (eq 'some (caar fp1)))
              (list (list 'some (cadar fp1))
                    (eso1 (cadr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (eq '>> (car fp1))
                   (consp (cadr fp1)))
              (car (cdr fp1)))
             (t fp1)))

(defun ~<pvq>==>~p&~q
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 2))
                   (eq '~ (caar fp1))
                   (and (consp (cadar fp1))
                        (= (length (cadar fp1))
                           3))
                   (eq 'v (cadar (cdar fp1)))
                   (eq '* (cadr fp1))
                   (eq 'thm (caddr fp1)))
              (list
                (list (list '~
                            (caadr (car fp1)))
                      '&
                      (list '~
                            (caddr (cadar fp1))))
                '*
                'thm))
             (t fp1)))

(defun ~<pvq>==>~p&~q&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 't-expr
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 't-expr))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        't-expr
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun ~<p&q>==>~pv~q
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 2))
                   (eq '~ (caar fp1))
                   (and (consp (cadar fp1))
                        (= (length (cadar fp1))
                           3))
                   (eq '& (cadar (cdar fp1)))
                   (eq '* (cadr fp1))
                   (eq 'thm (caddr fp1)))
              (list
                (list (list '~
                            (caadr (car fp1)))
                      'v
                      (list '~
                            (caddr (cadar fp1))))
                '*
                'thm))
             (t fp1)))

(defun ~<p&q>==>~pv~q&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 't-expr
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 't-expr))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        't-expr
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun ~~p==>p
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 2))
                   (eq '~ (caar fp1))
                   (and (consp (cadar fp1))
                        (= (length (cadar fp1))
                           2))
                   (eq '~ (caadr (car fp1)))
                   (eq '* (cadr fp1))
                   (eq 'thm (caddr fp1)))
              (list (cadar (cdar fp1))
                    '*
                    'thm))
             (t fp1)))

(defun ~~p==>p&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 't-expr
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 't-expr))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        't-expr
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun ~<p<=>q>==><<p&~q>v<~p&q>>
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 2))
                   (eq '~ (caar fp1))
                   (and (consp (cadar fp1))
                        (= (length (cadar fp1))
                           3))
                   (eq '<=>
                       (cadar (cdar fp1)))
                   (eq '* (cadr fp1))
                   (eq 'thm (caddr fp1)))
              (list
                (list
                  (list (caadr (car fp1))
                        '&
                        (list '~
                              (caddr (cadar fp1))))
                  'v
                  (list (list '~
                              (caadr (car fp1)))
                        '&
                        (caddr (cadar fp1))))
                '*
                'thm))
             (t fp1)))

(defun ~<p<=>q>==><<p&~q>v<~p&q>>&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 't-expr
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 't-expr))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        't-expr
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun ~<p=>q>==><p&~q>
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 2))
                   (eq '~ (caar fp1))
                   (and (consp (cadar fp1))
                        (= (length (cadar fp1))
                           3))
                   (eq '=>
                       (cadar (cdar fp1)))
                   (eq '* (cadr fp1))
                   (eq 'thm (caddr fp1)))
              (list
                (list (caadr (car fp1))
                      '&
                      (list '~
                            (caddr (cadar fp1))))
                '*
                'thm))
             (t fp1)))

(defun ~<p=>q>==><p&~q>&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 't-expr
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 't-expr))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        't-expr
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun p<=>q==><p=>q>&<q=>p>
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 3))
                   (eq '<=> (cadar fp1))
                   (eq '* (cadr fp1))
                   (eq 'thm (caddr fp1)))
              (list
                (list (list (caar fp1)
                            '=>
                            (caddr (car fp1)))
                      '&
                      (list (caddr (car fp1))
                            '=>
                            (caar fp1)))
                '*
                'thm))
             (t fp1)))

(defun p<=>q==><p=>q>&<q=>p>&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 't-expr
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 't-expr))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        't-expr
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun p=>q==>~pvq
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 3))
                   (eq '=> (cadar fp1))
                   (eq '* (cadr fp1))
                   (eq 'thm (caddr fp1)))
              (list (list (list '~ (caar fp1))
                          'v
                          (caddr (car fp1)))
                    '*
                    'thm))
             (t fp1)))

(defun p=>q==>~pvq&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 't-expr
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 't-expr))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        't-expr
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun ~all_x_fx==>some_x_~fx
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 2))
                   (eq '~ (caar fp1))
                   (and (consp (cadar fp1))
                        (= (length (cadar fp1))
                           2))
                   (and (consp (caadr (car fp1)))
                        (= (length (caadr (car fp1)))
                           2))
                   (eq 'all
                       (caar (cadar fp1)))
                   (eq '* (cadr fp1))
                   (eq 'thm (caddr fp1)))
              (list
                (list (list 'some
                            (cadar (cadar fp1)))
                      (list '~
                            (cadar (cdar fp1))))
                '*
                'thm))
             (t fp1)))

(defun ~all_x_fx==>some_x_~fx&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 't-expr
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 't-expr))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        't-expr
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun ~some_x_fx==>all_x_~fx
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 2))
                   (eq '~ (caar fp1))
                   (and (consp (cadar fp1))
                        (= (length (cadar fp1))
                           2))
                   (and (consp (caadr (car fp1)))
                        (= (length (caadr (car fp1)))
                           2))
                   (eq 'some
                       (caar (cadar fp1)))
                   (eq '* (cadr fp1))
                   (eq 'thm (caddr fp1)))
              (list
                (list (list 'all
                            (cadar (cadar fp1)))
                      (list '~
                            (cadar (cdar fp1))))
                '*
                'thm))
             (t fp1)))

(defun ~some_x_fx==>all_x_~fx&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 't-expr
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 't-expr))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        't-expr
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun replace-in-wff
       (fp1 fp2 fp3)
       (cond ((and (consp fp3)
                   (= (length fp3) 2)
                   (and (consp (car fp3))
                        (= (length (car fp3)) 2))
                   (eq 'all (caar fp3)))
              (list (list 'all (cadar fp3))
                    (replace-in-wff fp1 fp2 (cadr fp3))))
             ((and (consp fp3)
                   (= (length fp3) 2)
                   (and (consp (car fp3))
                        (= (length (car fp3)) 2))
                   (eq 'some (caar fp3)))
              (list (list 'some (cadar fp3))
                    (replace-in-wff fp1 fp2 (cadr fp3))))
             ((and (consp fp3)
                   (= (length fp3) 2)
                   (eq '~ (car fp3)))
              (list '~
                    (replace-in-wff fp1 fp2 (cadr fp3))))
             ((and (consp fp3)
                   (= (length fp3) 3)
                   (eq '& (cadr fp3)))
              (list (replace-in-wff fp1 fp2 (car fp3))
                    '&
                    (replace-in-wff fp1 fp2 (caddr fp3))))
             ((and (consp fp3)
                   (= (length fp3) 3)
                   (eq '=> (cadr fp3)))
              (list (replace-in-wff fp1 fp2 (car fp3))
                    '=>
                    (replace-in-wff fp1 fp2 (caddr fp3))))
             ((and (consp fp3)
                   (= (length fp3) 3)
                   (eq 'v (cadr fp3)))
              (list (replace-in-wff fp1 fp2 (car fp3))
                    'v
                    (replace-in-wff fp1 fp2 (caddr fp3))))
             ((and (consp fp3)
                   (= (length fp3) 3)
                   (eq '<=> (cadr fp3)))
              (list (replace-in-wff fp1 fp2 (car fp3))
                    '<=>
                    (replace-in-wff fp1 fp2 (caddr fp3))))
             ((and (consp fp3)
                   (= (length fp3) 2)
                   (eq '>> (car fp3))
                   (consp (cadr fp3)))
              (list '>>
                    (cons (caadr fp3)
                          (replace-in-wff-terms fp1
                                                fp2
                                                (cdadr fp3)))))
             (t fp3)))

(defun replace-in-wff&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or (eq 'wff
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'wff))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'term
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'term var#4?)
                                (list 'phi var#3? 'wff var#4?))
                          continuation))))
             ((backtrack))))

(defun replace-in-wff-terms
       (fp1 fp2 fp3)
       (declare (type list fp3))
       (the list
            (subst fp2 fp1 fp3 ':test 'equal)))

(defun replace-in-wff-terms&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list 'term))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (or
                            (eq 'term
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* 'term))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'term
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'term var#4?)
                                (list 'phi
                                      var#3?
                                      (list 'list 'term)
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun otter1
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 2)
                   (null (cadr fp1)))
              nil)
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (not (listp (car fp1))))
              (prog2 (warn "OTTER requires a list parameter")
                     (cadr fp1)))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (consp (cadr fp1)))
              (if (sequent->otter-problem (car fp1)
                                          (external-form (caadr fp1)))
                  (cdadr fp1)
                  (car (cdr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 1)
                   (consp (car fp1)))
              (warn "OTTER requires parameters.")
              (warn "Assuming binary resolution with factoring.")
              (if (sequent->otter-problem
                    (list (list 'binary_res '+)
                          (list 'factor '+))
                    (external-form (caar fp1)))
                  (cdar fp1)
                  (car fp1)))
             (t
              (warn "OTTER cannot process this.")
              (warn
                "Look at the OTTER manual and the online help for this tactic.")
              (head (last fp1)))))

(defun external-form
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '\|- (cadr fp1)))
              (external-vars-out
                (list
                  (mapcar 'external-syntax-out
                          (mapcar 'rem-dn (car fp1)))
                  '\|-
                  (external-syntax-out (rem-dn (caddr fp1))))))
             (t (raise "code 13: No Patterns have Fired in external-form"))))

(defun rem-dn
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 2)
                   (eq '~ (car fp1))
                   (and (consp (cadr fp1))
                        (= (length (cadr fp1))
                           2))
                   (eq '~ (caadr fp1)))
              (rem-dn (cadar (cdr fp1))))
             ((consp fp1) (mapcar 'rem-dn fp1))
             (t fp1)))

(defun sequent->otter-problem
       (fp1 fp2)
       (cond ((and (consp fp2)
                   (= (length fp2) 3)
                   (eq '\|- (cadr fp2)))
              (if (probe-file "temp")
                  (delete-file "temp"))
              (preamble fp1)
              (otter-axioms (car fp2))
              (otter-conclusion (caddr fp2))
              (if (probe-file "see")
                  (delete-file "see"))
              (run-unix-program "otter"
                                ':input
                                "temp"
                                ':output
                                "see")
              (get-otter-result "see"))
             (t
              (raise
                "code 13: No Patterns have Fired in sequent->otter-problem"))))

(defun get-otter-result
       (fp1)
       (set 'stream
            (open fp1 ':direction ':input))
       (prog1 (gor1 nil) (close stream)))

(defun gor1
       (fp1)
       (cond ((and (consp fp1)
                   (> (length fp1) 4)
                   (equal #\Y (car fp1))
                   (equal #\T (cadr fp1))
                   (equal #\P (caddr fp1))
                   (equal #\M (caddr (cdr fp1)))
                   (equal #\E
                          (caddr (cddr fp1))))
              (look-for-ans-clause (cdddr (cddr fp1))) t)
             ((and (consp fp1)
                   (> (length fp1) 3)
                   (equal #\T (car fp1))
                   (equal #\I (cadr fp1))
                   (equal #\N (caddr fp1))
                   (equal #\U (caddr (cdr fp1))))
              (look-for-ans-clause (cdddr (cdr fp1))) t)
             ((and (consp fp1)
                   (null (car fp1)))
              nil)
             ((and (consp fp1)
;;                   (> (length fp1) 3)
)
              (gor1
                (list (read-char-no-hang stream nil)
                      (car fp1)
                      (cadr fp1)
                      (caddr fp1)
                      (caddr (cdr fp1)))))
             (t (gor1 (cons (read-char-no-hang stream nil)
                            fp1)))))

(defun look-for-ans-clause
       (fp1)
       (cond ((and (consp fp1)
                   (null (car fp1)))
              nil)
             ((and (consp fp1)
                   (> (length fp1) 3)
                   (equal #\s (car fp1))
                   (equal #\n (cadr fp1))
                   (equal #\a (caddr fp1))
                   (equal #\$ (caddr (cdr fp1))))
              (format t
                      "ANSWER = ~A~%"
                      (car (ch-from-otter-sequel-syn (read stream)))))
             ((and (consp fp1)
                   (> (length fp1) 3))
              (look-for-ans-clause
                (list (read-char-no-hang stream nil)
                      (car fp1)
                      (cadr fp1)
                      (caddr fp1)
                      (caddr (cdr fp1)))))
             (t
              (look-for-ans-clause
                (cons (read-char-no-hang stream nil)
                      fp1)))))

(defun ch-from-otter-sequel-syn
       (fp1)
       (cond ((null fp1) nil)
             ((and (consp fp1)
                   (comma (car fp1)))
              (ch-from-otter-sequel-syn (cdr fp1)))
             ((and (consp fp1)
                   (> (length fp1) 1)
                   (consp (cadr fp1))
                   (symbolp (car fp1)))
              (ch-from-otter-sequel-syn
                (cons (cons (car fp1)
                            (car (cdr fp1)))
                      (cddr fp1))))
             ((and (consp fp1)
                   (consp (car fp1)))
              (cons (ch-from-otter-sequel-syn (car fp1))
                    (ch-from-otter-sequel-syn (cdr fp1))))
             ((consp fp1)
              (cons (car fp1)
                    (ch-from-otter-sequel-syn (cdr fp1))))
             (t
              (raise
                "code 13: No Patterns have Fired in ch-from-otter-sequel-syn"))))

(defun preamble
       (fp1)
       (cond ((null fp1)
              (set 'stream
                   (open "temp" ':direction ':output))
              (write-line "set(hyper_res)." stream)
              (write-line "formula_list(usable)." stream)
              (close stream))
             (t
              (set 'stream
                   (open "temp" ':direction ':output))
              (mapcar 'preamble-line fp1)
              (write-line "formula_list(usable)." stream)
              (close stream))))

(defun preamble-line
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 2)
                   (member (cadr fp1)
                           (list '+ '-))
                   (member (car fp1)
                           (list 'input_sos_queue
                                 'sos_queue
                                 'sos_stack
                                 'print_given
                                 'binary_res
                                 'hyper_res
                                 'ur_res
                                 'para_into
                                 'para_from
                                 'demod_inf
                                 'para_from_left
                                 'para_from_right
                                 'para_into_left
                                 'para_into_right
                                 'para_from_vars
                                 'para_into_vars
                                 'para_from_units_only
                                 'para_into_units_only
                                 'para_skip_skolem
                                 'para_ones_rule
                                 'para_all
                                 'very_verbose
                                 'order_eq
                                 'sort_literals
                                 'delete_identical_nested_skolem
                                 'for_sub
                                 'unit_deletion
                                 'print_kept
                                 'print_proofs
                                 'back_sub
                                 'print_back_sub
                                 'factor
                                 'demod_history
                                 'demod_linear
                                 'demod_out_in
                                 'dynamic_demod
                                 'dynamic_demod_all
                                 'print_new_demod
                                 'back_demod
                                 'print_back_demod
                                 'symbol_elim
                                 'knuth_bendix
                                 'lex_rpo
                                 'dynamic_demod_lex_dep
                                 'lex_order_vars
                                 'for_sub_fpa
                                 'no_fapl
                                 'no_fanl
                                 'check_arity
                                 'process_input
                                 'simplify_fol
                                 'bird_print
                                 'free_all_mem
                                 'atom_wt_max_args
                                 'term_wt_max_args
                                 'print_lists_at_end
                                 'really_delete_clauses)))
              (write-line
                (format nil
                        "~A(~A)."
                        (otter-status (cadr fp1))
                        (car fp1))
                stream))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (integerp (cadr fp1))
                   (>= (cadr fp1) 0)
                   (member (car fp1)
                           (list 'report
                                 'max_seconds
                                 'max_gen
                                 'max_kept
                                 'max_given
                                 'max_mem
                                 'max_literals
                                 'max_weight
                                 'demod_limit
                                 'max_proofs
                                 'neg_weight)))
              (write-line
                (format nil
                        "assign(~A,~A)."
                        (car fp1)
                        (cadr fp1))
                stream))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (eq 'fpa_literals (car fp1))
                   (integerp (cadr fp1))
                   (>= (cadr fp1) 0)
                   (>= 8 (cadr fp1)))
              (write-line
                (format nil
                        "assign(fpa_literals,~A)."
                        (cadr fp1))
                stream))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (eq 'fpa_terms (car fp1))
                   (integerp (cadr fp1))
                   (>= (cadr fp1) 0)
                   (>= 8 (cadr fp1)))
              (write-line (format nil
                                  "assign(fpa_terms ,~A)."
                                  (cadr fp1))
                          stream))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (eq 'stats_level (car fp1))
                   (integerp (cadr fp1))
                   (>= (cadr fp1) 0)
                   (>= 3 (cadr fp1)))
              (write-line (format nil
                                  "assign(stats_level,~A)."
                                  (cadr fp1))
                          stream))
             (t
              (warn (format nil
                            "~A is not a legal OTTER setting.~%"
                            fp1)))))

(defun otter-status
       (fp1)
       (cond ((eq '+ fp1) 'set)
             ((eq '- fp1) 'clear)
             (t (raise "code 13: No Patterns have Fired in otter-status"))))

(defun otter-axioms
       (fp1)
       (mapcar
         #'(lambda (x)
            (with-open-file (out "temp" :direction :output :if-exists :append)
             (write-line (sequel-wff->otter-wff x) out)))
         fp1))

(defun otter-conclusion
       (fp1)
       (with-open-file (out "temp"
                            ':direction
                            ':output
                            ':if-exists
                            ':append)
                       (progn (write-line "end_of_list." out)
                              (write-line "formula_list(sos)."
                                          out)
                              (write-line (sequel-wff->otter-wff (compl fp1))
                                          out))))

(defun compl
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 2)
                   (eq '~ (car fp1)))
              (cadr fp1))
             (t (list '~ fp1))))

(defun sequel-wff->otter-wff
       (fp1)
       (combine-strings (otter-strings (preprocess-to-otter fp1))))

(defun otter-strings
       (fp1)
       (cond ((and (consp fp1)
                   (eq '- (car fp1)))
              (append (otter-strings1 (cons '- (cdr fp1)))
                      (list ".")))
             (t
              (if (otter-literal fp1)
                  (append (otter-strings1 fp1)
                          (list "."))
                  (append (cons "("
                                (otter-strings1 fp1))
                          (list ")."))))))

(defun otter-strings1 (fp1)
  (cond ((null fp1) nil)
        ((and (consp fp1)
              (> (length fp1) 1)
              (eq '- (car fp1)))
         (cons (format nil "-")
               (otter-strings1 (cdr fp1))))
        ((and (consp fp1)
              (eq '-> (car fp1)))
         (cons (format nil "-> ")
               (otter-strings1 (cdr fp1))))
        ((and (consp fp1)
              (> (length fp1) 1)
              (consp (cadr fp1))
              (otter-literal (car (cdr fp1))))
         (cons (format nil "~A(" (car fp1))
               (otter-strings1
                 (append (car (cdr fp1))
                         (list ")")
                         (cddr fp1)))))
        ((and (consp fp1)
              (> (length fp1) 1)
              (consp (cadr fp1)))
         (cons (format nil "~A (" (car fp1))
               (otter-strings1
                 (append (car (cdr fp1))
                         (list ") ")
                         (cddr fp1)))))
        ((and (consp fp1)
              (consp (car fp1)))
         (cons (format nil "(")
               (otter-strings1
                 (append (car fp1)
                         (list ")")
                         (cdr fp1)))))
        ((and (consp fp1)
              (> (length fp1) 1)
              (equal ")" (cadr fp1)))
         (cons (format nil "~A) " (car fp1))
               (otter-strings1 (cddr fp1))))
        ((consp fp1)
         (cons (format nil "~A " (car fp1))
               (otter-strings1 (cdr fp1))))
        (t (raise "code 13: No Patterns have Fired in otter-strings1"))))

(defun preprocess-to-otter
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 2)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 2))
                   (eq 'some (caar fp1)))
              (comb-otter-literals
                (list 'exists
                      (cadar fp1)
                      (preprocess-to-otter (cadr fp1)))))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 2))
                   (eq 'all (caar fp1)))
              (comb-otter-literals
                (list 'all
                      (cadar fp1)
                      (preprocess-to-otter (cadr fp1)))))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (eq '~ (car fp1)))
              (comb-otter-literals
                (list '-
                      (preprocess-to-otter (cadr fp1)))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '=> (cadr fp1)))
              (comb-otter-literals
                (list (preprocess-to-otter (car fp1))
                      '->
                      (preprocess-to-otter (caddr fp1)))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '<=> (cadr fp1)))
              (comb-otter-literals
                (list (preprocess-to-otter (car fp1))
                      '<->
                      (preprocess-to-otter (caddr fp1)))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq 'v (cadr fp1)))
              (comb-otter-literals
                (list (preprocess-to-otter (car fp1))
                      "| "
                      (preprocess-to-otter (caddr fp1)))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '& (cadr fp1)))
              (comb-otter-literals
                (list (preprocess-to-otter (car fp1))
                      '&
                      (preprocess-to-otter (caddr fp1)))))
             (t (preprocess-to-otter-literalic-otter fp1))))

(defun comb-otter-literals
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 2)
                   (eq '- (car fp1))
                   (otter-literal (cadr fp1)))
              (append (list '-) (cadr fp1)))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq 'exists (car fp1))
                   (otter-literal (caddr fp1)))
              (cons 'exists
                    (cons (cadr fp1) (caddr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq 'exists (car fp1)))
              (list 'exists
                    (cadr fp1)
                    (caddr fp1)))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq 'all (car fp1))
                   (otter-literal (caddr fp1)))
              (cons 'all
                    (cons (cadr fp1) (caddr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq 'all (car fp1)))
              (list 'all (cadr fp1) (caddr fp1)))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (otter-literal (car fp1))
                   (otter-literal (caddr fp1)))
              (append (car fp1)
                      (list (cadr fp1))
                      (caddr fp1)))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (otter-literal (car fp1)))
              (append (car fp1)
                      (list (cadr fp1) (caddr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (otter-literal (caddr fp1)))
              (append (list (car fp1) (cadr fp1))
                      (caddr fp1)))
             (t fp1)))

(defun otter-literal
       (fp1)
       (cond ((and (consp fp1)
                   (eq '- (car fp1))
                   (not
                     (or (occurs 'exists (cdr fp1))
                         (occurs 'all (cdr fp1))
                         (occurs '-> (cdr fp1))
                         (occurs '<-> (cdr fp1))
                         (occurs "| " (cdr fp1))
                         (occurs '& (cdr fp1)))))
              t)
             ((or (occurs 'exists fp1)
                  (occurs 'all fp1)
                  (occurs '-> fp1)
                  (occurs '<-> fp1)
                  (occurs "| " fp1)
                  (occurs '& fp1))
              nil)
             (t t)))

(defun preprocess-to-otter-literalic-otter
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '= (car fp1)))
              (list
                (append (preprocess-to-otter-terms (list (cadr fp1)))
                        (list '=)
                        (preprocess-to-otter-terms (list (caddr fp1))))))
             ((consp fp1)
              (list (car fp1)
                    (preprocess-to-otter-terms (cdr fp1))))
             (t (list fp1))))

(defun preprocess-to-otter-terms
       (fp1)
       (cond ((null fp1) nil)
             ((and (consp fp1)
                   (= (length fp1) 1)
                   (consp (car fp1)))
              (list (caar fp1)
                    (preprocess-to-otter-terms (cdar fp1))))
             ((and (consp fp1)
                   (= (length fp1) 1))
              (list (car fp1)))
             ((and (consp fp1)
                   (consp (car fp1)))
              (cons (caar fp1)
                    (cons (preprocess-to-otter-terms (cdar fp1))
                          (cons ","
                                (preprocess-to-otter-terms (cdr fp1))))))
             ((consp fp1)
              (cons (car fp1)
                    (cons ","
                          (preprocess-to-otter-terms (cdr fp1)))))
             (t
              (raise
                "code 13: No Patterns have Fired in preprocess-to-otter-terms"))))

(defun combine-strings
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 1))
              (car fp1))
             ((and (consp fp1)
                   (> (length fp1) 1))
              (combine-strings
                (cons (format nil
                              "~A~A"
                              (car fp1)
                              (cadr fp1))
                      (cddr fp1))))
             (t (raise "code 13: No Patterns have Fired in combine-strings"))))

(defun all-left-help
       (fp1 fp2 fp3 fp4)
       (declare (type integer fp1)
                (type list fp3)
                (type list fp4))
       (the list
            (cond ((and (consp fp3)
                        (= (length fp3) 3)
                        (eq '\|- (cadr fp3))
                        (>= (length (car fp3))
                            fp1))
                   (all-left-help1 fp2
                                   (list (car fp3)
                                         '\|-
                                         (caddr fp3))
                                   (xnth (1- fp1) (car fp3))
                                   fp4))
                  (t fp4))))

(defun all-left-help&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3? var#4?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 4)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))
                          (bind var#4?
                                (caddr (cdr fp1)))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#5?)
                        (append
                          (list (list 'phi var#2? 'term var#5?)
                                (list 'phi var#3? 'sequent var#5?)
                                (list 'phi var#4? 'proof var#5?))
                          continuation))))
             ((backtrack))))

(defun all-left-help1
       (fp1 fp2 fp3 fp4)
       (declare (type list fp2)
                (type list fp4))
       (the list
            (cond ((and (consp fp2)
                        (= (length fp2) 3)
                        (eq '\|- (cadr fp2))
                        (and (consp fp3)
                             (= (length fp3) 3))
                        (and (consp (car fp3))
                             (= (length (car fp3))
                                2))
                        (and (consp (caar fp3))
                             (= (length (caar fp3))
                                2))
                        (eq 'all
                            (caar (car fp3)))
                        (eq '* (cadr fp3))
                        (eq 'thm (caddr fp3)))
                   (repseq
                     (list
                       (cons
                         (list
                           (replace-in-wff (cadar (car fp3))
                                           fp1
                                           (cadar fp3))
                           '*
                           'thm)
                         (car fp2))
                       '\|-
                       (caddr fp2))
                     fp4))
                  (t fp4))))

(defun all-left-help1&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3? var#4?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 4)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))
                          (bind var#4?
                                (caddr (cdr fp1)))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'term
                        (lderef var#5?)
                        (append
                          (list (list 'phi var#2? 'sequent var#5?)
                                (list 'phi var#3? 't-expr var#5?)
                                (list 'phi var#4? 'proof var#5?))
                          continuation))))
             ((backtrack))))

(defun some-right-help
       (fp1 fp2 fp3)
       (declare (type list fp2)
                (type list fp3))
       (the list
            (cond ((and (consp fp2)
                        (= (length fp2) 3)
                        (eq '\|- (cadr fp2))
                        (and (consp (caddr fp2))
                             (= (length (caddr fp2))
                                3))
                        (and (consp (caadr (cdr fp2)))
                             (= (length (caadr (cdr fp2)))
                                2))
                        (and (consp (caar (caddr fp2)))
                             (= (length (caar (caddr fp2)))
                                2))
                        (eq 'some
                            (caar (caadr (cdr fp2))))
                        (eq '*
                            (cadar (cddr fp2)))
                        (eq 'thm
                            (caddr (caddr fp2))))
                   (repseq
                     (list (car fp2)
                           '\|-
                           (list
                             (replace-in-wff (cadar (caadr (cdr fp2)))
                                             fp1
                                             (cadar (caddr fp2)))
                             '*
                             'thm))
                     fp3))
                  (t fp3))))

(defun some-right-help&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'term
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'sequent var#4?)
                                (list 'phi var#3? 'proof var#4?))
                          continuation))))
             ((backtrack))))

(defun osymbol
       (fp1 fp2 continuation)
       (cond ((and (rename '(var#1?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list 'gentemp))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (or (eq 'gentemp
                                    (setq *tempreg* (car fp1)))
                                (qtrybind *tempreg* 'gentemp))))
                   (bind var#1? fp2)
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun term
       (fp1 fp2 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or
                              (list 'or 'string 'unit)
                              (list 'or 'osymbol 'integer))
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun wff
       (fp1 fp2 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'osymbol
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun type
       (fp1 fp2 continuation)
       (cond ((and (rename '(var#1?))
                   (or (eq 'thm
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'thm))
                   (bind var#1? fp2)
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun termrewrite
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 3))
                   (eq 'cons (caar fp1))
                   (eq '* (cadr fp1))
                   (eq 'term (caddr fp1)))
              (list (list (cadar fp1) '* 'osymbol)
                    (list (caddr (car fp1))
                          '*
                          (list 'list 'term))))
             (t fp1)))

(defun wffrewrite
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 3))
                   (eq 'cons (caar fp1))
                   (and (consp (cadar fp1))
                        (= (length (cadar fp1))
                           3))
                   (eq 'cons
                       (caadr (car fp1)))
                   (eq 'some
                       (cadar (cdar fp1)))
                   (and (consp (caddr (cadar fp1)))
                        (= (length (caddr (cadar fp1)))
                           3))
                   (eq 'cons
                       (caadr (cdadr (car fp1))))
                   (null (caddr (caddr (cadar fp1))))
                   (and (consp (caddr (car fp1)))
                        (= (length (caddr (car fp1)))
                           3))
                   (eq 'cons
                       (caadr (cdar fp1)))
                   (null (caddr (caddr (car fp1))))
                   (eq '* (cadr fp1))
                   (eq 'wff (caddr fp1)))
              (list (list (cadar (cddar (cdar fp1)))
                          '*
                          'osymbol)
                    (list (cadar (cddar fp1))
                          '*
                          'wff)))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 3))
                   (eq 'cons (caar fp1))
                   (and (consp (cadar fp1))
                        (= (length (cadar fp1))
                           3))
                   (eq 'cons
                       (caadr (car fp1)))
                   (eq 'all
                       (cadar (cdar fp1)))
                   (and (consp (caddr (cadar fp1)))
                        (= (length (caddr (cadar fp1)))
                           3))
                   (eq 'cons
                       (caadr (cdadr (car fp1))))
                   (null (caddr (caddr (cadar fp1))))
                   (and (consp (caddr (car fp1)))
                        (= (length (caddr (car fp1)))
                           3))
                   (eq 'cons
                       (caadr (cdar fp1)))
                   (null (caddr (caddr (car fp1))))
                   (eq '* (cadr fp1))
                   (eq 'wff (caddr fp1)))
              (list (list (cadar (cddar (cdar fp1)))
                          '*
                          'osymbol)
                    (list (cadar (cddar fp1))
                          '*
                          'wff)))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 3))
                   (eq 'cons (caar fp1))
                   (and (consp (caddr (car fp1)))
                        (= (length (caddr (car fp1)))
                           3))
                   (eq 'cons
                       (caadr (cdar fp1)))
                   (eq 'v
                       (cadar (cddar fp1)))
                   (and (consp (caddr (caddr (car fp1))))
                        (= (length (caddr (caddr (car fp1))))
                           3))
                   (eq 'cons
                       (caadr (cdadr (cdar fp1))))
                   (null (caddr (caddr (caddr (car fp1)))))
                   (eq '* (cadr fp1))
                   (eq 'wff (caddr fp1)))
              (list (list (cadar fp1) '* 'wff)
                    (list (cadar (cddar (cddar fp1)))
                          '*
                          'wff)))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 3))
                   (eq 'cons (caar fp1))
                   (and (consp (caddr (car fp1)))
                        (= (length (caddr (car fp1)))
                           3))
                   (eq 'cons
                       (caadr (cdar fp1)))
                   (eq '&
                       (cadar (cddar fp1)))
                   (and (consp (caddr (caddr (car fp1))))
                        (= (length (caddr (caddr (car fp1))))
                           3))
                   (eq 'cons
                       (caadr (cdadr (cdar fp1))))
                   (null (caddr (caddr (caddr (car fp1)))))
                   (eq '* (cadr fp1))
                   (eq 'wff (caddr fp1)))
              (list (list (cadar fp1) '* 'wff)
                    (list (cadar (cddar (cddar fp1)))
                          '*
                          'wff)))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 3))
                   (eq 'cons (caar fp1))
                   (and (consp (caddr (car fp1)))
                        (= (length (caddr (car fp1)))
                           3))
                   (eq 'cons
                       (caadr (cdar fp1)))
                   (eq '<=>
                       (cadar (cddar fp1)))
                   (and (consp (caddr (caddr (car fp1))))
                        (= (length (caddr (caddr (car fp1))))
                           3))
                   (eq 'cons
                       (caadr (cdadr (cdar fp1))))
                   (null (caddr (caddr (caddr (car fp1)))))
                   (eq '* (cadr fp1))
                   (eq 'wff (caddr fp1)))
              (list (list (cadar fp1) '* 'wff)
                    (list (cadar (cddar (cddar fp1)))
                          '*
                          'wff)))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 3))
                   (eq 'cons (caar fp1))
                   (and (consp (caddr (car fp1)))
                        (= (length (caddr (car fp1)))
                           3))
                   (eq 'cons
                       (caadr (cdar fp1)))
                   (eq '=>
                       (cadar (cddar fp1)))
                   (and (consp (caddr (caddr (car fp1))))
                        (= (length (caddr (caddr (car fp1))))
                           3))
                   (eq 'cons
                       (caadr (cdadr (cdar fp1))))
                   (null (caddr (caddr (caddr (car fp1)))))
                   (eq '* (cadr fp1))
                   (eq 'wff (caddr fp1)))
              (list (list (cadar fp1) '* 'wff)
                    (list (cadar (cddar (cddar fp1)))
                          '*
                          'wff)))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 3))
                   (eq 'cons (caar fp1))
                   (eq '~ (cadar fp1))
                   (and (consp (caddr (car fp1)))
                        (= (length (caddr (car fp1)))
                           3))
                   (eq 'cons
                       (caadr (cdar fp1)))
                   (null (caddr (caddr (car fp1))))
                   (eq '* (cadr fp1))
                   (eq 'wff (caddr fp1)))
              (list (list (cadar (cddar fp1))
                          '*
                          'wff)))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (and (consp (car fp1))
                        (= (length (car fp1)) 3))
                   (eq 'cons (caar fp1))
                   (eq '>> (cadar fp1))
                   (and (consp (caddr (car fp1)))
                        (= (length (caddr (car fp1)))
                           3))
                   (eq 'cons
                       (caadr (cdar fp1)))
                   (and (consp (cadar (cddar fp1)))
                        (= (length (cadar (cddar fp1)))
                           3))
                   (eq 'cons
                       (caadr (caddr (car fp1))))
                   (null (caddr (caddr (car fp1))))
                   (eq '* (cadr fp1))
                   (eq 'wff (caddr fp1)))
              (list (list (cadar (cdadr (cdar fp1)))
                          '*
                          'symbol)
                    (list (caddr (cadar (cddar fp1)))
                          '*
                          (list 'list 'term))))
             (t fp1)))

(defun &-left
       (fp1)
       (declare (type list fp1))
       (the list (refine 'seq 3 fp1)))

(defun &-left&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun &-right
       (fp1)
       (declare (type list fp1))
       (the list (refine 'seq 4 fp1)))

(defun &-right&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun =>-left
       (fp1)
       (declare (type list fp1))
       (the list (refine 'seq 8 fp1)))

(defun =>-left&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun =>-right
       (fp1)
       (declare (type list fp1))
       (the list (refine 'seq 9 fp1)))

(defun =>-right&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun all-left
       (fp1 fp2 fp3)
       (declare (type integer fp1)
                (type list fp3))
       (the list
            (all-left-help fp1 fp2 (head fp3) fp3)))

(defun all-left&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'term var#4?)
                                (list 'phi var#3? 'proof var#4?))
                          continuation))))
             ((backtrack))))

(defun all-right
       (fp1)
       (declare (type list fp1))
       (the list (refine 'seq 10 fp1)))

(defun all-right&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun contradiction
       (fp1)
       (declare (type list fp1))
       (the list (refine 'seq 2 fp1)))

(defun contradiction&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun indirect-proof
       (fp1)
       (declare (type list fp1))
       (the list (refine 'seq 1 fp1)))

(defun indirect-proof&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun some-left
       (fp1 fp2)
       (declare (type integer fp1)
                (type list fp2))
       (the list
            (some-left-axiom (swap 1 fp1 fp2))))

(defun some-left&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append (list (list 'phi var#2? 'proof var#3?))
                                continuation))))
             ((backtrack))))

(defun some-right
       (fp1 fp2)
       (declare (type list fp2))
       (the list
            (some-right-help fp1 (head fp2) fp2)))

(defun some-right&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'term
                        (lderef var#3?)
                        (append (list (list 'phi var#2? 'proof var#3?))
                                continuation))))
             ((backtrack))))

(defun v-left
       (fp1)
       (declare (type list fp1))
       (the list (refine 'seq 5 fp1)))

(defun v-left&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun v-right-1
       (fp1)
       (declare (type list fp1))
       (the list (refine 'seq 6 fp1)))

(defun v-right-1&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun v-right-2
       (fp1)
       (declare (type list fp1))
       (the list (refine 'seq 7 fp1)))

(defun v-right-2&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun startup-framework
       nil
       (restore-sigs
         '((~<pvq>==>~p&~q (t-expr -> t-expr))
           (~<p&q>==>~pv~q (t-expr -> t-expr)) (~~p==>p (t-expr -> t-expr))
           (~<p<=>q>==><<p&~q>v<~p&q>> (t-expr -> t-expr))
           (~<p=>q>==><p&~q> (t-expr -> t-expr))
           (p<=>q==><p=>q>&<q=>p> (t-expr -> t-expr))
           (p=>q==>~pvq (t-expr -> t-expr))
           (~all_x_fx==>some_x_~fx (t-expr -> t-expr))
           (~some_x_fx==>all_x_~fx (t-expr -> t-expr))
           (replace-in-wff (term term wff -> wff))
           (replace-in-wff-terms (term term (list term) -> (list term)))
           (all-left-help (integer term sequent proof -> proof))
           (all-left-help1 (term sequent t-expr proof -> proof))
           (some-right-help (term sequent proof -> proof))
           (&-left (proof -> proof)) (&-right (proof -> proof))
           (=>-left (proof -> proof)) (=>-right (proof -> proof))
           (all-left (integer term proof -> proof))
           (all-right (proof -> proof)) (contradiction (proof -> proof))
           (indirect-proof (proof -> proof))
           (some-left (integer proof -> proof))
           (some-right (term proof -> proof)) (v-left (proof -> proof))
           (v-right-1 (proof -> proof)) (v-right-2 (proof -> proof))))
       (restore-axioms
         '((seq inter
            ((lambda (fp1 fp2 fp3 continuation)
              (and (rename '(var#1? var#2? var#3?)) (bind var#1? fp1)
               (bind var#2? fp2)
               (or (eq 'thm (setq *tempreg* fp3)) (qtrybind *tempreg* 'thm))
               (change-stacks)
               (logic-equal (lderef var#1?) (lderef var#3?)
                (append
                 (list
                  (list 'return-sequents
                   (list
                    (list
                     (list '**append**
                      (list (list (list '~ var#2?) '* 'thm)) var#3?)
                     '\|- (list 'false '* 'thm)))))
                 continuation))))
             (lambda (fp1 fp2 fp3 continuation)
              (and (rename '(var#2? var#4? var#1? var#3?)) (bind var#1? fp1)
               (bind var#2? fp2)
               (or (eq 'thm (setq *tempreg* fp3)) (qtrybind *tempreg* 'thm))
               (change-stacks)
               (immediate (list (lderef var#3?) '* 'thm) (lderef var#1?)
                (append
                 (list
                  (list 'immediate (list (list '~ var#3?) '* 'thm) var#1?)
                  (list 'logic-difference var#4? var#1?
                   (list (list var#3? '* 'thm)
                    (list (list '~ var#3?) '* 'thm)))
                  (list 'return-sequents nil))
                 continuation))))
             (lambda (fp1 fp2 fp3 continuation)
              (and (rename '(var#1? var#3? var#4? var#5? var#2?))
               (bind var#1? fp1) (bind var#2? fp2)
               (or (eq 'thm (setq *tempreg* fp3)) (qtrybind *tempreg* 'thm))
               (change-stacks)
               (immediate
                (list (list (lderef var#3?) '& (lderef var#4?)) '* 'thm)
                (lderef var#1?)
                (append
                 (list
                  (list 'logic-difference var#5? var#1?
                   (list (list (list var#3? '& var#4?) '* 'thm)))
                  (list 'return-sequents
                   (list
                    (list
                     (list '**append**
                      (list (list var#3? '* 'thm) (list var#4? '* 'thm)) var#5?)
                     '\|- (list var#2? '* 'thm)))))
                 continuation))))
             (lambda (fp1 fp2 fp3 continuation)
              (and (rename '(var#1? var#2? var#4? var#3?)) (bind var#1? fp1)
               (or
                (qtrybind (setq *tempreg* fp2) (list var#2? '& var#3?))
                (and (consp *tempreg*) (= (length *tempreg*) 3)
                 (bind var#2? (car fp2))
                 (or (eq '& (setq *tempreg* (car (cdr fp2))))
                  (qtrybind *tempreg* '&))
                 (bind var#3? (car (cdr (cdr fp2))))))
               (or (eq 'thm (setq *tempreg* (lderef fp3)))
                (qtrybind *tempreg* 'thm))
               (change-stacks)
               (logic-equal (lderef var#1?) (lderef var#4?)
                (append
                 (list
                  (list 'return-sequents
                   (list (list var#4? '\|- (list var#2? '* 'thm))
                    (list var#4? '\|- (list var#3? '* 'thm)))))
                 continuation))))
             (lambda (fp1 fp2 fp3 continuation)
              (and (rename '(var#1? var#3? var#4? var#5? var#2?))
               (bind var#1? fp1) (bind var#2? fp2)
               (or (eq 'thm (setq *tempreg* fp3)) (qtrybind *tempreg* 'thm))
               (change-stacks)
               (immediate
                (list (list (lderef var#3?) 'v (lderef var#4?)) '* 'thm)
                (lderef var#1?)
                (append
                 (list
                  (list 'logic-difference var#5? var#1?
                   (list (list (list var#3? 'v var#4?) '* 'thm)))
                  (list 'return-sequents
                   (list
                    (list
                     (list '**append** (list (list var#3? '* 'thm)) var#5?)
                     '\|- (list var#2? '* 'thm))
                    (list
                     (list '**append** (list (list var#4? '* 'thm)) var#5?)
                     '\|- (list var#2? '* 'thm)))))
                 continuation))))
             (lambda (fp1 fp2 fp3 continuation)
              (and (rename '(var#3? var#1? var#4? var#2?)) (bind var#1? fp1)
               (or
                (qtrybind (setq *tempreg* fp2) (list var#2? 'v var#3?))
                (and (consp *tempreg*) (= (length *tempreg*) 3)
                 (bind var#2? (car fp2))
                 (or (eq 'v (setq *tempreg* (car (cdr fp2))))
                  (qtrybind *tempreg* 'v))
                 (bind var#3? (car (cdr (cdr fp2))))))
               (or (eq 'thm (setq *tempreg* (lderef fp3)))
                (qtrybind *tempreg* 'thm))
               (change-stacks)
               (logic-equal (lderef var#1?) (lderef var#4?)
                (append
                 (list
                  (list 'return-sequents
                   (list (list var#4? '\|- (list var#2? '* 'thm)))))
                 continuation))))
             (lambda (fp1 fp2 fp3 continuation)
              (and (rename '(var#2? var#1? var#4? var#3?)) (bind var#1? fp1)
               (or
                (qtrybind (setq *tempreg* fp2) (list var#2? 'v var#3?))
                (and (consp *tempreg*) (= (length *tempreg*) 3)
                 (bind var#2? (car fp2))
                 (or (eq 'v (setq *tempreg* (car (cdr fp2))))
                  (qtrybind *tempreg* 'v))
                 (bind var#3? (car (cdr (cdr fp2))))))
               (or (eq 'thm (setq *tempreg* (lderef fp3)))
                (qtrybind *tempreg* 'thm))
               (change-stacks)
               (logic-equal (lderef var#1?) (lderef var#4?)
                (append
                 (list
                  (list 'return-sequents
                   (list (list var#4? '\|- (list var#3? '* 'thm)))))
                 continuation))))
             (lambda (fp1 fp2 fp3 continuation)
              (and (rename '(var#1? var#2? var#4? var#3?)) (bind var#1? fp1)
               (bind var#2? fp2)
               (or (eq 'thm (setq *tempreg* fp3)) (qtrybind *tempreg* 'thm))
               (change-stacks)
               (immediate
                (list (list (lderef var#3?) '=> (lderef var#2?)) '* 'thm)
                (lderef var#1?)
                (append
                 (list
                  (list 'logic-difference var#4? var#1?
                   (list (list (list var#3? '=> var#2?) '* 'thm)))
                  (list 'return-sequents
                   (list
                    (list
                     (list '**append**
                      (list (list (list var#3? '=> var#2?) '* 'thm)) var#4?)
                     '\|- (list var#3? '* 'thm)))))
                 continuation))))
             (lambda (fp1 fp2 fp3 continuation)
              (and (rename '(var#1? var#2? var#4? var#3?)) (bind var#1? fp1)
               (or
                (qtrybind (setq *tempreg* fp2) (list var#2? '=> var#3?))
                (and (consp *tempreg*) (= (length *tempreg*) 3)
                 (bind var#2? (car fp2))
                 (or (eq '=> (setq *tempreg* (car (cdr fp2))))
                  (qtrybind *tempreg* '=>))
                 (bind var#3? (car (cdr (cdr fp2))))))
               (or (eq 'thm (setq *tempreg* (lderef fp3)))
                (qtrybind *tempreg* 'thm))
               (change-stacks)
               (logic-equal (lderef var#1?) (lderef var#4?)
                (append
                 (list
                  (list 'return-sequents
                   (list
                    (list
                     (list '**append** (list (list var#2? '* 'thm)) var#4?)
                     '\|- (list var#3? '* 'thm)))))
                 continuation))))
             (lambda (fp1 fp2 fp3 continuation)
              (and (rename '(var#1? var#2? var#3? var#4? var#5?))
               (bind var#1? fp1)
               (or
                (qtrybind (setq *tempreg* fp2)
                 (list (list 'all var#2?) var#3?))
                (and (consp *tempreg*) (= (length *tempreg*) 2)
                 (or
                  (qtrybind (setq *tempreg* (car fp2)) (list 'all var#2?))
                  (and (consp *tempreg*) (= (length *tempreg*) 2)
                   (or (eq 'all (setq *tempreg* (car (car fp2))))
                    (qtrybind *tempreg* 'all))
                   (bind var#2? (car (cdr (car fp2))))))
                 (bind var#3? (car (cdr fp2)))))
               (or (eq 'thm (setq *tempreg* (lderef fp3)))
                (qtrybind *tempreg* 'thm))
               (change-stacks)
               (logic-equal (lderef var#1?) (lderef var#4?)
                (append
                 (list
                  (list 'side-condition
                   (list 'bind var#5? (list 'freshterm var#2? var#3?)))
                  (list 'return-sequents
                   (list (list var#4? '\|- (list var#5? '* 'thm)))))
                 continuation))))
             (lambda (fp1 fp2 fp3 continuation)
              (and (rename '(var#1? var#3? var#4? var#6? var#5? var#2?))
               (bind var#1? fp1) (bind var#2? fp2)
               (or (eq 'thm (setq *tempreg* fp3)) (qtrybind *tempreg* 'thm))
               (change-stacks)
               (immediate
                (list (list (list 'some (lderef var#3?)) (lderef var#4?)) '*
                 'thm)
                (lderef var#1?)
                (append
                 (list
                  (list 'logic-difference var#5? var#1?
                   (list (list (list (list 'some var#3?) var#4?) '* 'thm)))
                  (list 'side-condition
                   (list 'bind var#6? (list 'freshterm var#3? var#4?)))
                  (list 'return-sequents
                   (list
                    (list
                     (list '**append** (list (list var#6? '* 'thm)) var#5?)
                     '\|- (list var#2? '* 'thm)))))
                 continuation))))))))
       (restore-globals '((*copies* identifier integer 1)))
       (setq *autotypes* '(osymbol term wff type proof proof-object sequent
                           t-expr))
       (setq *tactics0* '(otter))
       (setq *tactics1* 'nil)
       (setq *tactics2* '(&-left &-right =>-left =>-right all-left all-right
                          contradiction indirect-proof some-left some-right
                          v-left v-right-1 v-right-2))
       (setq *rewrites* '(p<=>q==><p=>q>&<q=>p> p=>q==>~pvq ~<p&q>==>~pv~q
                          ~<p<=>q>==><<p&~q>v<~p&q>> ~<p=>q>==><p&~q>
                          ~<pvq>==>~p&~q ~all_x_fx==>some_x_~fx
                          ~some_x_fx==>all_x_~fx ~~p==>p))
       (setq *theories* '(seq))
       (setq *framework* "SQOTTER")
       (setq *author* "Mark Tarver")
       (setq *date* "23-2-93")
       (setq *primitives* '(string integer bool symbol rational character float
                            osymbol))
       (restore-primitives
         '((string recognisor stringp) (integer recognisor integerp)
           (bool recognisor boolp) (symbol recognisor mysymbolp)
           (rational recognisor rationalp) (character recognisor characterp)
           (float recognisor floatp) (osymbol recognisor is-osymbol)))
       (setq *constants* '(true false thm v & ~ => <=> all some >>))
       (restore-documentation
         '((otter
            "Calls OTTER on a problem.  OTTER is a powerful resolution 
theorem-prover written in C from the Argonne group in Illinois. 
OTTER is documented in the the OTTER manual in FRAMEWORKS/OTTER22.  

     The OTTER tactic receives a list of settings.  For example

OTTER ((ur_res +) (max_seconds 20))

calls OTTER with UR resolution and a maximum of 20 seconds of CPU 
time allowed.  Settings in OTTER are either flags (which are set to
either + or -; meaning 'on' and 'off') or parameters which are set
to a numerical value.  For information on the range of OTTER settings
available, see the OTTER manual.  Notice the OTTER tactic expects to 
be called with 1 parameter which is a list.  Use READ to enter the
parameter.  If no parameters are entered this tactic calls OTTER 
using binary resolution with factoring.  Since OTTER is a type 0 
tactic, commands to OTTER are not type checked.

This tactic requires that OTTER be set up on your machine.  The 
OTTER22 directory contains the source and instructions for doing this.")
           (&-left
            "Applies the rule

   p, q, A |- r
   ------------
   p & q, A |- r

        &-LEFT splits on the first available conjunct.")
           (&-right
            "Applies the rule
 
     <A> |- p
     <A> |- q
     --------
     <A> |- (p & q)")
           (=>-left
            "Applies the rule

     (p => q), A |- p
     ----------------
     (p => q), A |- q")
           (=>-right
            "Applies the rule

     p, A |- q 
     ---------
     A |- (p => q)")
           (all-left
            "Invokes the axiom

   ((all x) y), z, <A> |- p?
   thus
   ((all x) y), <A> |- p?

 where z results from substituting a chosen term for x throughout y. 
 ALL-LEFT expects an integer denoting the position of the quantified
formula.")
           (all-right
            "Invokes the axiom

   <A> |- z
   thus
   <A> |- ((all x) y)

where z results from substituting a skolem name for x throughout y.")
           (contradiction
            "Solves any sequent of the form p. ~p, A |- q where both
occurences of p unify.

        Note this tactic will unify the first two available 
complements in the assumptions, ignoring all other possibilities. This 
is one of two sources of incompleteness in the tactic TABLEAU which 
uses this tactic")
           (indirect-proof
            "Applies the axiom

    ~p, A |- false
    --------------
     A |- p ")
           (some-left
            "Invokes the axiom

   z, <A> |- p?
   thus
   ((some x) y), <A> |- p?

 where z results from substituting a skolem constant for x throughout y.  
SOME-LEFT expects an integer denoting the position of the quantified
formula.")
           (some-right
            "Invokes the axiom

<A> |- z
 thus
<A> |- ((some x) y)

 where z results from substituting any chosen term for x throughout y.")
           (v-left
            "Invokes the axiom 

p, A |- r 
q, A |- r
---------
(p V q), A |- r

         V-left will split the first disjunct in the assumptions.")
           (v-right-1 "Invokes the axiom

   A |- p
   -------
   A |- (p V q)")
           (v-right-2 "Invokes the axiom

   A |- q
   -------
   A |- (p V q)")
           (p<=>q==><p=>q>&<q=>p>
            "Used with the graphical interface rewrites the chosen formula
   in the way signified by the name of the rewrite rule.  For newcomers 
   to SEQUEL, click with the LEFT mouse button on this rule to apply it
   and then click with the LEFT mouse button on the numeric keypad to
   select the expression to be rewritten (0 denotes the conclusion of
   the current sequent) and then click the MIDDLE mouse button to execute
   the command.")
           (p=>q==>~pvq
            "Used with the graphical interface rewrites the chosen formula
   in the way signified by the name of the rewrite rule.  For newcomers 
   to SEQUEL, click with the LEFT mouse button on this rule to apply it
   and then click with the LEFT mouse button on the numeric keypad to
   select the expression to be rewritten (0 denotes the conclusion of
   the current sequent) and then click the MIDDLE mouse button to execute
   the command.")
           (~<p&q>==>~pv~q
            "Used with the graphical interface rewrites the chosen formula
   in the way signified by the name of the rewrite rule.  For newcomers 
   to SEQUEL, click with the LEFT mouse button on this rule to apply it
   and then click with the LEFT mouse button on the numeric keypad to
   select the expression to be rewritten (0 denotes the conclusion of
   the current sequent) and then click the MIDDLE mouse button to execute
   the command.")
           (~<p<=>q>==><<p&~q>v<~p&q>>
            "Used with the graphical interface rewrites the chosen formula
   in the way signified by the name of the rewrite rule.  For newcomers 
   to SEQUEL, click with the LEFT mouse button on this rule to apply it
   and then click with the LEFT mouse button on the numeric keypad to
   select the expression to be rewritten (0 denotes the conclusion of
   the current sequent) and then click the MIDDLE mouse button to execute
   the command.")
           (~<pvq>==>~p&~q
            "Used with the graphical interface rewrites the chosen formula
   in the way signified by the name of the rewrite rule.  For newcomers 
   to SEQUEL, click with the LEFT mouse button on this rule to apply it
   and then click with the LEFT mouse button on the numeric keypad to
   select the expression to be rewritten (0 denotes the conclusion of
   the current sequent) and then click the MIDDLE mouse button to execute
   the command.")
           (~all_x_fx==>some_x_~fx
            "Used with the graphical interface rewrites the chosen formula
   in the way signified by the name of the rewrite rule.  For newcomers 
   to SEQUEL, click with the LEFT mouse button on this rule to apply it
   and then click with the LEFT mouse button on the numeric keypad to
   select the expression to be rewritten (0 denotes the conclusion of
   the current sequent) and then click the MIDDLE mouse button to execute
   the command.")
           (~some_x_fx==>all_x_~fx
            "Used with the graphical interface rewrites the chosen formula
   in the way signified by the name of the rewrite rule.  For newcomers 
   to SEQUEL, click with the LEFT mouse button on this rule to apply it
   and then click with the LEFT mouse button on the numeric keypad to
   select the expression to be rewritten (0 denotes the conclusion of
   the current sequent) and then click the MIDDLE mouse button to execute
   the command.")
           (~~p==>p
            "Used with the graphical interface rewrites the chosen formula
   in the way signified by the name of the rewrite rule.  For newcomers 
   to SEQUEL, click with the LEFT mouse button on this rule to apply it
   and then click with the LEFT mouse button on the numeric keypad to
   select the expression to be rewritten (0 denotes the conclusion of
   the current sequent) and then click the MIDDLE mouse button to execute
   the command.")
           (seq
            "This is a simple system for proving theorems of FOL using 
   a sequentzen system without giving the user the ability to
   skolemise formulae (compare the TABLEAU frameowrk).  This
   framework is designed to be used wih OTTER.  To use OTTER and
   to find out more about it, click on 'Type Zero' and then 
   right mouse-button on 'OTTER.")))
       (restore-framework 'sqotter
                          '("SQOTTER" "Mark Tarver" "23-2-93"
                            ("~/SEQUEL/FRAMEWORKS/FOL/fol.syntax"
                             "~/SEQUEL/FRAMEWORKS/SQOTTER/sqotter.external-syntax"
                             "~/SEQUEL/FRAMEWORKS/SQOTTER/sqotter.doc")
                            ("~/SEQUEL/FRAMEWORKS/SQOTTER/sqotter.axioms")
                            ("~/SEQUEL/FRAMEWORKS/SQOTTER/sqotter.rew")
                            ("~/SEQUEL/FRAMEWORKS/SQOTTER/sequel-otter.tac")
                            nil ("~/SEQUEL/FRAMEWORKS/SQOTTER/sqotter.tac"))))
