(deftactic down
  {(list integer) proof -> proof}
   [] proof? -> proof?
   [1 | ns?] proof? -> (down ns? (down-first proof?))
   [n? | ns?] proof? -> (down [(1- n?) | ns?] (down-rest proof?)))

(deftactic edit
  {(list integer) (proof -> proof) proof -> proof}
   ns? tactic? proof? -> (up_n_times (total ns?) 
                                      (funcall tactic? (down ns? proof?))))

(define total
  {(list integer) -> integer}
  [] -> 0
  [n? | ns?] -> (+ n? (total ns?)))

(define up_n_times
  {integer proof -> proof}
   0 proof? -> proof?
   x proof? -> (up_n_times (1- x) (up proof?)))

(deftactic top
  {proof -> proof}
  proof? -> (fixpoint up proof?))

(deftactic unfold&simp
  {integer (list integer) proof -> proof}
   n? ns? proof? -> (rewrite simplify n? 
                         (edit ns? (/. (e) (rewrite expand n? e)) proof?)))
