; -*- mode:     CL -*- ----------------------------------------------------- ;
; File:         P-defsys.l
; Description:  Load the Portable defsys
; Author:       Joachim H. Laubsch
; Created:       7-Sep-89
; Modified:     Tue Aug 11 12:04:19 1992 (Joachim H. Laubsch)
; Language:     CL
; Package:      CL-USER
; RCS $Header: $
;
;;; *************************************************************************
;;; Copyright (c) 1989, Hewlett-Packard Company
;;; All rights reserved.
;;;
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted.  Any distribution of this
;;; software or derivative works must comply with all applicable United
;;; States export control laws.
;;; 
;;; This software is made available AS IS, and Hewlett-Packard Company
;;; makes no warranty about the software, its performance or its conformity
;;; to any specification.
;;; 
;;; Suggestions, comments and requests for improvements are welcome
;;; and should be mailed to laubsch@hplabs.com.
;;; *************************************************************************
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "CL-USER")

(provide "P-defsys")

;;"The directory in which sources and binaries for the portable defsystem facility are kept"

(defvar *defsystem-directory* 
  (pathname   #-CCL "~/lisp/DEFSYS/"
              #+(and CCL (not MCL))
              (expand-logical-namestring "home;defsys:")
              #+MCL "home;defsys:"
              ))
(or (member "expand-file-name" *modules* :test #'string=)
    (load (format nil "~Abinary~Aexpand-file-name"
		  *defsystem-directory*
		  #+(or MCL CCL) ":"
		  #-(or MCL CCL) "/")))

(setq *defsystem-directory* (expand-file-name *defsystem-directory*))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                          create DEFSYSTEM package
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#-(or COMMON-LISP LCL4.0)
(eval-when (compile eval load)
  (unless (member "defpackage" *modules* :test #'string=)
    (load (merge-pathnames (make-pathname :name "defpackage" :type "l")
			   *defsystem-directory*))))

(eval-when  (compile eval load)
  (DEFPACKAGE "DEFSYSTEM"
      (:NICKNAMES "DS")
    (:IMPORT-FROM "USER" EXPAND-FILE-NAME)
    #+LUCID (:IMPORT-FROM "LCL"  LCL:*LOAD-PATHNAME*)
    (:EXPORT
     "DEFSYSTEM" "UNDEFSYSTEM"
     "LOAD-SYSTEM" "COMPILE-SYSTEM" "SHOW-SYSTEM" "FIND-SYSTEM" "SYSTEM-LOADED-P"
     "LOAD-MODULE" "COMPILE-MODULE" "SHOW-MODULE" "FIND-MODULE" "MODULE-LOADED-P"

     "SYSTEM-COMPILED-P" "SYSTEM-LOADED-P"
     "MODULE-COMPILED-P" "MODULE-LOADED-P"
     "SYSTEM-DOCUMENTATION" "DOMODULES"

     "SYSTEM-NEEDED-SYSTEMS*"
     "*SUFFIXES*"
     "*ALL-SYSTEMS*" "*LOADED-SYSTEMS*" "*DEFSYSTEM-VERSION*"
     "*SYSTEM-DIRECTORIES*" "*RELATIVE-BINARY-NAMESTRING*"
     "EXPAND-FILE-NAME")
    (:USE    #+(and COMMON-LISP MCL) "COMMON-LISP"
	     #+(and COMMON-LISP LUCID) "LCL"
	     #+(and COMMON-LISP LUCID) "LISP"
             #-COMMON-LISP "LISP"
             #+MCL "CCL"))

  (use-package (find-package "DEFSYSTEM")))

(eval-when (compile eval load)
  (defvar DS:*suffixes*
    #+ALLEGRO                             '("lisp"  . "fasl")
    #+(or MCL CCL) 			  '("Lisp"  . "fasl")
    #+(and (not ALLEGRO) (or HP HP300) (not LCL4.0))    '("l" . "b")
    #+(and (not ALLEGRO) (or HP HP300) LCL4.0)          '("l" . "6bin")
    #+(and (not ALLEGRO) EXCL)             '("cl"    . "fasl")
    #+(and Lucid MC68000
	   (not (or HP HP300)))            '("lisp"  . "lbin")
    #+(and Lucid VAX VMS)                  '("lisp"  . "vbin")
    #+CMU                                  '("slisp" . "sfasl")
    #+PRIME                                '("lisp"  . "pbin")
    #+Symbolics                            '("lisp"  . "bin")
    #+(and dec common vax (not ultrix))    '("LSP"   . "FAS")
    #+(and dec common vax ultrix)          '("lsp"   . "fas")
    #+KCL                                  '("lsp"   . "o")
    #+Xerox                                '("lisp"  . "dfasl")
    #+TI                                   '("lisp"  . "xfasl"))
  )
(defvar *defsystem-version* "$Revision: 5.0$")

(eval-when (eval load)
  (let ((binary (merge-pathnames
		 (make-pathname :name "defsys" :type (cdr DS:*suffixes*))
		 (format nil
			 "~Abinary~A"
			 *defsystem-directory*
			 #+(or MCL CCL) ":"
			 #-(or MCL CCL) "/"))))
    (if (probe-file binary)
	(progn
	  (load binary)
	  (format t "~%Loaded Portable Defsystem: ~A~%" *defsystem-version*))
      (warn "Failed to load DEFSYSTEM: binary not found at ~S:" binary))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                              end of P-defsys.l
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
