;fensteremu
;;Erkannte Parameter
;window-show
;view-font

(defclass *at-fenster* (view mac-fenster-mixin dialog) ;als mixin
       (
        (view-font :initarg :view-font :initform  (MAKE-FONT :SWISS :SYSTEM 16 '(:BOLD)))
        (view-position :initarg :view-position :initform nil)
        (view-size :initarg :view-size :initform nil)
        )
     )

;Hier sollten alle Parameter von Mac-> At uebersetz werden

(defmethod initialize-instance((ich *at-fenster*) &rest init-list)
     (apply #'call-next-method ich
          (init-list-default init-list
              :title (getf init-list :window-title "Kein Titel")
              )))

;wahrscheinlich kann  :font nicht geaendert werden

(defmethod initialize-instance :after  ((ich *at-fenster*) &rest init-list)
     (if (wptr ich)
        (set-view-font ich
             (slot-value ich 'view-font))
        (b=anzeige "Fehler in  initialize-instance :after  ((ich *at-fenster*)
Fenster schon zu"))
   )

(defvar *dummy-window*
     nil)

(defun fenster? ()
     (unless (windowp *dummy-window*)
          (setq *dummy-window*
               (m->a=erzeuge-fenster '*at-fenster*
                    :window-show nil)))
     )

(defun string-width (string font)
     (fenster?)
     (set-view-font *dummy-window* font)
     (point-h
          (stream-string-size *dummy-window* string)))

(defun b=schrifthoehe (font)
     (fenster?)
     (set-view-font *dummy-window* font)
     (let  ((fm (fontmetrics  *dummy-window*)))
         (+ (font-ascent fm)
             (font-descent fm)
             (font-leading fm)))
     )

(defmethod set-window-title ((ich mac-fenster-mixin) titel)
      (setf (stream-title ich) titel)
      )

(defmethod window-title ((ich window))
     (stream-title ich))

(defmethod window-hide ((ich mac-fenster-mixin))
     (shrink-window ich t))

(defmethod window-select ((ich mac-fenster-mixin))
      (select-window ich)
      )

(defmethod window-show ((ich mac-fenster-mixin))
      (select-window ich)
   )

(defmethod window-shown-p ((ich mac-fenster-mixin))
   (and (wptr ich)
        (or (eq (window-state ich) :normal)
            (eq (window-state ich) :maximized))))

(defmethod window-close ((ich mac-fenster-mixin))
     (close ich))


(defmethod view-container ((ich mac-fenster-mixin))
     (window-parent ich)
     )

(defun view-window (ich)
     (let ((was (view-container ich)))
      (if was
         (if (eql was
                *unser-haupt-fenster*)
            ich
         (view-window was))
         (if (windowp ich)
            ich
            nil))))

(defmethod set-view-container ((ich mac-fenster-mixin) neuer-view)
     (set-window-parent ich neuer-view)
     )

(defmethod event ((ich mac-fenster-mixin) event buttons data time)
     
      (select event
           (mouse-left-double-click
                ; (print "zwei")
                 (setf (view-doppel-klick-p ich) t)
            )
           (mouse-left-down
               ;  (print "eins")
                 (setf (view-doppel-klick-p ich) nil)
                 (setf (view-key ich) (- buttons left-mouse-button))
                 (view-click-event-handler ich data))
           (t (call-next-method))))

(defun at-aktuelles-fenster ()
     (selected-window *unser-haupt-fenster*)
     )

(defun at-click&key-dispatcher (funktion)
     (let ((fenster (at-aktuelles-fenster)))
         (when fenster
              (funcall funktion fenster)))
     )

(defmethod view-double-click-p (ich)
     nil
     )

(defmethod view-double-click-p ((ich mac-fenster-mixin))
     (view-doppel-klick-p ich)
     )

(defun double-click-p ()
     (at-click&key-dispatcher 'VIEW-DOUBLE-CLICK-P))

(defmethod view-command-key-p ((ich mac-fenster-mixin))
     (button-match (view-key ich) meta-key))

(defmethod view-command-key-p (ich)
     nil)

(defun command-key-p ()
     (at-click&key-dispatcher 'view-command-key-p))

(defmethod view-option-key-p ((ich mac-fenster-mixin))
     (button-match (view-key ich) alt-key))

(defmethod view-option-key-p (ich)
     nil)

(defun option-key-p ()
     (at-click&key-dispatcher 'view-option-key-p))

(defmethod view-control-key-p ((ich mac-fenster-mixin))
     (button-match (view-key ich) control-key))

(defmethod view-control-key-p (ich)
     nil)

(defun control-key-p ()
     (at-click&key-dispatcher 'view-control-key-p))

(defmethod view-shift-key-p ((ich mac-fenster-mixin))
     (button-match (view-key ich) shift-key))

(defmethod view-shift-key-p (ich)
     nil)

(defun shift-key-p ()
     (at-click&key-dispatcher 'view-shift-key-p))

(defclass nachmal&click-mixin ()
      ())

(defmethod nachmeln&clicken-p ((ich nachmal&click-mixin))
     t)

(defmethod nachmeln&clicken-p (ich)
     nil)

(defmethod view-draw-contents ((ich nachmal&click-mixin))
     )

(defmethod view-click-event-handler ((ich nachmal&click-mixin) wo)
     wo)

(defmethod set-view-container :after ((ich nachmal&click-mixin) view)
     (when view
          (view-draw-contents ich)))

(defmethod redisplay-window ((ich mac-fenster-mixin) &optional  pos)
     (call-next-method)
     (view-draw-contents ich)
     )

(defmethod view-click-event-handler ((ich mac-fenster-mixin) point)
     (let ((punkt point
              ))
         (dolist (widget (dialog-items ich))
              (when (nachmeln&clicken-p widget)
                   (when (view-contains-point-p widget point)
                        (view-click-event-handler widget point)))))
     )

(defmethod view-contains-point-p (widget punkt)
     (b=punkt-im-rechteck-p punkt
                                  (view-position widget)
                                  (add-points
                                       (view-position widget)
                                       (view-size widget)))
     )

(defmethod view-draw-contents ((ich mac-fenster-mixin))
     (dolist (widget (dialog-items ich))
          (when (nachmeln&clicken-p widget)
               (view-draw-contents widget)))
     )

(defmethod set-view-font ((ich mac-fenster-mixin) font)
     (set-font ich font))

(defmethod view-font ((ich mac-fenster-mixin))
     (font ich))

(defmethod set-view-position ((ich  mac-fenster-mixin) h &optional v)
     (if (eq h :centered)
        (move-window ich (make-point (- (floor *screen-width* 2)
                                                            (floor (point-h (view-size ich)) 2))
                                           (- (floor *screen-height* 2)
                                                            (floor (point-v (view-size ich)) 2))))
        (move-window ich (b=gib-mir-nen-punkt h v)))
     )

(defmethod view-size ((ich mac-fenster-mixin))
     (make-point (window-exterior-width ich)
           (window-exterior-height ich)
     ))


(defmethod innere-view-size ((ich mac-fenster-mixin))
     (make-point (window-interior-width ich)
           (window-interior-height ich)
           )
     )

 
(defun b=gib-mir-nen-punkt (h v)
  (if v
    (make-point h v)
    h)
  )

(defmethod set-view-size ((ich mac-fenster-mixin) h &optional v)
     (let ((punkt (b=gib-mir-nen-punkt h v))
            )
         (resize-window ich punkt)))

(defmethod view-position ((ich mac-fenster-mixin))
      (window-exterior-top-left ich))

(defmethod subviews ((ich mac-fenster-mixin ))
     (dialog-items  ich))

(defun  set-default-button (ok-but b_auswahl-fenster)
     (declare (ignore ok-but b_auswahl-fenster))
     ())

(defmethod subviews (ich)
     (values nil :systemfenster))

(defclass *b-window* (*at-fenster*)
      ((bei-Klick-schliessen-p :initarg :bei-Klick-schliessen-p :initform nil
        :accessor bei-Klick-schliessen-p)
       )
     (:default-initargs
      :user-resizable t)
     )

(defmethod initialize-instance :after ((ich *b-window*) &rest init-list)
    (when (slot-value ich 'view-size)
          (set-view-size ich (slot-value ich 'view-size)))
     (when (slot-value ich 'view-position)
          (set-view-position ich (slot-value ich 'view-position)))
   )

(defmethod minimale-fenstergroesse-setzen
       ((ich *b-window*) h &optional  v)
     h v)

(defmethod view-click-event-handler ((ich *b-window*) punkt)
     (if (bei-Klick-schliessen-p ich)
        (window-close ich)
        (call-next-method))
     )


(defclass *b-bei-klick-schliessen-dialog* (*b-window*)
      ()
     (:default-initargs
      :bei-Klick-schliessen-p t
      )
     )

(defun modal-dialog (fenster &optional egal)
     (declare (ignore egal))
     (let ((ergebnis nil))
         (setq ergebnis
              (catch 'PC::DEFAULT-CANCEL
                  (catch 'pc::modal-dialog
                      (pop-up-dialog fenster)
                      )
                  )
              )))

;; der catch ist in der top-loop eingesetzt
(defvar *b-catch-cancel-is-installed* nil)

(defun throw-top-level ()
     (if *b-catch-cancel-is-installed*
        (throw :cancel :cancel)
        (throw 'PC::DEFAULT-CANCEL nil))
       )

(defun return-from-modal-dialog (wert)
     (cond ((eq wert :cancel)
               (throw-top-level)
               )
              (t
                 (throw 'pc::modal-dialog wert))
              ))


#|
(setq der
     (m->a=erzeuge-modal-fenster
          '*b-button-window*
          :buttons (list
                           
                      (m->a=erzeuge-dialog-item '*b-abbrechen-button*
                                 :dialog-item-action
                                 #'(lambda(view)
                                       (return-from-modal-dialog  :cancel)))
                      (m->a=erzeuge-dialog-item '*b-ok-button*
                                 :dialog-item-action
                                 #'(lambda(view)
                                       (return-from-modal-dialog  99)))
                      )
          ))

(modal-dialog der)
|#

(defclass *b-fenster+scroller* (*b-window*)
      ((scroller :accessor bfs-scroller))
     
     )


(defmethod initialize-instance ((ich *b-fenster+scroller*) &rest init-list
                                                 &key scroller-typ scroller-parameter)
     (apply #'call-next-method ich
          :window-show nil
          init-list)
       (setf (bfs-scroller ich)
             (apply #'m->a=erzeuge-dialog-item scroller-typ
                  :view-position (make-point 0 0)
                  :view-size (make-point 100 100)
                   :user-scrollable t
                  scroller-parameter))
    
     )

(defmethod initialize-instance :after  ((ich *b-fenster+scroller*) &rest init-list)
     (add-subviews ich (bfs-scroller ich))
      (passe-scroller-an ich)
     (window-select ich)
     )

(defmethod passe-scroller-an ((ich *b-fenster+scroller*))
     (set-view-size (bfs-scroller ich) (innere-view-size ich))
     )
     

(defmethod resize-window :after  ((ich *b-fenster+scroller*) position)
     (declare (ignore position))
     (passe-scroller-an ich)
     )

#|
(m->a=erzeuge-fenster '*b-fenster+scroller*
   ; :view-size (make-point 200 200)
   ;:view-position (make-point 50 50)
   :scroller-parameter (list :table-sequence '(1 2 3 4 5 6 7 8 9)
                          :text-des-tabellenelements #'(lambda(was)
                                                          (format nil "~R" was))
                          :f-pop-up-menu #'(lambda(neu)
                                              (m->a=erzeuge-menu
                                                 '*b-menu*
                                                 :menu-title "Test"
                                                 :menu-items
                                                 (list
                                                    (M->A=ERZEUGE-MENU-ITEM
                                                       '*b-menu-item*
                                                       :menu-item-title "Der"
                                                       :menu-item-action #'(lambda()
                                                                              (b=nachricht (format nil "~s" neu))))))))
   
   :scroller-typ '*bb-sequence-dialog-item*)

|#