
;;;
;;; angepasst, so dass es auf mac und at laufen muesste
;;; stefan &karsten, 17.4.94 8 minuten vor mitternacht
;;;



#|        
********************************************************************************
********************************************************************************
*****                                                                      *****
*****      Funktionen b=Anzeige, b=schliesse-Anzeige                       *****
*****                                                                      *****
*****    Autor: Ute Gappa                    Erstellt: 11.4.90             *****
*****                                        Letzte nderung:  4.8.92      *****
*****                                                                      *****
********************************************************************************
********************************************************************************
|# 

(defvar b_Anzeige-Fenster)

(defun b=Anzeige (Nachricht &key 
                              (Fensterposition (make-point (floor *screen-width* 2) 100))
                              (Fensterbreite nil)
                              (Schrift b_normalschrift))
     "gibt den Text Nachricht auf einem Fenster aus"
     
     #|Autor: Ute, 30.05.90

Eingabeparameter:
- Nachricht:       Nachricht fuer den Benutzer als String
- Fensterposition: Position des Fensters 
(default = b_Dialogfenster-Position-oben)
- Fensterbreite:   die Breite des Fensters in Pixel.
(Die Fensterhoehe wird immer automatisch berechnet)
- Schrift:         (default = b_Chicagoschrift)
|#

(setq Nachricht (b=erzeuge-string Nachricht))
(if (and (boundp 'b_Anzeige-Fenster)
            (wptr b_Anzeige-Fenster))
   (apply #'remove-subviews b_Anzeige-Fenster (dialog-items b_Anzeige-Fenster))
   (setq b_Anzeige-Fenster (m->A=erzeuge-fenster `*b-window*   ;vorher: '*b-bei-klick-schliessen-dialog*
                                                :bei-Klick-schliessen-p t
                                                #+:ccl-2 :window-type #+:ccl-2 :double-edge-box
                                                #+:aclpc  :window-border #+:aclpc :dialog-box
                                                #+:aclpc  :title #+:aclpc  " "
                                                :view-position Fensterposition
                                                :view-font Schrift
                                                :window-show nil)))

(multiple-value-bind 
        (Textitem Textitemhoehe)
       (b=static-text Nachricht 
            (- (if Fensterbreite Fensterbreite 600) 20)  ;20 fr Abstnde zum Rand
            10 
            10
            :font Schrift)
      (add-subviews b_Anzeige-Fenster Textitem)
      (let* (
              (Textitembreite (point-h (view-size Textitem)))
              (angepasste-Fensterbreite (cond (Fensterbreite Fensterbreite)
                                                                   (t (+ Textitembreite 10))))
              ;(einzeiligp (and (<= Textitembreite 600) (not (find #\Return Nachricht :test `string=))))
              (Fensterhoehe (+ 20 Textitemhoehe)))
          
          (set-view-size b_Anzeige-fenster (make-point angepasste-Fensterbreite
                                                                     Fensterhoehe))
          (set-view-position b_Anzeige-fenster Fensterposition)
          
          (when t ;(and einzeiligp (not Fensterbreite))        ;-> Static-Text wird in die Mitte des Fensters gesetzt
               (set-view-position Textitem (make-point (round (/ (- angepasste-Fensterbreite 
                                                                                                Textitembreite)
                                                                                             2))
                                                                 10)))))
#+:aclpc
(set-view-position b_Anzeige-Fenster :centered)
(window-select b_Anzeige-Fenster)
#+:ccl-2
(window-update-event-handler b_Anzeige-Fenster)
#+:aclpc (update-window b_Anzeige-Fenster)
)


(defun b=schliesse-Anzeige ()
  "schliesst das Anzeigefenster"
  (when (and (boundp 'b_Anzeige-Fenster)
             b_Anzeige-Fenster
             (wptr b_Anzeige-Fenster)  ;falls das Fenster unterdessen vom Benutzer geschlossen wurde
             )
    (window-hide b_Anzeige-Fenster)))

(defun b=Anzeige-schliessen ()
  (b=schliesse-Anzeige))

#| 
********************************************************************************
********************************************************************************
Beispiele:

(b=Anzeige "Die Wissensbasis \"Auto\" wird geladen.")

(b=Anzeige "Doch nicht!")

(b=Anzeige "Das ist ein langer Text. Fuer die Fensterbreite habe ich ein Maximum von 600 gesetzt. Die ist jetzt erreicht.")

(b=Anzeige "Das ist ein langer Text. Fuer die Fensterbreite habe ich ein Maximum von 300 gesetzt.
Die ist jetzt erreicht."
:Schrift b_Normalschrift
:Fensterbreite 300)          ;-> funktioniert zur Zeit nicht

(b=Anzeige-schliessen)

(makunbound `b_Anzeige-Fenster)

********************************************************************************
********************************************************************************
|#




       

