(defvar b_Fenster-versetzen-Offset)

(unless (boundp 'b_Fenster-versetzen-Offset)
     (setq b_Fenster-versetzen-Offset (make-point 15 15)))

(defun b=Position-fuer-neues-Fenster (&key default-window-position
                                         (window-position-difference b_Fenster-versetzen-Offset)
                                         (window-position-max-difference 150)
                                         (window-type 'window)
                                         (fenster-test-funktion #'(lambda(fenster)
                                                                    (typep fenster window-type)))
                                         (default-Position-wenn-kein-grosser-Bildschirm-p t)  
                                         (versetzen-wenn-kein-grosser-Bildschirm-p nil))
  "gibt die erste freie Fensterposition zurueck,
   die zu bisherigen Fenstern des gleichen Fenstertyps
   um window-position-difference versetzt ist"
  #|
  falls alle moeglichen Positionen der angegebenen Spanne besetzt sind, erscheint das window
  an der ersten Position, die noch am wenigsten oft besetzt ist.

  window-type                         = die Objektklasse des Fensters
  fenster-test-funktion               = Funktion, die entscheidet, ob der Fenstertyp gleich ist
                                        ist nur noetig, falls der window.type nicht ausreichend ist
  default-window-position             = Position des ersten Windows
                                        wenn nicht angegeben -> Position oben rechts
  window-position-difference          = Verschiebung bzgl. dem letzten gleichartigen Fenster
  window-position-max-difference      = max. Verschiebung von oben (faengt wieder bei default-window-position an)
  default-Position-wenn-kein-grosser-Bildschirm-p 
                                      = wenn kein grosser Bildschirm vorhanden ist, wird die uebergebene
                                        default-window-position als Fensterposition genommen
                                        Wenn nil -> Das Fenster kommt oben links in die Ecke
  versetzen-wenn-kein-grosser-Bildschirm-p
                                      = wenn kein grosser Bildschirm da ist, wird trotzdem versetzt
  Autor: Ute, Datum: Maerz 90
  |#
  (unless default-window-position (setq default-window-position (b=Standard-Fensterposition)))
  (when (not (b=grosser-Bildschirm-p))
    (when (not default-Position-wenn-kein-grosser-Bildschirm-p) ;d.h. Fenster kommt oben links hin
      (setq default-window-position (b=Standard-Fensterposition))))
     
  (if (and (not (b=grosser-Bildschirm-p))
           (not versetzen-wenn-kein-grosser-Bildschirm-p))
    default-window-position
    (let* ((bestehende-Fensterpositionen (remove nil (mapcar #'(lambda (window)
                                                                 (if (funcall fenster-test-funktion window)
                                                                   (view-position window)))
                                                             (b=windows)))))
      (do ((Probierposition default-window-position (add-points Probierposition window-position-difference))
           (Fensteranzahl-auf-Position 0)  ;brauche ich nur lokal, nicht merken
           (bisher-geringste-Fensteranzahl-und-Position `(100000 (make-point 0 0))))  ;Liste aus Fensteranzahl und Position
          ((> (- (point-v Probierposition) (point-v default-window-position))
              window-position-max-difference) 
           (second bisher-geringste-Fensteranzahl-und-Position))
        (setq Fensteranzahl-auf-Position (count Probierposition bestehende-Fensterpositionen))
        (if (eql Fensteranzahl-auf-Position 0)
          (return Probierposition)
          (when (< Fensteranzahl-auf-Position (first bisher-geringste-Fensteranzahl-und-Position))
            (setq bisher-geringste-Fensteranzahl-und-Position
                  (list Fensteranzahl-auf-Position Probierposition))))))
    ))

#|
Beispiel:
(dotimes (x 12)
  (make-instance 'dialog :view-position (b=Position-fuer-neues-Fenster)))
(make-instance 'dialog :view-position (b=Position-fuer-neues-Fenster))
|#