;************************************************************************************
; Bibliotheksfunktionen unportabel
;************************************************************************************


#+:aclpc
(unless (fboundp 'mac-namestring)
  (defun mac-namestring (was)
    (namestring was)))

;********************
; Dateien
;***********
;; die aclpc version steht in einer anderen datei
#+:ccl-2
(defun files-in-directory (was)
  (directory (b=konkateniere-nach-string was "*")
             :files t
             :resolve-aliases t
             :directories nil))

#+:ccl-2
(defun directories-in-directory (was)
  (directory (b=konkateniere-nach-string was "*")
             :files nil
             :resolve-aliases t
             :directories t))

#+:ccl-2
(defun devices ()
  (directory "*:"))

(defun expand-logical-pathname (was)
  (full-pathname was))

(defun Expand-Logical-Namestring (was)
    (full-pathname was))

#+:ccl-2
(defun def-logical-pathname (a b)
  (def-logical-directory a b))

(defun b-alle-devices-mit-ordnername (ordnername)
  (remove-if-not
   #'(lambda(was)
      (#+:ccl-2 probe-file
       #+:aclpc b=probe-directory
        (b=konkateniere-nach-string
         (mac-namestring was) ordnername)))
      (devices))) 

#+:ccl-2
(defun b=string-in-datei-vorhanden-p (string datei)
  "berprft, ob der string in der datei vorkommt"
  (multiple-value-bind (erg fehler)
                       (b=lispfehler-abfangen
                         (if (eql (mac-file-type datei) :text)
                           (let ((fenster
                                  (make-instance 'fred-window
                                                 :filename datei
                                                 :window-show nil)))
                             (prog1 (buffer-string-pos (fred-buffer fenster) string)
                               (window-close fenster)))
                           nil))
    (if fehler nil erg)))

#+:ccl-2
(defun b=file-type-p (pfadname type)
  "Prueft, ob pfadname zu einer Datei gehoert und falls ja, ob die Datei
vom uebergebenen Typ type ist"
  #|Autor: Heinz, 22.04.1992|#
  (if (or (stringp pfadname) (pathnamep pfadname))
    (let ((file (probe-file pfadname)))
      (if file 
        (eq (mac-file-type file) type)
        nil))
    nil))

;; auf dem AT gibt es keine dateitypen (:text ,etc.), von daher funktioniert
;; die funktion nicht. ich gehe davon aus, dass es im normalfall stimmt ;-)
;; bambi, 17.04.94
#+:aclpc
(defun b=file-type-p (pfadname type)
  "Macht auf dem at eigentlich keinen sinn, aber ich implementiere
es so, dass alle nicht .fsl dateien :text haben"
     ;; bambi, 18.4.94
     (setq pfadname (full-pathname pfadname)) 
     (when (or (stringp pfadname) (pathnamep pfadname))
          (let ((file (probe-file pfadname))
                 typ
                 )
              (setq typ
                   (if file 
                      (cond ((equalp (pathname-type file) (namestring *.FASL-PATHNAME*))
                                :FASL)
                               (t :TEXT)
                               )))
              (if (eql typ :fasl)
                 (eql typ type)
                 T)
              )))

#+:ccl-2
(defun b=mcltext-datei-p (datei)
  "Liefert t, falls die Datei eine Quelltextdatei von Lisp ist"
  (and (eql (mac-file-type datei) :text)
       (or (eql (mac-file-creator datei) :ccl\ )
           (eql (mac-file-creator datei) :ccl2))))

#+:aclpc
(defun b=mcltext-datei-p (datei)
  "Liefert t, falls die Datei eine Quelltextdatei von Lisp ist"
  T)

(defun b=mit-allen-dateien (verzeichnis aktion &key filter)
  "Fhrt bei allen Dateienauch rekursiv unter verzeichnis aaktion durch,
   falls diese dem Filter gengen"
  (dolist (datei (files-in-directory verzeichnis))
    (if (or (not filter)
            (funcall filter datei))
      (funcall aktion datei)))
  (dolist (v1 (directories-in-directory verzeichnis))
    (b=mit-allen-dateien v1 aktion :filter filter)))


#|
(b=mit-allen-dateien (b=Ordnerauswahl)
                     #'unlock-file)

(B=MIT-ALLEN-DATEIEN "bibliothek;" #'print
      :filter #'(lambda (x) (string-equal (pathname-type x) "lsp")))
|#

;;; einen mac-namestring, also einen Pfadnamen ohne die erforderlichen
;;; Quote-Zeichen () vor Punkten und Sternchen, in eine pathname-Struktur
;;; bersetzen.  Falls eine Datei ohne Punkt angegeben ist, wird wie
;;; von choose-file-dialog :unspecific als Typ eingetragen
;;; Falls das hier mal nicht mehr funktionieren sollte, kann es zur Not
#+:ccl-2
(defun b=parse-mac-namestring (string)
  "aus einem mac-namestring einen pathname zusammensetzen"
  ;;; durch parse-namestring ersetzt werden (dann funktionieren Pfadnamen mit
  ;;; Sonderzeichen nicht mehr)
  ;;; Oktober 1993, Gnter
  (let ((path (parse-namestring (ccl::%path-std-quotes string nil ";*"))))
    (if (stringp (pathname-name path))
      (merge-pathnames path (make-pathname :type :unspecific))
      path)))



(defun b=system7-p ()
  (let* ((text (software-version))
         (Position-Macintosh (search "Macintosh" text :test #'string=))
         (Position-Bindestrich
              (when Position-Macintosh
                    (search "-" text :test #'string= :start2 Position-Macintosh)))
         (Versionsnummer
              (when Position-Bindestrich
                    (subseq text (1+ Position-Bindestrich) (+ Position-Bindestrich 2))))
          )
      (when Versionsnummer
           (string= Versionsnummer "7")))
     )

(defun b=windows3-p ()
     (string-equal (software-version) "Windows 3")
     )

(defun b=software-plattform ()
     (cond ((b=system7-p)
               :mac-sys-7)
              ((b=windows3-p)
               :windows-3)
              (t :kenn-i-nett)
              ))


(defun b=lade-Datei (Dateiname &key sicher fragen-ob-weitermachen-p
                                      (weitermachentext "Weitermachen"))
     "Laden der durch Pfadname angegebenen Datei"
     ;sicher geht bei fasl-Dateien nicht
     ;Autor: Annette
     ;       von Ute geaendert am 23.02.90, da Fehler beim Laden von FASL-Dateien
     ;       von Ute geaendert am 20.09.90 (unwind-protect)
     ; 18/4/94 bambi portabel gemacht. luegner !!!!
     (let (;(file-type (mac-file-type Dateiname))
            )
         (cond ((or (b=file-type-p Dateiname :TEXT) (b=file-type-p Dateiname :FASL))
                   (if (and sicher (b=file-type-p Dateiname :TEXT))
                      (b=lade-Datei-sicher Dateiname
                       :fragen-ob-weitermachen-p fragen-ob-weitermachen-p
                       :weitermachentext weitermachentext)
                      (load Dateiname)))
                  #+:ccl-2
                  ;; der else-zweig tritt auf dem AT nicht auf ;-) ,bambi 18.4.94
                  (t
                     (set-mac-file-type Dateiname :TEXT)
                     (unwind-protect
                             (if sicher
                                (b=lade-Datei-sicher Dateiname
                                 :fragen-ob-weitermachen-p fragen-ob-weitermachen-p
                                 :weitermachentext weitermachentext)
                                (load Dateiname))
                          (set-mac-file-type Dateiname file-type)))
                  )))

#|Beispiel (von Ute)
(defun Beispielfunktion ()
  (format t "(setq Beispiel t) ("))
(b=speichere-Funktionsausgabe-auf-Datei "Platte;test"
                                        'Beispielfunktion
                                        nil
                                        :mac-file-type :Test)
(mac-file-type "Platte;test")
-> :Test
(b=lade-Datei "Platte;test")
> Error: Unexpected end of file encountered.
> While executing: Read
> Type Command-/ to continue, Command-. to abort.
1 > 
(mac-file-type "Platte;test")
-> :Text
Abort + (mac-file-type "Platte;test")
-> :Test
|#

(defun b=sicherer-Ordner (Dateiname &key logischer-Pfadname-der-Platte)
     "liefert auf jeden Fall einen Ordner zurueck, der auch existiert. Will man seinen logischen Pfadnamen
fuer die Platte aktualisieren lassen, kann man den Namen mitgeben"
     ;Ute, 19.06.90
     ;oder sollte ich, wenn nicht exisiert, Leerstring zurueckgeben?
     ;man koennte die Funktion auf den key-Parameter :anlegen nil/t
     ;ausdehnen, um gegebenenfalls den Pfad zu erzeugen
     #+:aclpc
     (setq dateiname (full-pathname dateiname))
     (let ((mac-default-directory-als-String
             #+:ccl-2 (mac-namestring (mac-default-directory))
             #+:aclpc (namestring (at-default-directory )))
            )
         (when (and logischer-Pfadname-der-Platte
                           (not (b=logischer-pfadname-korrekt-p logischer-Pfadname-der-Platte)))
              (b=logischer-Pfadname-Platte-aktualisieren logischer-Pfadname-der-Platte))
         (cond ((and dateiname
                           (b=probe-directory (#+:ccl-2 mac-directory-namestring
                                                          #+:aclpc namestring Dateiname))
                           )
                   Dateiname)
                  (t #+:aclpc mac-default-directory-als-String
                     #+:ccl-2 (subseq mac-default-directory-als-String 0
                                       (1+ (position ":" mac-default-directory-als-String :test #'string=)))))))

#|Beispiele:
(b=sicherer-Ordner "Platte;Biblioth:")
-> "Platte;Bibliothek:"
(b=sicherer-Ordner "Platte;UteUte:")
-> "Platte:"
(full-pathname "Plattenname;")
-> > Error: Undefined logical pathname in "Plattenname;"
   > While executing: full-pathname
(b=sicherer-Ordner "Platte;UteUte:" :logischer-Pfadname-der-Platte "Plattenname")
-> "Platte:"
(full-pathname "Plattenname;")
-> #.(Pathname "Platte:")
|#

(defun b=logical-pathname-p (name-ohne-semikolon)
     #+:ccl-2
     (member name-ohne-semikolon
           *logical-directory-alist*
           :test #'string-equal
           :key #'first)
     #+:aclpc
     (and (full-pathname (b=konkateniere-nach-string name-ohne-semikolon ";")) T)     
     )

(defun b=logischer-pfadname-korrekt-p (name)
  "Ist er definiert und zeigt er auf etwas richtiges"
  (and 
   (b=logical-pathname-p name)
   (#+:ccl-2 probe-file
    #+:aclpc b=probe-directory
     (b=konkateniere-nach-string name ";"))))

(defun b=logischer-Pfadname-Platte-aktualisieren (logischer-Pfadname-der-Platte)
  "aktualisiert den logischen Pfadname der Platte, falls man den Plattenname zwischendurch umbenannt hat"
  ;Ute; 16.06.90
  (let ((mac-default-directory-als-String
          #+:ccl-2 (mac-directory-namestring (mac-default-directory))
          #+:aclpc (namestring (at-default-directory)) )
         )
    (def-logical-pathname logischer-Pfadname-der-Platte
         #+:aclpc mac-default-directory-als-String
         #+:ccl-2         
         (subseq mac-default-directory-als-String 0 (position #+:ccl-2  ":"
                                                                                  mac-default-directory-als-String :test #'string=))
         )))
           
#|Beispiel:
(b=logischer-Pfadname-Platte-aktualisieren "Platte")
(full-pathname "Platte;")
;Plattenname aendern und die beiden Befehle nochmal aufrufen
|#

#+:ccl-2
;; auf dem at nicht ganz trivial, glaube ich , bambi 19.4.94
(defun b=Umlaute-in-Datei-ersetzen (datei &key (fenster-zeigen-p))
  "Ersetzt die deutschen Umlaute in datei"
  (let* ((fred-fenster (make-instance 'fred-window 
                              :filename datei
                              :window-show fenster-zeigen-p
                              :view-position (b=Position-fuer-neues-Fenster :window-type 'fred-window )))
         (der_buffer (fred-buffer fred-fenster))
         )
    (dolist (Umlautpaar `(("" "ae") ("" "ue") ("" "oe") ("" "Ae") ("" "Ue") ("" "Oe") ("" "ss")))
      (do* ((Umlaut (first Umlautpaar))
            (neuer-String (second Umlautpaar))
            (position (buffer-string-pos  der_buffer Umlaut :start 0 :end (buffer-size der_buffer)) 
                      (buffer-string-pos der_buffer Umlaut :start 0 :end (buffer-size der_buffer))))
           ((null position) nil)
        (b=Zeichen-im-buffer-ersetzen der_buffer Position neuer-String)
        (when fenster-zeigen-p
          (fred-update fred-fenster))
        )
      )
    (window-save fred-fenster)
    (window-close fred-fenster)))

#+:ccl-2
(defun b=Zeichen-im-buffer-ersetzen (buffer position neuer-String)
  (buffer-delete buffer position (+ position 1))
  (buffer-insert buffer neuer-String position))

   
#|Beispiel:             
(b=Umlaute-in-Datei-ersetzen (choose-file-dialog))
(b=Umlaute-in-Dateien-ersetzen  "Platte:Bibliothek organisation:" :fenster-zeigen-p t)
|#  

