(defvar *portable-apropos-dialog* nil)

(defclass portable-apropos-dialog (*b-window*)
  (
   (text-item :Accessor pad-text-item :initform nil)
   (sequence-item :accessor pad-sequence-item :initform nil)
   )
  (:default-initargs
    :window-title "P-Apropos")
  )

(defmethod initialize-instance :after
           ((ich portable-apropos-dialog)
            &rest init-list)
  (declare (ignore init-list))
  (set-view-size ich 260 475)
  (let ((ueberschrift
         (m->a=erzeuge-dialog-item '*b-static-text-dialog-item*
                                   :dialog-item-text "Teilstring"
                                   :view-position (make-point 0 0)))
        apropos-item inspect-item
        
        )
    (setf (pad-text-item ich)
          (m->a=erzeuge-dialog-item
           '*b-text*
           :allow-returns nil
           :view-position (make-point 5 20)
           :view-size (make-point 250 25)))
    (setq  apropos-item
           (m->a=erzeuge-dialog-item 
            '*b-button*
            :dialog-item-text "Apropos"
            :view-position (make-point 0 45)
            :dialog-item-action
            #'(lambda(egal)
                (declare (ignore egal))
                (let* ((text (dialog-item-text (pad-text-item ich)))
                       (liste
                        (apropos-list text)))
                  (set-table-sequence (pad-sequence-item ich) liste)
                   #+:aclpc
                   (progn
                      (invalidate-view (pad-sequence-item ich) t)
                      (view-draw-contents (pad-sequence-item ich))
                   
                      )))))
    (set-default-button #+:ccl ich apropos-item)
    (setq  inspect-item
           (m->a=erzeuge-dialog-item 
            '*b-button*
            :dialog-item-text "Inspect"
            :view-position (make-point 140 45)
            :dialog-item-action
            #'(lambda(egal)
                (declare (ignore egal))
                (let* ((zelle (first (selected-cells  (pad-sequence-item ich))))
                       (wert (when zelle (cell-contents (pad-sequence-item ich) zelle))))
                  (when wert
                    (inspect wert))))))
    (setf (pad-sequence-item ich)
          (m->a=erzeuge-dialog-item 
           '*b-sequence-dialog-item-lite*
           :Table-Vscrollp t
           :max-length 20
           :view-position (make-point 0 75)
           ;:view-size (make-point 260 400)
           :cell-size (make-point (- 260 15) 20)
           :table-sequence (list 'portable-apropos-dialog)
           )
          )
    (add-subviews ich ueberschrift (pad-text-item ich) apropos-item inspect-item (pad-sequence-item ich))
    
    )
  )

(defmethod set-view-size :after ((ich portable-apropos-dialog) h &optional v)
  (declare (ignore h v))
  (when (and (pad-sequence-item ich)
             (pad-text-item ich))
    (let ((breite (point-h (view-size ich)))
          (hoehe (point-v (view-size ich)))
          )
      (set-view-size (pad-text-item ich) (make-point (- breite 10) 15))
      #+no (set-view-size (pad-sequence-item ich) (make-point breite (- hoehe 75)))
      )))
#|
(m->a=erzeuge-fenster 'portable-apropos-dialog)
|#