
;;
;; standarddialoge
;; stand 4/94, bambi
;;
;; dateiauswahl, -eingabe
;; schriftauswah
;; nachricht

(defun choose-file-dialog (&key directory button-string mac-file-type)
     (declare (ignore mac-file-type))
     (b=dateiauswahl :ordner directory
          :buttontext button-string)
     )

(defun choose-new-file-dialog (&key directory prompt button-string)
     (declare (ignore prompt button-string))
     (b=dateieingabe :ordner directory)
     )

(defun b=dateiauswahl ( &key ordner buttontext  &allow-other-keys)
     (when (and ordner (stringp ordner))
          (setq ordner (full-pathname ordner)))
     (let ((datei? (pop-up-open-file-dialog
                             *unser-haupt-fenster* nil
                             (nth (random 4) '( "Allegro" "Stefan" "Karsten" "D3"))
                             (or buttontext "Datei auswhlen")
                             nil
                             (merge-pathnames (or ordner *default-pathname-defaults*)))
             )
            )
         (if datei?
              datei?
            (throw-top-level))
         ))

(defun b=dateieingabe (&key ordner directory
                         &allow-other-keys)
   (when directory
      (setq ordner directory))
       (when (and ordner (stringp ordner))
          (setq ordner (full-pathname ordner)))
     (catch  'PC::DEFAULT-CANCEL
         (let ((datei?
                 (pop-up-save-file-dialog
                         *unser-haupt-fenster* (merge-pathnames (or ordner *default-pathname-defaults*))
                             (nth (random 4) '( "Allegro" "Stefan" "Karsten" "D3"))
                         "Datei angeben"
                         "foo"
                         (merge-pathnames (or ordner *default-pathname-defaults*)))
                     ))
         (if datei?
              datei?
            (throw-top-level))
         )
     )
     )

(defun b=schriftauswahl (&key (schrift (make-font nil nil 16))
                                            ueberschrift-ergaenzung)
     (declare (ignore ueberschrift-ergaenzung))
     (catch  'PC::DEFAULT-CANCEL
         (let ((font?  
                    (cg:ask-user-for-font 
                     :initial-font schrift))
                )
            (if font?
               font?
               (throw-top-level))
            )))


         
         
(defun b=ordnerauswahl (&key ordner buttontext text
                          (throw-to-cancel t)
                          directory
                          button-string
                          prompt)
   (declare (ignore throw-to-cancel))
   (let* ((widget-hoehe 180)
          (widget-breite 250)
          (list-widget 
             (m->a=erzeuge-dialog-item
              'eg-single
              :double-click-fn 
              'subdirectory-list-box-double-click-fn 
              :view-position (make-point 10 10)
              :view-size (make-point widget-breite widget-hoehe))
             )
          (static-text
             (m->a=erzeuge-dialog-item
              '*b-static-text-dialog-item* 
              :name :directory-name 
              :view-size (make-point (+ 20 widget-breite) 20)
              :view-position (make-point 10 (+ widget-hoehe 20)))
             )
          (dialog
             (m->a=erzeuge-modal-fenster
              '*b-button-window*
              :window-title (or  prompt text "Dirs")
              :view-position :centered
              :view-size (make-point (+ 40 widget-breite) (+ widget-hoehe 70))
              :buttons
              (list
                 (m->a=erzeuge-dialog-item
                  '*b-abbrechen-button*
                  :dialog-item-action
                  #'(lambda(was)
                       (declare (ignore was))
                       (return-from-modal-dialog :cancel)))
                 (m->a=erzeuge-dialog-item
                  '*b-ok-button*
                  :dialog-item-text
                  (or button-string buttontext (b=s :ok))
                  :dialog-item-action
                  #'(lambda(was)
                       (declare (ignore was))
                       (return-from-modal-dialog
                        (pathname-string-from-directory-list-box
                         list-widget)))))))
          )
      (add-subviews dialog list-widget static-text)
      (subdirectories-to-list-box
       list-widget
       (namestring 
          (or (full-pathname ordner)
              (full-pathname directory)
              *default-pathname-defaults*))
       :static-text static-text
       )
      (modal-dialog dialog)
      )
   )