/*
 *  useage:  unbracket <file.ilisp >file.lisp
 *
 *
 * This program takes an Interlisp source file as input, and modifies
 * the file so that the '[' character is converted to '(', and the
 * ']' character is converted to the proper number of ')' characters.
 *
 * To do so we read through the file and keep track of when we see
 * brackets and parentheses; when we see a close-bracket we know to
 * insert the current number of unmatched left-parentheses.
 *
 * Peter Karp, 10/25/89
 */


#include    <stdio.h>

main()
{
    int    pcount[100], nest, i;
    char   buffer[512], newbuffer[512], string[100];
    register char  *cp, *ncp, *sp;

    nest = 0;

    while ( fgets(buffer, 512, stdin) )
    {
	ncp = newbuffer;

	for ( cp=buffer ;  *cp != 0  ;  ++cp )
	{
	    string[0] = *cp;
	    string[1] = 0;

	    switch( *cp )
	    {
	        case  '%':
		    string[1] = *cp++;
		    string[2] = 0;
		    break;

		case  '[':
		    pcount[++nest] = 1;
		    string[0] = '('; 
		    break;

		case  ']':
		    for ( i=0 ; i < pcount[nest]  ;  ++i )
			string[i] = ')';
		    string[i] = 0;
		    --nest;
		    if ( nest == -1 )
		    {   fprintf( stderr, "error: extra ] at line <%s>\n", buffer );
			exit(1);
		    }
		    break;

		case '(':
		    ++pcount[nest];
		    break;

		case ')':
		    --pcount[nest];
		    break;

		default:
		    break;
	    }

	    for ( sp=string  ;  *sp != 0  ;  )
		*ncp++ = *sp++;
	}

	*ncp = 0;

	fputs( newbuffer, stdout );
    }
}
