;;;-*- Base: 10; Mode: Lisp; Syntax: Common-lisp; Package: (translisp) -*-
;;;_________________________________________________________________________________
;;;
;;;                       System: TransLisp
;;;                       Module: System-Translisp
;;;
;;; Copyright (c): Forschungsgruppe INFORM,
;;;                Universitaet Stuttgart,
;;;
;;; File:		       system-translisp.lsp
;;; File Creation Date: 
;;; Last Modification Time:    Sat Jan 23 22:06:45 1988
;;; Last Modification By:      Matthias Ressel
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;; 
;;;________________________________________________________________________________ 

; ______________________________________________________________________

;;; Package Definition (in attribute list)

(in-package 'translisp
  :nicknames '(tl)
  :use '(lisp))

(import '(user:load-system user:defsys))

;;; Make the package easily accessable

(use-package 'translisp 'user)

;;; Add feature :system-translisp to avoid interpreting
;;; some eval-when (compile) (load's

(push :system-translisp *features*)

;;;; System definition

(defsys TransLisp
    (:module pattern-franz-syntax "pattern-macros" "franz-syntax")
    (:module pattern-franz-macros "pattern-macros" "franz-macros")
    (:module pattern-record-franz "pattern-macros"  "record-macros"
	     "franz-macros" "franz-syntax")
    ;; file         	load		  compile		files which force
    ;;              	environment       environment           recompilations of
    ;;                                                          this file
   
    ("record-macros"      nil               nil                   nil)
    ("pattern-macros"     nil               nil                   nil)
    ("franz-macros"       nil               nil                   nil)
    ("franz-syntax"       nil               nil                   nil)
    ("rule-macros-compile" nil     ("record-macros" "pattern-macros") nil)
    ("read-macros" pattern-franz-syntax pattern-franz-syntax ("pattern-macros"))
    ("init-rule-handling" ("read-macros")   ("read-macros")       nil)
    ("match14"   pattern-franz-macros pattern-franz-macros pattern-franz-macros)
    ("translisp" pattern-record-franz pattern-record-franz pattern-franz-macros))

;  (:module InitRuleHandling ("Rules;init-rule-handling")
;	   (:uses-definitions-from ReadMacros))
;  (:module FranzMacros ("franz-macros"))
;  (:module FranzSyntax ("franz-syntax"))
;
;  (:module PatternMacros ("pattern-macros"))
;  (:module RecordMacros ("record-macros"))
;  (:module ReadMacros ("read-macros")
;	   (:uses-definitions-from PatternMacros FranzSyntax))
;  (:module PatternMatcher ("match14")
;	   (:uses-definitions-from PatternMacros FranzMacros))
;  (:module RuleSystem ("translisp")
;	   (:uses-definitions-from PatternMacros RecordMacros FranzMacros))
;  (:module RuleCompiling ("Rules;rule-macros-compile"))	

(defvar *tl-pathname-defaults* (pathname "./"))

(defun load-tl (&optional simulate)
  (declare (special translisp))
  (load-system translisp :load  *tl-pathname-defaults* :simulate simulate))

(defun compile-tl (&optional simulate)
  (declare (special translisp))
  (load-system translisp :compile *tl-pathname-defaults* :simulate simulate))
