;;; -*- Package: TRANSLISP; Mode: LISP; Syntax: Common-lisp; Base: 10 -*-

(in-package 'translisp)

(export '(state-rulefile state-rulefile-abbr))

(defvar *default-ruleset* 'Standard)
(defvar *default-goal* '(People))

(defstruct (state (:predicate statep))
  "Informationen ueber geladene Regeln"
  rulefile
  rulefile-abbr
  goal
  rules
  rulesets
  deactivated-rules)

(defstruct (rule (:predicate rulep))
	"interne Repraesentation einer Regel"
	name
	(ruleset *default-ruleset*)
	(priority 1)
	match-function
	pattern
	(condition t)
	replacement-function
	replacement
	(action nil)
	(optimization-goal *default-goal*)
	(protocol-flag '(NoProtocol))
	(attributes nil))