;;; -*- Package: TRANSLISP; Mode: LISP; Syntax: Common-lisp; Base: 10 -*-

;;; Macros concerning rule pattern and replacements

(in-package 'translisp)

; Creators
; ========

(defmacro CreateUnnamElem ()
  `(list '$var 'UnnamElem 'Elem nil))
(defmacro CreateUnnamSegm ()
  `(list '$var 'UnnamSegm 'Segm nil))
(defmacro CreateNamElem (name)
  `(list '$var 'NamElem 'Elem ,name))
(defmacro CreateNamSegm (name)
  `(list '$var 'NamSegm 'Segm ,name))
(defmacro CreateRestrictUnnamElem (pred)
  `(list '$var 'RestrictUnnamElem 'Elem nil ,pred))
(defmacro CreateRestrictUnnamSegm (pred)
  `(list '$var 'RestrictUnnamSegm 'Segm nil nil ,pred))
(defmacro CreateUnnamSegmWithRestrictElems (pred)
  `(list '$var 'UnnamSegmWithRestrictElems 'Segm nil ,pred))
(defmacro CreateRestrictUnnamSegmWithRestrictElems (elementpred
                                                    segmentpred)
  `(list '$var
         'RestrictUnnamSegmWithRestrictElems
         'Segm
         nil
         ,elementpred
         ,segmentpred))
(defmacro CreateRestrictNamElem (name pred)
  `(list '$var 'RestrictNamElem 'Elem ,name ,pred))
(defmacro CreateRestrictNamSegm (name pred)
  `(list '$var 'RestrictNamSegm 'Segm ,name nil ,pred))
(defmacro CreateNamSegmWithRestrictElems (name pred)
  `(list '$var 'NamSegmWithRestrictElems 'Segm ,name ,pred))
(defmacro CreateRestrictNamSegmWithRestrictElems (name
                                                  elementpred
                                                  segmentpred)
  `(list '$var
         'RestrictNamSegmWithRestrictElems
         'Segm
         ,name
         ,elementpred
         ,segmentpred))

(defmacro CreateToBeEvaluatedAndThenSplicedExpression (expr)
  `(list '$var 'EvaluateAndSplice ,expr))
(defmacro CreateToBeEvaluatedAndThenInsertedExpression (expr)
  `(list '$var 'EvaluateAndInsert ,expr))

; Selectors
; =========

(defmacro Type (var)
  `(caddr ,var))
(defmacro Name (thing)
  `(cadddr ,thing))
(defmacro ElemsName (thing)
  `(cadddr ,thing))
(defmacro SegmsName (thing)
  `(cadddr ,thing))
(defmacro ThePredicate (thing)
  `(car (car (cddddr ,thing))))
(defmacro TheElemPredicate (thing)
  `(car (car (cddddr ,thing))))
(defmacro TheSegmPredicate (thing)
  `(car (cadr (cddddr ,thing))))
(defmacro ShowElemPredicate (thing)
  `(cadr (car (cddddr ,thing))))
(defmacro ShowSegmPredicate (thing)
  `(cadr (cadr (cddddr ,thing))))

(defmacro ExpressionToBeEvaled (thing)
  `(car (caddr ,thing)))
(defmacro ShowExpressionToBeEvaled (thing)
  `(cadr (caddr ,thing)))

; Predicates
; ==========

(defmacro Var? (thing)
  `(and (consp ,thing)
        (eq (car ,thing) '$var)))

(defmacro UnnamElem? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'UnnamElem)))
(defmacro UnnamSegm? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'UnnamSegm)))
(defmacro NamElem? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'NamElem)))
(defmacro NamSegm? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'NamSegm)))
(defmacro RestrictUnnamElem? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'RestrictUnnamElem)))
(defmacro RestrictUnnamSegm? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'RestrictUnnamSegm)))
(defmacro UnnamSegmWithRestrictElems? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'UnnamSegmWithRestrictElems)))
(defmacro RestrictNamElem? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'RestrictNamElem)))
(defmacro RestrictNamSegm? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'RestrictNamSegm)))
(defmacro NamSegmWithRestrictElems? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'NamSegmWithRestrictElems)))
(defmacro RestrictNamSegmWithRestrictElems? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'RestrictNamSegmWithRestrictElems)))
(defmacro RestrictUnnamSegmWithRestrictElems? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'RestrictUnnamSegmWithRestrictElems)))

(defmacro InsertVariable? (thing)
  `(and (Var? ,thing)
	(eq (cadr ,thing) 'NamElem)))
(defmacro SpliceVariable? (thing)
  `(and (Var? ,thing)
	(eq (cadr ,thing) 'NamSegm)))

(defmacro Segm? (thing)
  `(and (Var? ,thing)
        (eq (Type ,thing) 'Segm)))
(defmacro Elem? (thing)
  `(and (Var? ,thing)
        (eq (Type ,thing) 'Elem)))

(defmacro Nam? (var)
  `(Name ,var))
(defmacro Unnam? (var)
  `(not (Name ,var)))

(defmacro RestrictElem? (var)
  `(TheElemPredicate ,var))
(defmacro RestrictSegm? (var)
  `(TheSegmPredicate ,var))

(defmacro IsVariable? (thing)
  `(and (Var? ,thing)
        (or (eq (cadr ,thing) 'NamElem)
            (eq (cadr ,thing) 'NamSegm))))
(defmacro IsEvaluateAndInsert? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'EvaluateAndInsert)))
(defmacro IsEvaluateAndSplice? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'EvaluateAndSplice)))
(defmacro IsSpliceVariable? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'NamSegm)))

; Restriction Stuff
; =================

(defmacro CreateMemqExpression (elements)
  `(list '$var 'MemqExpr ,elements))

(defmacro CreateMemberExpression (elements)
  `(list '$var 'MemberExpr ,elements))

(defmacro MemqExpression? (expr)
  `(and (Var? ,expr)
        (eq (cadr ,expr) 'MemqExpr)))

(defmacro MemberExpression? (expr)
  `(and (Var? ,expr)
        (eq (cadr ,expr) 'MemberExpr)))

(defmacro MemElements (memq-or-member-expr)
  `(caddr ,memq-or-member-expr))

(defmacro MemSet (mem-restr-var)
  `(MemElements (ShowElemPredicate ,mem-restr-var)))

(defmacro MemqRestr? (var)
  `(MemqExpression? (ShowElemPredicate ,var)))

(defmacro MemberRestr? (var)
  `(MemberExpression? (ShowElemPredicate ,var)))
  
(defmacro MemSet-Segm (mem-restr-var)
  `(MemElements (ShowSegmPredicate ,mem-restr-var)))

(defmacro MemqRestr?-Segm (var)
  `(MemqExpression? (ShowSegmPredicate ,var)))

(defmacro MemberRestr?-Segm (var)
  `(MemberExpression? (ShowSegmPredicate ,var)))
  
; Eval Form Stuff
; ===============

(defmacro CreateEvalForm (expr)
  `(list `(lambda ()
            ,,expr) ,expr))

#|| CCC - Alte Version
(defmacro CreateQuoteFormInEval (expr)
  `(list 'ReplaceVariables (list 'quote ,expr) '*bindings*))
||#

(defmacro CreateQuoteFormInEval (expr)
  ``(ReplaceVariables ,,expr))

(defmacro ReplaceVariables (pat)
  (transform-replacement-1 pat))

; Splicing Inheritance Stuff
; ==========================

(defmacro CreateToBeSplicedExpression (expr)
  `(list '$var 'ToSplice ,expr))
(defmacro ToBeSpliced? (thing)
  `(and (Var? ,thing)
        (eq (cadr ,thing) 'ToSplice)))
(defmacro ExpressionToSplice (var)
  `(caddr ,var))

; Binding Stuff
; =============

(defmacro BindingOf (var bindings)
  `(assoc (Name ,var) ,bindings :test #'eq))
(defmacro lookup (var bindings)
  `(cdr (BindingOf ,var ,bindings)))

(defmacro $var (&whole var &rest ignore)
  `(cdr (assoc ',(Name var) *bindings*)))

(setf (get 'pattern-macros 'version) '3.32)

