
(define (initialize-haskell-system)
  (when (not *haskell-initialized?*)
    (initialize-haskell-system/forced))
  'haskell-ready)

(predefine (**tycon/def def args))  ; in util/constructors.scm
(predefine (init-cse-structs))      ; in csys/dump-cse.scm

(define (initialize-haskell-system/forced)
  (setf *haskell-initialized?* '#t)
  (setf *error-output-port* (current-output-port))
  (init-core-symbols)
  (init-tuples)
  (setf *standard-module-default*
	(make default-decl
	      (types (list
		      (**tycon/def (core-symbol "Int") '())
		      (**tycon/def (core-symbol "Double") '())))))
  (setf *undefined-def*
	(make def
	      (name '*undefined*)
	      (unit '*undefined*)
	      (module '*undefined*)))
  (setf *printer-class*
	(make class
	      (name '|Printers|)
	      (module '|*Core|) (unit '|*Core|)))
  (init-cse-structs))

;;; This should be called in the system restart code generated by a
;;; disk save

(define (load-init-files)
 (load-init-file "$HASKELL/.yhaskell")
 (load-init-file "~/.yhaskell"))

(define (load-init-file name)
  (when (file-exists? name)
    (load name)))

