; -*- mode:     CL -*- ----------------------------------------------------- ;
; File:         ZEBU-init.l
; Description:  Loading Zebu and the Compiler
; Author:       Joachim H. Laubsch
; Created:      19-May-92
; Modified:     Wed Aug  3 10:50:00 1994 (Joachim H. Laubsch)
; Language:     CL
; Package:      CL-USER
; Status:       Experimental (Do Not Distribute) 
; RCS $Header: $
;
; (c) Copyright 1992, Hewlett-Packard Company
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Revisions:
; RCS $Log: $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; to use or compile Zebu, you must load this file first

;; to load the Zebu Compiler, it has to be compiled
;;  To compile the Zebu Compiler load COMPILE-ZEBU.l

;; zb:zebu to               "Load the Zebu Parser"
;; zb:zebu-compiler to      "Load the Zebu Compiler"
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#-MCL(in-package "USER")
#+MCL(in-package "CL-USER")

#-MCL
(progn
  (unless (find-package "CL-USER")
    (defpackage "USER" (:nicknames "CL-USER")))
  (in-package "CL-USER"))

(provide "ZEBU-init")

;; edit the following form for your Lisp, and the directory where you keep Zebu
(defvar *ZEBU-directory*
  (make-pathname :directory
		 (pathname-directory
		  #-ALLEGRO *load-pathname*
		  #+ALLEGRO (merge-pathnames *load-pathname*
					     *default-pathname-defaults*)))
  )

(defvar *ZEBU-binary-directory*
  (make-pathname :directory (append (pathname-directory *ZEBU-directory*)
				    (list "binary"))))

(let ((*default-pathname-defaults* *ZEBU-directory*))
  (load (merge-pathnames (make-pathname :name "zebu-package"
					:type "lisp"))))

(shadowing-import '(zb::zebu zb::zebu-compiler) (find-package "CL-USER"))
(export '(zb::zebu zb::zebu-compiler) (find-package "ZB"))

#+LUCID(proclaim '(special zb:*zebu-version*))
#-LUCID(declaim (special zb:*zebu-version*))

#+(or MCL Allegro)
(defvar *load-binary-pathname-types* '("fasl"))

#+(and :SUN :LUCID)
(setq *load-binary-pathname-types* '("sbin"))

(defun zb:zebu ()
  "Load the Zebu Parser"
  (let ((binary-path (merge-pathnames
		      (make-pathname
		       :type (car *load-binary-pathname-types*))
		      *ZEBU-binary-directory*)))
    (dolist (name '("zebu-aux"
		    "zebu-mg-domain"
		    "zebu-mg-hierarchy"
		    "zebu-loader"
		    "zebu-driver"
		    "zebu-actions"))
      (require name
	       (merge-pathnames (make-pathname :name name) binary-path)))
    (format t "~%;;; Zebu (Version ~a) loaded!" zb:*zebu-version*)
    (values)))

(defun zb:zebu-compiler ()
  "Load the Zebu Compiler"
  (zb::zebu)
  (push ':ZEBU *features*)
  (let ((binary-path (merge-pathnames
		      (make-pathname
		       :type (car *load-binary-pathname-types*))
		      *ZEBU-binary-directory*)))
    (dolist (name '("zebu-kb-domain" "zebu-regex"
		    "zebu-oset" "zebu-g-symbol" "zebu-loadgram"
		    "zebu-generator" "zebu-lr0-sets" "zebu-empty-st" "zebu-first"
		    "zebu-follow" "zebu-tables" "zebu-slr" "zebu-closure"
		    "zebu-lalr1" "zebu-dump" "zebu-compile"
		    "zebu-printers"))
      (unless (member name *modules* :test #'string=)
	(load (merge-pathnames (make-pathname :name name) binary-path))))
    (zb::zebu-load-file (merge-pathnames
			 (make-pathname :name "zebu-mg" :type "tab")
			 *ZEBU-binary-directory*))
    (format t "~%;;; Zebu Compiler (Version ~a) loaded!" zb:*zebu-version*)
    (values)))

(defun zb:zebu-rr ()
  "Load the rewrite-rule module"
   (zb::zebu)
  (let ((binary-path (merge-pathnames
		      (make-pathname
		       :type (car *load-binary-pathname-types*))
		      *ZEBU-binary-directory*)))
    (dolist (name '("zebu-kb-domain" "zebu-tree-attributes"
		    "zebra-debug"))
      (unless (member name *modules* :test #'string=)
	(load (merge-pathnames (make-pathname :name name) binary-path))))
    (values)))
    
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; You may want to omit this and rather import only a subset of the 
;; symbols or use package "ZEBU" in another package than the CL-USER
;; package.

(use-package (find-package "ZEBU"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                               A few Examples
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#||
;; load the compiler
(zb:zebu-compiler)
(defvar *ZEBU-test-directory*
  (make-pathname :directory (append (pathname-directory *ZEBU-directory*)
				    (list "test"))))
(defvar *ZEBU-test-binary-directory*
  (make-pathname :directory (append (pathname-directory *ZEBU-test-directory*)
				    (list "binary"))))

(progn
  #+LUCID
  (or (probe-file *ZEBU-test-binary-directory*)
      (shell (format nil "mkdir ~a" (namestring *ZEBU-test-binary-directory*))))
  #+MCL
  (create-file *ZEBU-test-binary-directory* :if-exists nil)
  )

(zebu-compile-file (merge-pathnames
		    (make-pathname :name "ex1" :type "zb") *ZEBU-test-directory*)
		   :output-file
		   (merge-pathnames
		    (make-pathname :name "ex1" :type "tab")
		    *ZEBU-test-binary-directory*))

(zb:zebu-load-file (merge-pathnames
		    (make-pathname :name "ex1" :type "tab")
                    *ZEBU-test-binary-directory*))

(zb:zebu)
(zebu-load-file (merge-pathnames
		 (make-pathname :name "ex1" :type "tab")
                 *ZEBU-test-binary-directory*))
(setq zebu:*current-grammar* (zb:find-grammar "ex1"))
(list-parser '(1 "+" 1))
(equal (read-parser "1 + 1") (list-parser '(1 "+" 1)))
(read-parser "1.0 * 1")
(read-parser "1.0 * 1/33")
(read-parser "1.0 * a1")
(read-parser "1.0 * .3")
(read-parser "1.0 * 12.3")

||#

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                             End of ZEBU-init.l
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
