; -*- mode:     CL -*- ----------------------------------------------------- ;
; File:         COMPILE-ZEBU.l
; Description:  compiling Zebu without DEFSYS
; Author:       Joachim H. Laubsch
; Created:      13-May-92
; Modified:     Tue Mar 23 14:21:48 1993 (Joachim H. Laubsch)
; Language:     CL
; Package:      CL-USER
; Status:       Experimental (Do Not Distribute) 
; RCS $Header: $
;
; (c) Copyright 1992, Hewlett-Packard Company
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Revisions:
; RCS $Log: $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#+MCL
(unless (find-package "CL-USER")
  (defpackage "USER" (:nicknames "COMMON-LISP-USER" "CL-USER")))

(in-package "CL-USER")

(proclaim '(special *ZEBU-directory* *ZEBU-binary-directory*))

;; edit the following form for your Lisp, and the directory where you keep Zebu
(setq *ZEBU-directory*
      (make-pathname :directory
		     (pathname-directory
		      #-ALLEGRO *load-pathname*
		      #+ALLEGRO (merge-pathnames *load-pathname*
						 *default-pathname-defaults*)))

      *ZEBU-binary-directory*
      (make-pathname :directory (append (pathname-directory *ZEBU-directory*)
					(list "binary"))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; compilation: Production mode
(proclaim '(optimize (speed 3) (safety 1) (compilation-speed 0)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#+LUCID(or (probe-file *ZEBU-binary-directory*)
	   (shell (format nil "mkdir ~a" (namestring *ZEBU-binary-directory*))))

#+ALLEGRO(unless (probe-file *ZEBU-binary-directory*)
	   (let ((dir (format nil "~abinary"
			      (namestring *ZEBU-directory*))))
	     (unless (zerop (run-shell-command
			     (format nil "mkdir ~a" dir)))
	       (error "Could not create directory ~s" dir))))

#+MCL(create-file *ZEBU-binary-directory* :if-exists nil)

#+(or MCL Allegro)
(proclaim '(special *load-source-pathname-types* *load-binary-pathname-types*))

#+(or MCL Allegro)
(setq *load-source-pathname-types* '("lisp" NIL))

#+(or MCL Allegro)
(setq *load-binary-pathname-types* '("fasl"))

(let ((*default-pathname-defaults*
       (merge-pathnames
	*ZEBU-directory*
	(make-pathname :type (first *load-source-pathname-types*)))))
  (load (merge-pathnames "zebu-package")))

(let ((*default-pathname-defaults*
       (merge-pathnames
	*ZEBU-directory*
	(make-pathname :type (first *load-source-pathname-types*))))
      (binary-path (merge-pathnames
		    (make-pathname
		     :type (car *load-binary-pathname-types*))
		    *ZEBU-binary-directory*))
      (*compile-verbose* t)
      (*load-verbose* t)
      (load-before-compile '()))
  (dolist (task '((compile "zebu-package")
		  (compile "zebu-aux")
		  (load    "zebu-aux")
		  (compile "zebu-kb-domain")
		  (load    "zebu-kb-domain")
		  (compile "zebu-mg-hierarchy")
		  (load    "zebu-mg-hierarchy")
		  (compile "zebu-regex")
		  (load    "zebu-regex")
		  (compile "zebu-loader")
		  (load    "zebu-loader")
		  (compile "zebu-driver")
		  (compile "zebu-actions")
		  (compile "zebu-oset")
		  (load    "zebu-oset")
		  (compile "zebu-g-symbol")
		  (load    "zebu-g-symbol")
		  (compile "zebu-generator")
		  (load    "zebu-generator")
		  (compile "zebu-loadgram")
		  (load    "zebu-loadgram")
		  (compile "zebu-lr0-sets")
		  (load    "zebu-lr0-sets")
		  (compile "zebu-empty-st")
		  (load    "zebu-empty-st")
		  (compile "zebu-first")
		  (load    "zebu-first")
		  (compile "zebu-follow")
		  (load    "zebu-follow")
		  (compile "zebu-tables")
		  (compile "zebu-slr")
		  (load    "zebu-slr")
		  (compile "zebu-closure")
		  (load    "zebu-closure")
		  (compile "zebu-lalr1")
		  (load    "zebu-lalr1")
		  (compile "zebu-dump")
		  (load    "zebu-dump")
		  (compile "zebu-compile")
		  (load    "zebu-compile")
		  (load    "zebu-tables")
		  (compile "zebu-printers")
		  (load    "zebu-printers") ; only for debugging
		  (zebu    "zebu-mg")
		  (compile "zebu-mg-domain")))
    (let ((file-path (make-pathname :name (cadr task))))
      (case (car task)
	(compile (let* ((ofile (merge-pathnames file-path binary-path))
			(odate (and (probe-file ofile)
				    (file-write-date ofile)))
			(ifile (merge-pathnames file-path))
			(idate (if (probe-file ifile)
				   (file-write-date ifile)
				 (error "File not found ~a" ifile))))
		   (when (or (null odate) (> idate odate))
		     ;; now do the postponed loads
		     (dolist (file-path (nreverse load-before-compile))
		       (load (merge-pathnames file-path binary-path)))
		     (setq load-before-compile nil)
		     (compile-file ifile :output-file ofile))))
	(load				; postpone load
	         (push file-path load-before-compile))
	(zebu    (let* ((ofile (merge-pathnames
				(merge-pathnames
				 (make-pathname :type "tab")
				 file-path)
				binary-path))
			(odate (and (probe-file ofile)
				    (file-write-date ofile)))
			(ifile (merge-pathnames
				(merge-pathnames
				 (make-pathname :type "zb")
				 file-path)))
			(idate (if (probe-file ifile)
				   (file-write-date ifile)
				 (error "File not found ~a" ifile)))
			zb:*generate-domain*)
		   (when (or (null odate) (> idate odate))
		     (ZB:zebu-compile-file ifile :output-file ofile))))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                            End of COMPILE-ZEBU.l
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
