;;; -*- Mode: Lisp; Package: GNODE -*-

;;; $Header: /afs/athena.mit.edu/course/other/allp/nlp/tools/RCS/gnode-tools.lisp,v 3.1 92/06/16 14:45:11 sfelshin Exp $

;;; Copyright (c) 1986-89, 1992 Massachusetts Institute of Technology.
;;; All rights reserved.
;;; Transcribed from the original Martian tablets
;;; by the Athena Language Learning Project.

(in-package :gnode)

(provide-module :gnode-tools)

#||
(export '(with-gnode-child gnode-command gnode-format finish-gnode-output))
||#

#||(global '(open-gnode close-gnode restart-gnode))||#

(require-module :feat-support)
#||(use-package :features)||#


;;; ======================================================================
;;; Process control
;;; ======================================================================

(defvar *gnode-process* nil)

(defun close-gnode ()
  (when *gnode-process*
    (close *gnode-process*)
    (setq *gnode-process* nil))
  t)

(defun open-gnode (&optional (path "/lingo/bin/tree"))
  (unless *gnode-process*
    #+aix
    (setq *gnode-process*
	  (sys::run-aix-program path :input :stream :wait nil))
    ;; On Macs, GNODE uses no foreign process at all; the code is
    ;; all native.  Yay!
    #+ccl nil
    #-(or aix ccl) (warn "GNODE cannot be used on this system"))
  t)

(defun restart-gnode (&optional (path "/lingo/bin/tree"))
  (close-gnode)
  (open-gnode path))

(open-gnode)


;;; ======================================================================
;;; Communication with gnode
;;; ======================================================================

#-:ccl
(defun gnode-command (&rest top-args)
  (labels ((gc (args)
	     (dolist (arg args)
	       (etypecase arg
		 (simple-bit-vector
		  (describe-features arg *gnode-process* :compress-p t))
		 (symbol
		  (write-string (symbol-name arg) *gnode-process*))
		 (fixnum
		  (princ arg *gnode-process*))
		 (list
		  (gc arg))
		 (character
		  (write-char arg *gnode-process*))
		 (string
		  (write-string arg *gnode-process*))))))
      (gc top-args)
      (write-char #\newline *gnode-process*)))

#+:ccl
(defun gnode-command (command &rest args)
  (declare (special *current-node-plist*))
  (let ((command-char (schar command 0)))
    (ecase command-char
      ((#\T #\K)
       (setq *current-node-plist*
             (list* :window-title (copy-seq (first args)) *current-node-plist*)))
      ((#\e #\t #\f #\s)
       (setq *current-node-plist*
             (list* (case command-char
                      (#\e :nw-box)
                      (#\t :ne-box)
                      (#\f :sw-box)
                      (#\s :se-box))
                    (make-instance 'text-box
                      :string (string (first args))
                      :font "a4")
                    *current-node-plist*)))
      (#\a
       (setq *current-node-plist*
             (list* :font command *current-node-plist*)))
      (#\l
      (setq *current-node-plist*
             (list* :line-fill command *current-node-plist*)))
      (#\b
       (setq *current-node-plist*
             (list* :line-shape command *current-node-plist*))))))

#-:ccl
(defun gnode-format (format-string &rest args)
  (do ((rargs args (rest rargs)))
      ((endp rargs))
    (when (typep (first rargs) 'simple-bit-vector)
      (setf (first rargs)
	    (with-output-to-string (*gnode-process*)
	      (describe-features (first rargs)
				 *gnode-process* :compress-p t)))))
  (format *gnode-process* "~?~%" format-string args))

#+:ccl
(defun gnode-format (format-string &rest args)
  (declare (special *current-node-plist*))
  (do ((rargs args (rest rargs)))
      ((endp rargs))
    (when (typep (first rargs) 'simple-bit-vector)
      (setf (first rargs)
	    (with-output-to-string (*gnode-process*)
	      (describe-features (first rargs)
				 *gnode-process* :compress-p t)))))
  (setq *current-node-plist*
        (list*
         (ecase (schar format-string 0)
           (#\t :ne-box)
           (#\e :nw-box)
           (#\s :se-box)
           (#\f :sw-box))
         (make-instance 'text-box
           :string (format nil "~?" (subseq format-string 1) args)
           :font "a4")
         *current-node-plist*)))

#-:ccl
(defmacro with-gnode-child (name &rest body)
  `(progn
     (gnode-command "c" ,name)
     (unwind-protect
	  (progn ,@body)
       (gnode-command "p"))))

#+:ccl
(defmacro with-gnode-child (name &rest body)
  (let ((name-var (gensym)))
    `(let ((,name-var (copy-seq (if (stringp ,name)
                                  (if (string= ,name "[empty]")
                                    "e"
                                    ,name)
                                  (symbol-name ,name)))))
       (declare (special *current-node-plist*))
       (setf (getf *current-node-plist* :children)
             (cons (let ((*current-node-plist* '()))
                     (declare (special *current-node-plist*))
                     ,@body
                     (let ((font (getf *current-node-plist* :font)))
                       (remf *current-node-plist* :font)
                       (apply #'make-instance 'tree-node
                              :main-box (make-instance 'text-box
                                          :string ,name-var
                                          :font font)
                              :children (nreverse
                                         (getf *current-node-plist* :children))
                              *current-node-plist*)))
                   (getf *current-node-plist* :children))))))

(defmacro finish-gnode-output ()
  #-:ccl (finish-output *gnode-process*))
