enum LispType {
    LispObj_BadType,
    LispObj_Number,
    LispObj_String,
    LispObj_Symbol,
    LispObj_Cons
};

typedef struct lispobj lispobj;

struct lispobj {
    enum LispType lo_type;
    union lispobj_u {
	struct lou_cons {
	    lispobj *louc_car;
	    lispobj *louc_cdr;
	} lou_cons;
	long lou_number;
	char *lou_string;
    } lispobj_u;
};

#define lo_car		lispobj_u.lou_cons.louc_car
#define lo_cdr		lispobj_u.lou_cons.louc_cdr
#define lo_number	lispobj_u.lou_number
#define lo_string	lispobj_u.lou_string

#define lo_symbol	lo_string /* should eventually have its own type... */

extern lispobj *Fcons();
extern lispobj *Fnconc2();

extern lispobj *Fnumber();
extern lispobj *Fstring();
extern lispobj *Fsymbol();

extern void Finitialize();
extern void Ffree();
extern void Fprint();
extern void Frecord();

/*
 * Query:
 * Should these be lispobj's rather than  lispobj *'s?
 *
 * Also, when we malloc lispobj's, we currently malloc room for
 * a general lispobj.  We might want to just malloc room for the
 * specific type of lispobj.  But, since we don't malloc that
 * many lispobj's, we don't bother -- it doesn't save that much
 * space and it keeps the code simpler.
 */

extern lispobj *Qnil;
extern lispobj *Qt;
extern lispobj *Qquote;
extern lispobj *Qfunction;
extern lispobj *Qsexp_read;
extern lispobj *Qeof;

typedef lispobj *lispobj_t;
