
/*
 * we have a list of features
 * for each feature found in our sexp:
 * if it's on our list of features, we assume t
 * else we assume nil; we also have a short list
 * of functions -- or, not, and and.  Our evaluations
 * return one of three values -- t, nil, error.
 *
 */
lispobj *
Feval_feature_sexp(obj)		/* FIXME */
    lispobj *obj;
{
    if ((obj->lo_type == LispObj_String) ||
	(obj->lo_type == LispObj_Symbol))
	return (Feval_feature_atom(obj));
    else if (obj->lo_type == LispObj_Cons) {
	if ((obj->lo_car->lo_type != LispObj_String) &&
	    (obj->lo_car->lo_type != LispObj_Symbol)) {
	    fprintf(stderr, "badly formed feature list\n");
	    return (Qerror);
	}
	/*
	 * its car is either a string or a symbol
	 * and strings and symbols store the string in the same place...
	 * FIXME
	 */
	if (!stricmp(obj->lo_car->lo_symbol, Qor->lo_symbol))
	    return (Feval_feature_or(obj));
	else if (!stricmp(obj->lo_car->lo_symbol, Qand->lo_symbol))
	    return (Feval_feature_and(obj));
	else if (!stricmp(obj->lo_car->lo_symbol, Qnot->lo_symbol))
	    return (Feval_feature_not(obj));
	else {
	    fprintf(stderr, "unrecognized function in features list\n");
	    return (Qerror);
	}
    } else {
	/* FIXME */
	fprintf(stderr, "unsupported object type in feature list\n");
	return (Qerror);
    }
	
}

/*
 * evaluate (or ... ...)
 * where each ... is (potentially) a feature
 * we return as soon as we either know the
 * truth value or we get an error...
 */
lispobj *
Feval_feature_or(obj)
    lispobj *obj;
{
}

/*
 * evaluate (and ... ...)
 * where each ... is (potentially) a feature
 * we return as soon as we either know the
 * truth value or we get an error...
 */
lispobj *
Feval_feature_and(obj)
    lispobj *obj;
{
}

/*
 * evaluate (not ...)
 * where ... is (potentially) a feature
 * we return as soon as we either know the
 * truth value or we get an error...
 */
lispobj *
Feval_feature_not(obj)
    lispobj *obj;
{
}
