#include <stdio.h>
#include "lisp.h"

extern lispobj *Qnil;

/*
 * It is an error to call this with anything other than
 * a Cons Cell (Qnil is a cons, in this reader)
 */
lispobj *
Fcar(obj)
    lispobj *obj;
{
    if (obj->lo_type != LispObj_Cons) {
	fprintf(stderr, "Fcar called with a non-cons cell, address = 0x%x\n",
		obj);
	return (Qnil);
    }
    return (obj->lo_car);
}

/*
 * It is an error to call this with anything other than
 * a Cons Cell (Qnil is a cons, in this reader)
 */
lispobj *
Fcdr(obj)
    lispobj *obj;
{
    if (obj->lo_type != LispObj_Cons) {
	fprintf(stderr, "Fcdr called with a non-cons cell, address = 0x%x\n",
		obj);
	return (Qnil);
    }
    return (obj->lo_cdr);
}

/*
 * It is an error for place to not be a true list
 * with an even number of elements;  it is an error
 * (in this version of getf) for indicator to be a list
 */
Fgetf(place, indicator)
    lispobj *place;
    lispobj *indicator;
{
    for (; (place->lo_type == LispObj_Cons) &&
	 (place->lo_cdr->lo_type == LispObj_Cons);
	 place = place->lo_cdr->lo_cdr) {
	if (place == Qnil)
	    return (Qnil);

	if (place->lo_car->lo_type != indicator->lo_type)
	    continue;

	switch (indicator->lo_type) {
	case LispObj_Number:
	    if (place->lo_car->lo_number != indicator->lo_number)
		continue;

	    if (place->lo_cdr->lo_type != LispObj_Cons)
		return (Qnil);	/* user f*cked up; list is dotted */

	    return (place->lo_cdr->lo_car);

	case LispObj_Symbol:
	    if (strcmp(place->lo_symbol, indicator->lo_symbol))
		continue;

	    if (place->lo_cdr->lo_type != LispObj_Cons)
		return (Qnil);	/* user f*cked up; list is dotted */

	    return (place->lo_cdr->lo_car);

	case LispObj_String:
	    if (strcmp(place->lo_string, indicator->lo_string))
		continue;

	    if (place->lo_cdr->lo_type != LispObj_Cons)
		return (Qnil);	/* user f*cked up; list is dotted */

	    return (place->lo_cdr->lo_car);

	case LispObj_Cons:
	    fprintf(stderr, "second arg to Fgetf is a cons, address = 0x%x\n",
		    indicator);
	    return (Qnil);

	default:
	    fprintf(stderr,
		    "second arg to Fgetf is of unknown type, type = %d addr = 0x%x\n",
		    indicator->lo_type, indicator);
	    return (Qnil);
	}
    }
    return (Qnil);		/* we didn't find it... */
}
