/* character types */
#define T_EOF			0 /* end-of-file */
#define T_ILLEGAL		1 /* illegal character */
#define T_CONSTITUENT		2 /* token constituent character */
#define T_WHITESPACE		3 /* seperates tokens */
#define T_MACRO_TERM		4 /* terminates token */
#define T_MACRO_NONTERM		5 /* doesn't terminate token */
#define T_SINGLE_ESCAPE		6 /* treat next char as alphabetic */
#define T_MULTIPLE_ESCAPE	7 /* treat chars as alphabetic */

/* constituent character attributes */
#define A_EOF			0x00
#define A_ALPHABETIC		0x01
#define A_DIGIT			0x02
#define A_ALPHADIGIT		0x03 /* (A_ALPHABETIC | A_DIGIT) */
#define A_PLUS_SIGN		0x04 /* '+' */
#define A_MINUS_SIGN		0x08 /* '-' */
#define A_SIGN			0x0c /* '+' or '-' */
#define A_DOT			0x10 /* '.' */
#define A_DECIMAL_PT		0x20 /* '.' */
#define A_PACKAGE_MARKER	0x40 /* ':' */
#define A_ILLEGAL		0x80

struct char_types {
    int type;
    int attributes;
};

extern struct char_types char_types[];

/*
 * arguments to read_token
 *
 */
#define NO_CHAR		-1	/* not a character */

#define NO_MULTI_ESCAPE	0	/* not inside of a multi-escape sequence */
#define MULTI_ESCAPE	1	/* inside of a multi-escape sequence */

#define READ_SUCCESS	0
#define READ_ERROR	1
