;;;; -*- Mode:Common-Lisp; Package:clip; Fonts:(medfnt); Base:10; Patch-file:t -*-
;;;; *-* File: Titanic: /usr/users/eksl/systems/clip/clip-hacks.lisp *-*
;;;; *-* Last-edit: Monday, December 6, 1993  13:05:09; Edited-By: anderson *-* 
;;;; *-* Machine: Count (Explorer II, Microcode 489) *-*
;;;; *-* Software: TI Common Lisp System 6.49 *-*
;;;; *-* Lisp: TI Common Lisp System 6.49  *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *                                                                        *
;;;; *                         Hacks to CLIP Functions                        *
;;;; *                                                                        *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Scott D. Anderson
;;;             Experimental Knowledge Systems Laboratory
;;;             Paul R. Cohen, Principal Investigator
;;;             David L. Westbrook, Systems Manager
;;;             David M. Hart, Laboratory Manager
;;;             Department of Computer Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  11-12-93 File Created.  (Anderson)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;; --*--

(in-package #+CLTL2 clip #-CLTL2 'clip)

;;; --*--
;;; ***************************************************************************

;;; Modified the debugging stuff because I needed to use w:notify, and I think
;;; it's better to be able to redefine a function than a macro, because you
;;; don't have to recompile all the callers.

(setf *debug* t)			   ; Yes, I want debug statements

(defun when-debugging-format* (format-string &rest format-args)
  "Outputs debugging information about CLIP.  Defaults to `format,' but you can change this function if you
need to direct debugging info to another stream, or use ``notifications'' or some such."
  (progn (fresh-line *standard-output*)
	 (apply #'format *standard-output* format-string format-args)
	 (terpri *standard-output*))
  #+ignore
  (apply #'w:notify nil format-string format-args))

(defmacro when-debugging-format (tag format-string &rest format-args)
  (declare (ignore tag))
  `(when *debug* (when-debugging-format* ,format-string ,@format-args)))

;;; ============================================================================
;;; Modified this to not throw out, since it'll only be called from the `run'
;;; method from now on.  Secondly, it doesn't need to do a `stop-system,' since
;;; running `stop-system' is what gets this function running.  Third, eliminate
;;; the `shutdown-action' argument and instead analyze cases based on the
;;; `status' arg: If status is `running-trial,' which is the normal case, go on
;;; to next trial; if status is `...

;;; Never mind, I'm not going to use this function, period.  The code is now
;;; directly in the `run' method, because it makes the logic of whether to loop
;;; easier.

#+ignore
(defmethod shutdown-trial ((the-experiment experiment))
  (with-slots (status after-trial-function after-experiment-function
		      trial-number last-trial-number instrumentation)
              the-experiment
    (unless (member status '(:running-trial :rerun-trial :abort-experiment))
      (when-debugging-format "Weird status in SHUTDOWN-TRIAL:  ~s" status))
    ;; Don't stop the simulator--that's already been done.  SDA
    '(stop-system nil)
    ;; After-trial code is only for normal status
    (when (and (eq status :running-trial) after-trial-function)
      (setf status :running-after-trial-code)
      (when-debugging-format experiment-runner "Running :AFTER-TRIAL code")
      (apply after-trial-function
	     (append 
	       ;; Reversed order because of lambda-list-keywords. (Rubinstein)
	       (get-ivs-values the-experiment) 
	       (get-arg-values the-experiment))))
    ;; Check for last trial...
    (if (and (not (eq shutdown-action :abort-experiment))
             (or (eq shutdown-action :rerun-trial)
                 (<= (incf trial-number) last-trial-number)))
	;; Not last trial, so return T
	T
	;; We just did the last trial so shut 'er down.
	(progn
	  (when-debugging-format experiment-runner "Running :AFTER-EXPERIMENT code")
	  (setf status :shutting-down-experiment)
	  (when after-experiment-function
	    (apply after-experiment-function (get-arg-values the-experiment)))
	  ;; ...disable the instrumentation.
	  (dolist (instrumentation instrumentation)
	    (disable instrumentation))
	  (close-error-file the-experiment)
	  (setf status :idle)
	  (setf *current-experiment* nil)
	  ;; and return NIL, to stop the looping
	  nil))))

;;; The following functions are defined just so they get re-compiled, since they
;;; use `when-debugging-format.' I don't think these function have any purpose
;;; anymore, since aborting experiments and shutting down trials is done by
;;; modifying the `status' slot of the experiment and then arranging for the
;;; `start-system' function to return.

(defmethod shutdown-experiment ((the-experiment experiment))
  "This will cause the current trial to be aborted \(no data will be written\) and will return the system to
the state it was before the experiment began \(by running the after-experiment code\)."
  (when-debugging-format experiment-runner "Abnormal Experiment Shutdown")
  (shutdown-trial the-experiment :abort-experiment))

(defun shutdown-trial-of-current-experiment (&optional (action :run-next-trial))
  (assert *current-experiment* () "there is no experiment currently running.")
  (when-debugging-format experiment-runner "Early Trial Shutdown; ~a"
			 (ecase action
			   (:rerun-trial      "rerunning trial")
			   (:run-next-trial   "starting next trial")
			   (:abort-experiment "aborting experiment")))
  (shutdown-trial *current-experiment* action))

;;; ============================================================================
;;; Put a when-debugging-format in here.  Otherwise, this is unchanged.

(defmethod startup-experiment ((the-experiment experiment) arg-list repetitions)
  (when-debugging-format experiment-runner "Startup experiment: ~s ~s ~s" the-experiment arg-list repetitions)
  (with-slots (before-experiment-function status last-trial-number seconds-per-time-unit) the-experiment
    (when-debugging-format experiment-runner "Running :BEFORE-EXPERIMENT code")
    (setf status :initializing)
    (setf (seconds-per-time-unit) seconds-per-time-unit)
    (store-arg-values the-experiment arg-list)
    (store-ivs-elements the-experiment arg-list)
    (init-local-values the-experiment arg-list)
    (unless last-trial-number 
      (setf last-trial-number 
	    (or (compute-ending-trial-number the-experiment repetitions)
		(error "you have to supply :NUMBER-OF-TRIALS"))))
    (when before-experiment-function
      (apply before-experiment-function arg-list))))

;;; ============================================================================
;;; Removed form that set `status' to :running-trial, since we have to do other
;;; stuff first.

(defmethod startup-trial ((the-experiment experiment))
  (when-debugging-format experiment-runner "Loop:  Startup trial")
  (with-slots (before-trial-function trial-number
				     last-trial-number status ivs-and-args) the-experiment
    (format *standard-output* "~&TRIAL NUMBER ~d OF ~d~%" trial-number last-trial-number)
    (when-debugging-format experiment-runner "Running :BEFORE-TRIAL code")
    (setf status :initializing-trial)
    (init-ivs-values-for-trial the-experiment)
    (setf ivs-and-args (append (get-ivs-values the-experiment) 
			       (get-arg-values the-experiment)))
    (when before-trial-function
      (apply before-trial-function ivs-and-args))
    (reset-system ivs-and-args)))

;;; ============================================================================
;;; Error in usage of schedule-function.  Sometimes it's called with 3 or 4
;;; positional arguments, others with keyword args.  I'm going with positional
;;; args.

(defmethod schedule ((the-script-element script-element) &optional ignore)
  (declare (ignore ignore))
  (with-slots (name time interval code) the-script-element
    (if interval
	(schedule-function code time interval name)
	(schedule-function code time NIL name))))

;;; ============================================================================

(defmethod process-instrumentation-names ((the-experiment experiment)) ()
  (when-debugging-format experiment-runner "Processing instrumentation names")
  (with-slots (instrumentation instrumentation-names) the-experiment 
    ;; Insure that the latest version of each instrumentation is used.
    (setf instrumentation
          (mapcar #'find-instrumentation instrumentation-names))
    (check-instrumentation-component-congruity instrumentation)))

;;; ============================================================================
;;; Moved the instrumentation stuff out of the `run' method.  I haven't defined
;;; a defgeneric for this.

(defmethod reset-instrumentation ((the-experiment experiment))
  "Resets and enables all instrumentation.  Called in the main loop of the `run' method of experiments."
  (when-debugging-format experiment-runner "Loop:  reset instrumentation")
  (with-slots (status ivs timestamp-clip instrumentation) the-experiment
    (setf status :reset-instrumentation)
    (reset (find-instrumentation 'trial-number))
    (dolist (iv ivs)
      (reset (find-instrumentation iv))
      (enable (find-instrumentation iv)))
    (when timestamp-clip
      (reset timestamp-clip)
      (enable timestamp-clip))
    (dolist (in instrumentation)
      (reset in)
      (enable in))))  

;;; ============================================================================
;;; Changed how trials end under user control.  Now, the user just tells how and
;;; when to stop the system, and this function schedules `stop-system' to run,
;;; instead of scheduling `shutdown-trial-of-current-experiment.' That function
;;; is no longer used; we do everything here, modifying the `status' variable so
;;; that we can tell where things died if they do.  The rule is to modify
;;; `status' before each call to user code, since it's mostly in the user code
;;; that we're likely to die.

;;; This function could use some shortening!  Also, arguments to user functions
;;; should be cleaned up.  There's ivs-and-args, and `get-args,' and Zack's
;;; stuff...

(defmethod run ((the-experiment experiment) args
		 ending-trial-number
		 repetitions end-time
		 output-file error-stream error-file extra-header
		 starting-trial-number)
  
  (declare (ignore error-stream))
  
  (with-slots (status first-trial-number last-trial-number trial-number
		      end-of-trial-time script-setup-function scenario
		      script-name output-file-name error-file-name
		      extra-header-string headers-output-already instrumentation
		      timestamp-clip timestamp-clip-name arguments ivs
		      after-trial-function after-experiment-function)
	      the-experiment
    ;; Check for correct number of arguments in `args'.
    (assert (= (length args) (length arguments)) (arguments)
	    "too ~:[few~;many~] arguments given.  There are ~s:  ~s"
	    (> (length args) (length arguments))
	    (length arguments) arguments)
    
    (setf first-trial-number starting-trial-number
          last-trial-number ending-trial-number 
          end-of-trial-time end-time
          trial-number starting-trial-number
          output-file-name output-file
          error-file-name error-file
          extra-header-string extra-header
          headers-output-already nil)
    
    (process-instrumentation-names the-experiment)
    ;; Explicitly set timestamp-clip to nil, otherwise it's unbound.  SDA
    (if timestamp-clip-name
	(setf timestamp-clip (find-instrumentation timestamp-clip-name))
	(setf timestamp-clip nil))
    (startup-experiment the-experiment args repetitions)
    
    (loop 
      (startup-trial the-experiment)
      (when script-setup-function
	(funcall script-setup-function))
      (when end-of-trial-time
	(when-debugging-format experiment-runner "Loop:  Schedule end-of-trial")
	;; All it needs to do is stop the system.  Can't use `stop-system-hook,' which is the user's function,
	;; because it might take arguments and we need a no arg function for scheduling.  SDA 11/22/93
	(schedule-function 'stop-system end-of-trial-time nil 'end-of-trial))
      (reset-instrumentation the-experiment)
      (start-system (slot-value the-experiment 'ivs-and-args))
      (when-debugging-format experiment-runner "Loop:  Returned from system")
      (unless (member status '(:running-trial :rerun-trial :abort-experiment))
	(when-debugging-format "Weird status after return:  ~s" status))
      ;; If status is :abort-experiment, stop looping
      (when (eq status :abort-experiment) (return))
      ;; If status is :rerun-trial, this will go to the top of the loop
      (unless (eq status :rerun-trial)
	;; Status must be :running-trial, which is normal, so run :after-trial code.
	(when after-trial-function
	  (setf status :after-trial)
	  (when-debugging-format experiment-runner "Running :AFTER-TRIAL code")
	  (apply after-trial-function
		 (append 
		   ;; Reversed order because of lambda-list-keywords. (Rubinstein)
		   (get-ivs-values the-experiment) 
		   (get-arg-values the-experiment))))
	;; Stop looping unless more trials
	(unless (<= (incf trial-number) last-trial-number)
	  (return))))
    
    ;; After experiment code is after the loop
    (when-debugging-format experiment-runner "Running :AFTER-EXPERIMENT code")
    (setf status :after-experiment)
    (when after-experiment-function
      (apply after-experiment-function (get-arg-values the-experiment)))
    ;; ...disable the instrumentation.
    (setf status :disable-instrumentation)
    (dolist (instrumentation instrumentation)
      (disable instrumentation))
    (close-error-file the-experiment)
    (setf status :done)))

;;; ============================================================================
;;; New function to replace `shutdown-trial-of-current-experiment'

(defun rerun-trial ()
  "Function that users should call when they have detected an error condition of some sort that renders the
trial worthless, but rerunning the trial may work.  This is a no-arg function that Phoenix users can use for
*phoenix-error-restart-hook* and *task-error-hook*.  We should find a more general mechanism, probably using
error handlers."
  (assert *current-experiment* () "there is no experiment currently running.")
  (with-slots (status stop-system-hook ivs-and-args) *current-experiment*
    (setf status :rerun-trial)
    ;; If there's no stop-system-hook, this is probably doomed.
    (when stop-system-hook
      (apply stop-system-hook ivs-and-args))))

;;; ============================================================================
;;; Changed to call `schedule-function' correctly.  This function is called in
;;; expanding the macro `define-experiment'

(defun process-script-specs (experiment-name specs)
  `(progn
     ,@(mapcar
	 #'(lambda (element)
	     (cond ((atom element)
		    `(schedule (find-script-element ',element)))
		   ((= (length element) 1)
		    `(schedule (find-script-element ',(first element))))
		   ((= (length element) 3)
		    (let* ((name (first element))
			   (time (second element))
			   (code (third element)))
		      (check-type name symbol)
		      (check-type time (or number string cons symbol))
		      (check-type code cons)
		      `(schedule-function
			 ,(build-code-call experiment-name name code)
			 (parse-time-specifier ,time)
			 ;; Changed calling form.  SDA  11/22/93
			 nil
			 ',name)))
		   ((= (length element) 4)
		    (let* ((name (first element))
			   (time (second element))
			   (repeat-time (third element))
			   (code (fourth element)))
		      (check-type name symbol)
		      (check-type time (or number string cons symbol))
		      (check-type repeat-time (or number cons symbol))
		      (check-type code cons)
		      `(schedule-function
			 ,(build-code-call experiment-name name code)
			 (parse-time-specifier ,time)
			 ;; Changed calling form.  SDA  11/22/93
			 (parse-time-specifier ,repeat-time :interval-p t)
			 ',name)))
		   (t
		    (error "improper script element specification; ~s" element))))
	 specs)))

;;; ============================================================================
;;; Changed to pass the correct args and take no args.  SDA

(defun stop-system ()
  (assert *current-experiment* () "there is no experiment currently running.")
  (with-slots (stop-system-hook ivs-and-args) *current-experiment*
    (when stop-system-hook
      (apply stop-system-hook ivs-and-args))))

;;; ============================================================================
;;; Changed to set the status slot to :running-trial.  I think this should be a
;;; method instead.

(defun start-system (args)
  (when-debugging-format experiment-runner "Loop:  Starting system")
  (assert *current-experiment* () "there is no experiment currently running.")
  (with-slots (status start-system-hook) *current-experiment*
    (assert start-system-hook () "you need to supply :START-SYSTEM")
    (setf status :running-system)
    ;; Can't do anything after this, because it may not return for a while!
    (apply start-system-hook args)))

;;; ============================================================================
;;; Changed to write out the `extra-header' information.  The user is
;;; responsible for formatting.

(defmethod write-experiment-headers ((the-experiment experiment) stream &optional specific-instrumentations)
  (with-slots (name description scenario script-name system-name
		    first-trial-number last-trial-number end-of-trial-time
		    extra-header-string instrumentation) the-experiment
    (multiple-value-bind (second min hour date month year)
        (get-decoded-time)
      (declare (ignore second))
      (when-debugging-format write-experiment
			     "extra-header-string = ~s~%*output-format* = ~s"
			     extra-header-string *output-format*)
      (when (eq *output-format* :CLASP)
;                             ~@[~:{~4,,,'*<~>~1@T~99@<~a~>~1@T~4,,,'*<~>~%~}~]~
;                     ~@[~:{~4,,,'*<~>~1@T~99@<~a~>~1@T~4,,,'*<~>~%~}~]~
	;; Added the ~a at the end of this, for the extra-header-string.  SDA 12/2/93
	(format stream "~%\"~%~109,,,'*<~>~%~
                     ~4,,,'*<~>~1@T~99@T~1@T~4,,,'*<~>~%~
                     ~4,,,'*<~>~1@T~99@<Experiment: ~:(~a~)~>~1@T~4,,,'*<~>~%~
                     ~4,,,'*<~>~1@T~99@<Machine: ~a~>~1@T~4,,,'*<~>~%~
                     ~4,,,'*<~>~1@T~99@<~a version: ~a~>~1@T~4,,,'*<~>~%~
                     ~4,,,'*<~>~1@T~99@<Date: ~d/~d/~d ~d:~d~>~1@T~4,,,'*<~>~%~
                     ~4,,,'*<~>~1@T~99@<Scenario: ~:(~a~)~>~1@T~4,,,'*<~>~%~
                     ~4,,,'*<~>~1@T~99@<Script-name: ~:(~a~)~>~1@T~4,,,'*<~>~%~
                     ~4,,,'*<~>~1@T~99@<First trial number: ~d~>~1@T~4,,,'*<~>~%~
                     ~4,,,'*<~>~1@T~99@<Last trial number: ~d~>~1@T~4,,,'*<~>~%~
                     ~4,,,'*<~>~1@T~99@<Number of trials: ~d~>~1@T~4,,,'*<~>~%~
                     ~4,,,'*<~>~1@T~99@<Max trial length: ~d hours~>~1@T~4,,,'*<~>~%~
                      ~109,,,'*<~>~%~
                                 ~a
                     ~%The key follows:\""
		#+BAD
		(and description
		     #+Explorer
		     (tv:break-string-into-lines description)
		     #-Explorer
		     (list description))
		name
		#+Explorer
		net:local-pretty-host-name
		#-Explorer
		"Unknown"
		system-name
		(system-version (slot-value the-experiment 'argument-values))
		month date (- year 1900) hour min
		(if scenario (name scenario) "None")
		(or script-name "None")
		first-trial-number
		last-trial-number
		(1+ (- last-trial-number first-trial-number))
		(if end-of-trial-time (internal-time->hours end-of-trial-time) "Unknown")
		;; Removed this, since scenario is given above.  SDA 12/2/93
		#+BAD
		scenario
;              (when scenario
;                (mapcar #'(lambda (agent) (list (ad.number agent) (ad.type agent))) 
;                        (get-agents-from-scenario scenario)))
		;; added this arg, to go with the ~a.  SDA 12/2/93
		(or extra-header-string "")
		#+BAD
		(and extra-header-string
		     #+Explorer
		     (tv:break-string-into-lines extra-header-string)
		     #-Explorer
		     (list extra-header-string))))
      
      (let ((instrumentations (or (parse-instrumentation specific-instrumentations nil) instrumentation)))
	(print-report-key-implicit-clips the-experiment stream (some #'time-series-p instrumentations))
	(dolist (inst instrumentations)
	  (print-report-key inst stream))
	(when (eq *output-format* :CLASP)
	  (terpri stream))))))

;;; Added the following method so that it's easier to add some more text to the
;;; header string from other packages.  It also exists to hide the
;;; implementation of header strings.

(defmethod append-extra-header ((the-experiment experiment) string)
  (with-slots (extra-header-string) the-experiment
    (setf extra-header-string
	  (concatenate 'string
		       extra-header-string
		       string))))

;;; ***************************************************************************
;;; EOF
