/* f_pat takes library filename and pattern (regular expression)  */
/* and compares against library, printing title lines of hits     */

#include <stdio.h>
#include "regexp.h"

#define MAXL	10000	/* maximum sequence length	*/
#define MAXLINE 512	/* maximum line length		*/
#define MAXPAT  1000	/* max chars in processed pattern */
char seq[MAXL];		/* amino acid sequence array	*/

main(argc,argv)
int argc;
char **argv;
{
	int i,j,seq_tot;
	char *calloc();
	char *lib_name,*pat;
	int seql;
	FILE *fp, *fopen();
	char c;
	char pres_name[MAXLINE],new_name[MAXLINE];
	regexp *p_pat;

	lib_name=argv[1];		/* library filename	*/
	pat=argv[2];			/* unprocessed pattern 	*/


	p_pat=regcomp(pat,0);		/* processed (compiled) pattern */

	/* 	open library	*/

	if((fp=fopen(lib_name,"r"))==NULL){
		printf("can't open library %s\n",lib_name);
		exit();
	}

		
		/*start library*/

	while (fgets(pres_name,MAXLINE,fp)!=NULL && pres_name[0]!='>');


/*	loop through library		*/

	while((seql=getseq(fp,new_name,seq,MAXL))>0){

		if(regexec(p_pat,seq,0)>0) match_out(p_pat,pres_name,seq);
			
		strcpy(pres_name,new_name);
	}
}





/* reads through aabank.lib and retrieves sequence */


#include "ascii.gbl"

#define TRUE 1
#define FALSE 0

getseq(fp,name,seq,maxs)
FILE *fp;
char *seq,*name;
int maxs;
{
	char cflag;
	char line[MAXLINE];
	register char *ln;
	register int n;
	char lib_nam[40],c;

	int i,j;
	int ic;


	i=0;
	n=0;

	n=0;
	ln=&(line[0]);

	while(fgets(ln,MAXLINE,fp)!=NULL && ln[0]!='>'){
		while(*(ln)){
			if((n<maxs)&&((ic=aascii[(*ln)&AAMASK])>=0))
				if (ic>0)  seq[n++]= *ln;
			ln++;
		}
		ln=&(line[0]);
	}
	if(ln[0]=='>')strcpy(name,ln);
	if (n==maxs) printf(" sequence may be truncated\n");
	seq[n]= 0;
	return n;
}


match_out(regpat,seq_name,seq)
regexp *regpat;
char *seq_name,*seq;
{
	int ll;
	char *ps,*pe;

	ps=regpat->startp[0];
	pe=regpat->endp[0];

	printf("%s",seq_name);
	printf("position # %d  to  # %d\n",1+ (ps-seq),pe-seq);
	ll=0;
	while(ps!=pe){
		putchar(*(ps++));
		if(ll++ == 60){putchar('\n');ll=0;}
	}
	printf("\n\n");
}
			
