
static char rcsid[] = "$Header$";
/************************************************************************
 *
 * File: client.c
 *
 * Oz Project, School of Computer Science 
 * Carnegie Mellon University
 *
 * Created:       Wed Sep 22 21:11:59 1993 by Mark Kantrowitz
 * Last Modified: Fri Sep 24 17:58:13 1993 by Mark Kantrowitz
 * RCS info:
 *       Source file: $Source$
 *    Current Locker: $Locker$
 *             State: $State$
 *   Accumulated log: $Log$
 *
 * Socket Client
 *
 ************************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <errno.h>
#include <sys/file.h>

#define Error           (void) fprintf

/* 
 * This program creates a socket and initiates a connection with the socket 
 * given in the command line. One message is sent over the connection and
 * then the socket is closed, ending the connection. The form of the command
 * line is
 *   streamwrite hostname portnumber file
 */

main(argc,argv)
     int argc;
     char *argv[];
{
  int sock;
  char *Ifile;
  char *prog;
  char *Stdin = "FOO";
  int ifd, cnt;
  int establish_connection();
  unsigned char ibuf[1024 * 64];

  prog = argv[0];               /* save program initiation name */

  /* If no filenames, read stdin */
  if (argc <= 2) {
    Ifile = Stdin;
  } else {
    Ifile = argv[3];
  }

  if (Ifile == Stdin) {
    ifd = fileno(stdin);
  } else {
    if ((ifd = open(Ifile, O_RDONLY, 0)) < 0) {
      Error(stderr, "%s: cannot open \n", prog);
      perror(Ifile);
      exit(1);
    }
  }

  if ((sock = establish_connection(argv[1], argv[2])) < 0) {
      exit(0-sock);
  }

  while ((cnt = read(ifd, (char *)ibuf, sizeof (ibuf))) > 0) {
    if (write(sock, (char *)ibuf, cnt) < 0)
      perror("writing on stream socket\n");
  }

  close(sock);
  close(ifd);
}

int establish_connection(host, port)
     char *host;
     char *port;
{
  int sock;
  struct sockaddr_in server;
  struct hostent *hp, *gethostbyname();

  /* Create socket */
  sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror("opening stream socket\n");
    return(-1);
/*    exit(1); */
  }
  
  /* Connect socket using name specified by command line */
  server.sin_family = AF_INET;
  hp = gethostbyname(host);
  if (hp == 0) {
    fprintf(stderr, "%s: unknown host\n", host);
    close(sock);
    return(-2);
/*    exit(2);  */
  }
  bcopy(hp->h_addr, &server.sin_addr, hp->h_length);
  server.sin_port = htons(atoi(port));

  if (connect(sock, &server, sizeof(server)) < 0) {
    perror("connecting stream socket\n");
    close(sock);
    return(-1);
/*    exit(1); */
  }

  return(sock);
}

close_connection(port)
  int port;
{

  close(port);

}

get_serv_port(service, type)
     char *service;
     char *type;
{
  struct servent *sp;
  sp = getservbyname(service, type);
  if (sp == NULL) {
    return(0);
  } else {
    return(sp->s_port);
  }
    
}
