;; (C) Copyright 1985 Massachusetts Institute of Technology
;;
;; Permission to use, copy, modify, distribute, and sell this software
;; and its documentation for any purpose is hereby granted without fee,
;; provided that the above copyright notice appear in all copies and that
;; both that copyright notice and this permission notice appear in
;; supporting documentation, and that the name of M.I.T. not be used in
;; advertising or publicity pertaining to distribution of the software
;; without specific, written prior permission.  M.I.T. makes no
;; representations about the suitability of this software for any
;; purpose.  It is provided "as is" without express or implied warranty.
;;

;;;; Regions

(DEFBOXER-COMMAND COM-DEFINE-REGION ()
  "defines a region between the current
location of the cursor and the cursor. "
  (LET ((LOCAL-REGION (GET-LOCAL-REGION)))
    (COND ((NOT-NULL LOCAL-REGION)		;there already IS a region in the current box
	   (SETQ *REGION-BEING-DEFINED* LOCAL-REGION)
	   ;; we have to decide which BP of the region to replace with *POINT*
	   (IF (BP-< *POINT* (TELL LOCAL-REGION :START-BP))
	       (TELL LOCAL-REGION :SET-START-BP *POINT*)
	       (TELL LOCAL-REGION :SET-STOP-BP  *POINT*)))
	  (T					;There is No current region so we make one
	   (SETQ *REGION-BEING-DEFINED*
		 (MAKE-EDITOR-REGION (MAKE-INITIALIZED-BP :FIXED (POINT-ROW) (POINT-CHA-NO))))
	   (TELL *REGION-BEING-DEFINED* :TURN-ON)
	   (PUSH *REGION-BEING-DEFINED* REGION-LIST)))))

(DEFBOXER-COMMAND COM-INSTALL-REGION ()
  "installs the current region"
  (UNLESS (NULL *REGION-BEING-DEFINED*)
    (LET ((OLD-START-BP (TELL *REGION-BEING-DEFINED* :START-BP))
	  (OLD-STOP-BP  (TELL *REGION-BEING-DEFINED* :STOP-BP)))
    (MULTIPLE-VALUE-BIND (NEW-START-BP NEW-STOP-BP)	;make sure the BP's are at the
	(ORDER-BPS OLD-START-BP OLD-STOP-BP)
      (TELL *REGION-BEING-DEFINED* :SET-START-BP NEW-START-BP)
      (TELL *REGION-BEING-DEFINED* :SET-STOP-BP  NEW-STOP-BP)
      (INSTALL-REGION *REGION-BEING-DEFINED*)
      (UNLESS (OR (EQ *POINT* OLD-START-BP) (EQ *MOUSE-BP* OLD-START-BP))
	(TELL (BP-ROW OLD-START-BP) :DELETE-BP OLD-START-BP))
      (UNLESS (OR (EQ *POINT* OLD-STOP-BP) (EQ *MOUSE-BP* OLD-STOP-BP))
	(TELL (BP-ROW OLD-STOP-BP) :DELETE-BP OLD-STOP-BP))))))

(DEFBOXER-COMMAND COM-FLUSH-REGION ()
  "gets rid of the current region--if it exists. "
  (LET ((REGION-TO-FLUSH (OR *REGION-BEING-DEFINED* (GET-CURRENT-REGION))))
    (UNLESS (NULL REGION-TO-FLUSH)
      (FLUSH-REGION REGION-TO-FLUSH))))



(DEFBOXER-COMMAND COM-KILL-REGION ()
  "kills all the characters in the current region. "
  (LET ((REGION-TO-KILL (OR *REGION-BEING-DEFINED* (GET-CURRENT-REGION))))
    (IF (NULL REGION-TO-KILL)
	(BOXER-EDITOR-ERROR "There is no region that I can find. ")
	(KILL-REGION REGION-TO-KILL)
	(KILL-BUFFER-PUSH REGION-TO-KILL ':FORWARD)
	(FLUSH-REGION REGION-TO-KILL))))

;;; this is really boxify at *point* for now
(DEFBOXER-COMMAND COM-BOXIFY-REGION ()
  "puts all of the characters in the current
region into a box. "
  (LET* ((REGION-TO-BOX (OR *REGION-BEING-DEFINED* (GET-CURRENT-REGION))))
    (UNLESS (NULL REGION-TO-BOX)
      (KILL-REGION REGION-TO-BOX)
      (COM-MAKE-BOX)
      (COM-ENTER-BOX)
      (YANK-REGION *POINT* REGION-TO-BOX)
      (FLUSH-REGION REGION-TO-BOX)
      (SETQ REGION-TO-BOX NIL))))

(DEFBOXER-COMMAND COM-UNMARK-REGION ()
  "unmarks the current region. "
  (LET ((REGION-TO-UNMARK (OR *REGION-BEING-DEFINED* (GET-CURRENT-REGION))))
    (UNLESS (NULL REGION-TO-UNMARK)
      (FLUSH-REGION REGION-TO-UNMARK))))



;;; mice

(DEFUN COM-MOUSE-DEFINE-REGION (WINDOW X Y)
  (WITH-MOUSE-BP-BOUND (X Y WINDOW)
    MOUSE-SCREEN-BOX ;the variable was bound but never used....    
    (LET ((LOCAL-REGION (OR *REGION-BEING-DEFINED* (GET-CURRENT-REGION))))
      (COND ((NOT-NULL LOCAL-REGION)		;there already IS a region in the current box
	     (SETQ *REGION-BEING-DEFINED*   LOCAL-REGION
		   *FOLLOWING-MOUSE-REGION* LOCAL-REGION)
	     ;; we have to decide which BP of the region to replace with *POINT*
	     (IF (BP-< MOUSE-BP (TELL LOCAL-REGION :START-BP))
		 (TELL LOCAL-REGION :SET-START-BP *MOUSE-BP*)
		 (TELL LOCAL-REGION :SET-STOP-BP  *MOUSE-BP*)))
	    (T
	     ;; There is No current region so we make one
	     ;; between the *POINT* which is moved to where the mouse is and
	     ;; wherever it is that we let go of the mouse
	     (MOVE-POINT (BP-VALUES  MOUSE-BP))
	     (REDISPLAY-CURSOR)
	     (SETQ *REGION-BEING-DEFINED*
		   (MAKE-EDITOR-REGION *POINT* *MOUSE-BP*)
		   *FOLLOWING-MOUSE-REGION* *REGION-BEING-DEFINED*)
	     (TELL *REGION-BEING-DEFINED* :TURN-ON)
	     (PUSH *REGION-BEING-DEFINED* REGION-LIST))))))

(DEFUN COM-MOUSE-RELEASE-REGION (WINDOW X Y)
  "Releases the mouse from the region being created. "
  (WITH-MOUSE-BP-BOUND (X Y WINDOW)
    MOUSE-SCREEN-BOX				;bound but never used...
    (UNLESS (NULL *REGION-BEING-DEFINED*)
      (COND ((EQ *MOUSE-BP* (TELL *REGION-BEING-DEFINED* :START-BP))
	     (LET ((NEW-BP (MAKE-BP ':FIXED)))
	       (MOVE-BP NEW-BP (BP-VALUES *MOUSE-BP*))
	       (TELL *REGION-BEING-DEFINED* :SET-START-BP NEW-BP)))
	    ((EQ *MOUSE-BP* (TELL *REGION-BEING-DEFINED* :STOP-BP))
	     (LET ((NEW-BP (MAKE-BP ':FIXED)))
	       (MOVE-BP NEW-BP (BP-VALUES *MOUSE-BP*))
	       (TELL *REGION-BEING-DEFINED* :SET-STOP-BP NEW-BP)))))))

;;; If you think you want to use this, then you are probably wrong
;;; look at COM-MOUSE-RELEASE-REGION instead
(DEFUN COM-MOUSE-INSTALL-REGION (WINDOW X Y)
  WINDOW X Y ;the variables were bound, but never...
  (UNLESS (NULL *REGION-BEING-DEFINED*)
    (LET ((OLD-START-BP (TELL *REGION-BEING-DEFINED* :START-BP))
	  (OLD-STOP-BP  (TELL *REGION-BEING-DEFINED* :STOP-BP)))
      (MULTIPLE-VALUE-BIND (NEW-START-BP NEW-STOP-BP)	;make sure the BP's are at the
	  (ORDER-BPS OLD-START-BP OLD-STOP-BP)
	(TELL *REGION-BEING-DEFINED* :SET-START-BP NEW-START-BP)
	(TELL *REGION-BEING-DEFINED* :SET-STOP-BP  NEW-STOP-BP)
	(INSTALL-REGION *REGION-BEING-DEFINED*)
	(UNLESS (OR (EQ *POINT* OLD-START-BP) (EQ *MOUSE-BP* OLD-START-BP))
	  (TELL (BP-ROW OLD-START-BP) :DELETE-BP OLD-START-BP))
	(UNLESS (OR (EQ *POINT* OLD-STOP-BP) (EQ *MOUSE-BP* OLD-STOP-BP))
	  (TELL (BP-ROW OLD-STOP-BP) :DELETE-BP OLD-STOP-BP))))))
