;;;

(defstruct thermostat bottom-value top-value variable description incr)

(defun construct-thermostat (thermostat &aux w tmp bottom-value description
                                             top-value variable incr)
  (setq w (il:createw (il:getboxregion 100 150)))
  (il:windowprop w 'thermostat thermostat)
  (dotimes (p 11) (il:drawline 50 (setq tmp (+ 8 (* 10 p))) 55 tmp 1 'il:paint w))
  (setq bottom-value (thermostat-bottom-value thermostat))
  (setq top-value (thermostat-top-value thermostat))
  (setq description (thermostat-description thermostat))
  (setq variable (thermostat-variable thermostat))
  (il:moveto 2 133 w)
  (format w "~A" description)
  (il:drawline 0 116 100 116 2 'il:paint w)
  (setq incr (/ (- top-value bottom-value) 10.0))
  (setq tmp (il:dspfont (il:fontcreate 'il:terminal 8) w))
  (dotimes (p 11)
    (il:moveto 18 (+ 6 (* 10 p)) w)
    (format w "~5,2f" (+ bottom-value (* incr p))))
  (il:dspfont tmp w)
  (setf (thermostat-incr thermostat) incr)
  (il:windowprop w 'il:BUTTONEVENTFN #'thermal-driver)
  (update-temprature w)
)

(defun thermal-driver (w &aux bottom-value thermostat top-value variable curval tmp)
 (prog () loop
  (setq thermostat (il:windowprop w 'thermostat))
  (setq bottom-value (thermostat-bottom-value thermostat))
  (setq top-value (thermostat-top-value thermostat))
  (setq variable (thermostat-variable thermostat))
  (setq tmp (+ bottom-value (* (/ (max 1 (- (il:lastmousey w) 8)) 100) (- top-value bottom-value))))
  (cond ((> tmp top-value) (set variable top-value))
        ((< tmp bottom-value) (set variable bottom-value))
        (t (set variable tmp)))
  (update-temprature w)
  (cond ((il:mousestate il:left) (go loop)) (t (return nil)))
  ))


(defun update-temprature (w &aux tmp bottom-value description thermostat
                              top-value variable curval incr)
  (setq thermostat (il:windowprop w 'thermostat))
  (setq bottom-value (thermostat-bottom-value thermostat))
  (setq top-value (thermostat-top-value thermostat))
  (setq description (thermostat-description thermostat))
  (setq variable (thermostat-variable thermostat))
  (il:moveto 2 122 w)
  (format w "~11,5f" (setq curval (eval variable)))
  (setq incr (thermostat-incr thermostat))
  (il:drawline 70 8 70 115 15 'il:erase w)
  (il:drawline 70 8 70 (+ 8 (* (/ (- curval bottom-value) (- top-value bottom-value)) 100)) 15 'il:paint w)
 )