(DEFINE-FILE-INFO READTABLE "INTERLISP" PACKAGE "INTERLISP")
(FILECREATED "31-Jul-89 15:35:52" {DSK}/home/curly/ttf/envos/AUTOBIND.;10 16956  

      changes to%:  (FNS AUTO-BIND EVAL-TO-PROMPTWINDOW)

      previous date%: "17-Jul-89 15:19:12" {DSK}/home/curly/ttf/envos/AUTOBIND.;9)


(* "
Copyright (c) 1989 by ITI.  All rights reserved.
")

(PRETTYCOMPRINT AUTOBINDCOMS)

(RPAQQ AUTOBINDCOMS ((FNS AUTO-BIND AUTO-ITERATE BIND-ITERATION-VARS EVAL-TO-PROMPTWINDOW 
                              INIT-AUTOBIND SEDIT-SET-AND-PRINT TEST-AUTOBIND)
                         (RECORDS IS-INFO)
                         (INITVARS $$STEPS)
                         (GLOBALVARS $$STEPS)
                         (VARS AUTOBIND-HELP)
                         

(* %| "AUTOBIND-HELP describes what autobind does")

                         (P (INIT-AUTOBIND))))
(DEFINEQ

(AUTO-BIND
  [LAMBDA (context charcode extra)                (* ; "Edited 31-Jul-89 15:29 by t.toth-fejel")
    "Meta-Q Takes a selected loop, function call, let or " "      correctly binds the variables" 
    "     (A GREAT timesaver) for faster test-as-you go editing." 
    "    Reads the currently selected region, and:" 
    " If the selected expression is a loop, then it cranks through " "      the first iteration." 
    "   eg. in (for thing in '(z b c d) collect thing)," 
    "      thing gets bound to z, Meta-Tab binds thing " "      to successive elements of the list "
    "  eg. in (for thing from 0 to 10 collect thing), " "      thing gets bound to 0 , etc." 
    "If the expression is a let or let*" "     then it binds all the local variables" 
    "      eg. in (let ((z 10)(b 'tree) c) (list 'goblygook)), " 
    "      z gets bound to 10, b to tree, c to nil." 
    " If the selected expression is a list of length two, " 
    "      with the first a symbol (as in the individual" 
    "      variable assignments in a let expression, " 
    "      the first gets setq'ed to the evaluation of the second." 
    "    If the selected expression is an atom, that atom gets set to nil."
    (LET (SELECTION VALUE VAR)
         (SETQ SELECTION (SEDIT:GET-SELECTION context))
         (CLRPROMPT)                                         (* ; "ATOM")
         (if (ATOM SELECTION)
             then (CL:FORMAT PROMPTWINDOW "~&Set ~a to NIL" SELECTION)
                   (SET SELECTION NIL)                       (* ; "FOR LOOP ITERATION")
           elseif [AND (LISTP SELECTION)
                           (OR (EQ 'FOR (CAR SELECTION))
                               (EQ 'for (CAR SELECTION]
             then (BIND-ITERATION-VARS SELECTION)    (* ; "LET* (SERIAL)")
           elseif (AND (LISTP SELECTION)
                           (EQ 'LET* (CAR SELECTION)))
             then (for THING in (CADR SELECTION)
                         do (if (ATOM THING)
                                    then (SET THING NIL)
                                  elseif (AND (LISTP THING)
                                                  (EQ 2 (LENGTH THING)))
                                    then (SEDIT-SET-AND-PRINT THING))) 
                                                             (* ; "LET (PARALLEL)")
           elseif (AND (LISTP SELECTION)
                           (EQ 'LET (CAR SELECTION)))
             then [EVAL (APPEND '(CL:PSETQ)
                                   (for THING in (CADR SELECTION)
                                      join (if (ATOM THING)
                                                   then (LIST THING NIL)
                                                 elseif (AND (LISTP THING)
                                                                 (EQ 2 (LENGTH THING)))
                                                   then [CL:FORMAT PROMPTWINDOW "~&Set ~a to ~a"
                                                                   (SETQ VAR (CAR THING))
                                                                   (SETQ VALUE (EVAL (CADR THING]
                                                         (LIST VAR (CADR THING] 
                                                             (* ; "LET* BINDING LIST")
           elseif [AND (LISTP SELECTION)
                           (for THING in SELECTION
                              always (OR (ATOM THING)
                                             (AND (LISTP THING)
                                                  (EQLENGTH SELECTION 2]
             then (for THING in SELECTION
                         do (if (ATOM THING)
                                    then (SET THING NIL)
                                  elseif (AND (LISTP THING)
                                                  (EQLENGTH SELECTION 2))
                                    then (SEDIT-SET-AND-PRINT THING))) 
                                                             (* ; "LET BINDING PAIR")
           elseif (AND (LISTP SELECTION)
                           (ATOM (CAR SELECTION))
                           (EQLENGTH SELECTION 2))
             then (SEDIT-SET-AND-PRINT SELECTION)
           else (PRINTOUT PROMPTWINDOW T 
                           "SORRY, BUT AUTOBIND COULD NOT UNDERSTAND YOUR SELECTION OF" SELECTION)))
    NIL])

(AUTO-ITERATE
  [LAMBDA NIL                                     (* ; "Edited  5-Jul-89 16:54 by t.toth-fejel")
    (if $$STEPS
        then (for STATEMENT in $$STEPS bind IV NEWVALUE
                    do (SET (SETQ IV (fetch (IS-INFO IV) of STATEMENT))
                                (APPLY* (fetch (IS-INFO ACCESS) of STATEMENT)
                                       (fetch (IS-INFO VALUE) of STATEMENT)))
                          [replace (IS-INFO VALUE) of STATEMENT
                             with (SETQ NEWVALUE (APPLY* (fetch (IS-INFO STEP) of 
                                                                                            STATEMENT
                                                                    )
                                                            (fetch (IS-INFO VALUE) of 
                                                                                            STATEMENT
                                                                   ]
                          (PRINTOUT PROMPTWINDOW T IV " set to " .PPV (EVAL IV)
                                 "." T "Next or remaining value" (if (EQP 1 (LENGTH NEWVALUE))
                                                                     then "s"
                                                                   else "")
                                 ": ")
                          (LVLPRIN2 NEWVALUE PROMPTWINDOW 4 4))
      else (PROMPTPRINT "Iteration list empty"])

(BIND-ITERATION-VARS
  [LAMBDA (ITERATIVE.STATEMENT)                   (* ; "Edited  7-Jul-89 12:17 by t.toth-fejel")
    [if (AND ITERATIVE.STATEMENT (LISTP ITERATIVE.STATEMENT)
                 (OR (FMEMB 'FOR ITERATIVE.STATEMENT)
                     (FMEMB 'for ITERATIVE.STATEMENT)))
        then 

              (* ;; "$$STEPS IS GLOBAL")

              (SETQ $$STEPS NIL)
              (repeatuntil [NOT (SETQ ITERATIVE.STATEMENT (OR (FMEMB 'AS ITERATIVE.STATEMENT)
                                                                  (FMEMB 'as ITERATIVE.STATEMENT]
                 bind ACCESS STEP ITERATION.VARIABLE ITERATION.LIST VALUE
                 do 

                       (* ;; "GET RID OF %"FOR%" OR %"AS%"")

                       (pop ITERATIVE.STATEMENT)
                       (SETQ ITERATION.VARIABLE (pop ITERATIVE.STATEMENT))
                       (SELECTQ (SETQ IN-FROM-OR-ON (pop ITERATIVE.STATEMENT))
                           ((IN in) 
                                (SETQ ACCESS 'CAR)
                                (SETQ STEP 'CDR))
                           ((FROM from) 
                                (SETQ STEP 'ADD1)
                                (SETQ ACCESS 'QUOTE))
                           ((ON on) 
                                (SETQ STEP 'CDR)
                                (SETQ ACCESS 'QUOTE))
                           NIL)
                       (SETQ ITERATION.LIST (pop ITERATIVE.STATEMENT))
                       (if (MEMB IN-FROM-OR-ON '(FROM from))
                           then (if (MEMB (CAR ITERATIVE.STATEMENT)
                                                  '(TO to))
                                        then (pop ITERATIVE.STATEMENT)
                                              (pop ITERATIVE.STATEMENT)))
                       (if (MEMB (CAR ITERATIVE.STATEMENT)
                                     '(BY by))
                           then (pop ITERATIVE.STATEMENT)
                                 (SELECTQ IN-FROM-OR-ON
                                     ((IN in) 
                                          (SETQ STEP (pop ITERATIVE.STATEMENT)))
                                     ((FROM from) 
                                          [SETQ STEP `(LAMBDA (NUMBER)
                                                        (+ NUMBER ,(pop ITERATIVE.STATEMENT])
                                     ((ON on) 
                                          [SETQ STEP `(LAMBDA (,ITERATION.VARIABLE)
                                                        ,(pop ITERATIVE.STATEMENT])
                                     NIL))
                       (push $$STEPS
                              (create IS-INFO
                                     IV _ ITERATION.VARIABLE
                                     ACCESS _ ACCESS
                                     STEP _ STEP
                                     VALUE _ (if (SETQ VALUE (NLSETQ (EVAL ITERATION.LIST)))
                                                 then (CAR VALUE]
    (AUTO-ITERATE])

(EVAL-TO-PROMPTWINDOW
  [LAMBDA (context charcode extra)                (* ; "Edited 31-Jul-89 15:31 by t.toth-fejel")
    "Meta-W evaluates the expression, same as Meta-E, except that it puts" 
    "the result in the promptwindow instead of calling an inspector or editor for it." (SETQ 
                                                                                        SELECTION
                                                                                        (
                                                                                  SEDIT:GET-SELECTION
                                                                                         context))
    (LET (VALUE-LIST)
         (PRINTOUT PROMPTWINDOW T "Evals to:" T
                (if [LISTP (SETQ VALUE-LIST (ERSETQ (PROCESS.EVAL (FETCHFIELD '(
                                                                                  SEDIT::EDIT-CONTEXT
                                                                                    6 POINTER)
                                                                             context)
                                                               SELECTION T]
                    then (CAR VALUE-LIST)
                  else "ERROR"])

(INIT-AUTOBIND
  [LAMBDA NIL                                     (* ; "Edited 13-Jul-89 12:10 by t.toth-fejel")
                                                             (* ; "since the idiotic documentation sucks, plus add-command doesnt work as advertised, I have to manipulate SEDIT::COMMAND-TABLE-SPEC directly")
    (if (NOT (ASSOC 'AUTO-BIND SEDIT::COMMAND-TABLE-SPEC))
        then (SETQ SEDIT::COMMAND-TABLE-SPEC (APPEND '((EVAL-TO-PROMPTWINDOW ("Eval" "M-W" 
                                                              "Evaluate selection into promptwindow."
                                                                                            )
                                                                  NIL "1,W" "1,w" (CL:EVAL))
                                                           (AUTO-BIND ("Autobind" "M-Q" 
                                             "Binds variables in LET, LET* and for loop expressions."
                                                                                 )
                                                                  NIL "1,Q" "1,q" (GARBAGE))
                                                           (AUTO-ITERATE ("Iterate" "M-Tab" 
                                              "Iterates previously autobound variables in for loops."
                                                                                    )
                                                                  NIL "1,	" "1,	" (GARBAGE)))
                                                        SEDIT::COMMAND-TABLE-SPEC))
              (SEDIT:ADD-COMMAND "#Q" (FUNCTION AUTO-BIND)
                     NIL "Autobind" "M-Q" "Binds variables in LET, LET* and for loop expressions.")
              (SEDIT:ADD-COMMAND "#	" (FUNCTION AUTO-ITERATE)
                     NIL "Iterate" "M-Tab" "Iterates previously autobound variables in for loops.")
              (SEDIT:ADD-COMMAND "#W" (FUNCTION EVAL-TO-PROMPTWINDOW)
                     NIL "Eval to Promptwindow" "M-W")
              (SEDIT:RESET-COMMANDS))

    (* ;; "if you don't like autobind, you can always get the default commmands back with (SEDIT:DEFAULT-COMMANDS) ")

    NIL])

(SEDIT-SET-AND-PRINT
  [LAMBDA (VAR-VALUE-PAIR)                        (* ; "Edited  5-Jul-89 16:19 by t.toth-fejel")
    (LET (VALUE)
         (if [SETQ VALUE (NLSETQ (EVAL (CADR VAR-VALUE-PAIR]
             then (PRINTOUT PROMPTWINDOW T "Set " (CAR VAR-VALUE-PAIR)
                             " to "
                             (CAR VALUE))
                   (SET (CAR VAR-VALUE-PAIR)
                        (CAR VALUE))
           else (PRINTOUT PROMPTWINDOW T "Sorry, but I could not bind " (CAR VAR-VALUE-PAIR)
                           T "because evaluation of " (CADR VAR-VALUE-PAIR)
                           T " caused an error."])

(TEST-AUTOBIND
  [LAMBDA NIL                                     (* ; "Edited  7-Jul-89 12:30 by t.toth-fejel")
    (for THING from 1 to 16 by 2 as INDEX
       in '(THIS HAS BEEN DONE ON AN EXPLORER ALSO) collect (LIST THING INDEX))
    (for THING on '(ALPHA BETA DELTA GAMMA LAMBDA EPSILON) by (CDDR THING) collect
                                                                                       THING)
    (for THING in '(BEE ANT COW) as INDEX FROM 10 TO 1 BY -1 collect
                                                                                     THING)
    (LET* ((A 2)
           (B A)
           (C 3))
          (LIST A B C))
    (LET ((A 1)
          (B A)
          (C 3))
         (LIST A B C))

    (* ;; "you can also select just the binding list ((A 1) (B A) (C 3)), just the pair (A 1), or just the atom, in this last case it will be set to NIL.")

    (* ;; "I did not bother handleling the (var _ value) form because we don't use it here at ITI.  Same with CL:MULTIPLE-VALUE-BIND and CL:MULTIPLE-VALUE-SETQ, though they could all be easily added in the AUTO-BIND function.")

    NIL])
)
(DECLARE%: EVAL@COMPILE

(RECORD IS-INFO (IV ACCESS STEP VALUE))
)

(RPAQ? $$STEPS NIL)
(DECLARE%: DOEVAL@COMPILE DONTCOPY

(GLOBALVARS $$STEPS)
)

(RPAQQ AUTOBIND-HELP 
       (What can Autobind do for you? It makes it easier for you to test your code as you're writing
             it. It does one of three things to the current selection-
             (1.0 Meta-W -- Print evaluation results in the promptwindow instead of displaying or 
                  editing it- which is much quicker when all you really want to do is look at the 
                  results to see if they came out correctly)
             (2.0 Meta-Q -- Bind variables in LET, LET*, their binding lists, binding pairs, atoms, 
                  and for loop expressions)
             (3.0 Meta-Tab -- Iterate variables in for loops.)
             See the function TEST-AUTOBIND for examples that work.
             (Thanks to Jay Ferguson for originally writing a version for DEDIT while at Ford 
                    Aerospace, and to Dennis Heher -- also from Ford Aerospace -- for sending me that
                    copy. Comments, suggestions, and criticisms are welcome. Tihamer Toth-Fejel 
                    ttf@iti.org)))



(* %| "AUTOBIND-HELP describes what autobind does")


(INIT-AUTOBIND)
(PUTPROPS AUTOBIND COPYRIGHT ("ITI" 1989))
(DECLARE%: DONTCOPY
  (FILEMAP (NIL (868 15591 (AUTO-BIND 878 . 5416) (AUTO-ITERATE 5418 . 6990) (BIND-ITERATION-VARS 6992
 . 10178) (EVAL-TO-PROMPTWINDOW 10180 . 11466) (INIT-AUTOBIND 11468 . 13707) (SEDIT-SET-AND-PRINT 
13709 . 14379) (TEST-AUTOBIND 14381 . 15589)))))
STOP

