#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/ioctl.h>

#define SERVICE_NAME ""
#define PORT_NUM 35

char	buf[BUFSIZ];

main(argc,argv)
int argc;
char *argv[];
{
    if (argc != 3){
	fprintf(stderr,"Printclient: wrong number of arguments.\n");
	exit(1);
    }
#ifdef DEBUG
    printf("About to call printclient.\n");
#endif
    printclient(argv[1], argv[2]); 
#ifdef DEBUG
    fprintf(stdout,"Printclient: finished\n");
#endif
    exit(0);
}


/* Client routine - create a socket, connect it to the
	server on the machine given as arg, send things to
	it and get messages back. 
*/

printclient (server_host_name, filename)
char *server_host_name;
char *filename;

{
	char	buffer[100];
	int	sock, result;
	struct	sockaddr_in to;
	struct	sockaddr_in from;
	int	numtoread, res;
	int	foo;
	int	from_length;
/*	struct	servent  *service;*/
	struct	hostent  *host;
	int	fd;
	char	*line, *readline();

/* 
 * Get the service table entry for the service named
 * SERVICE_NAME in order to be able to look up things
 * like the service port number and protocol. We get
 * the host entry so that we know the host address.
 */

/*	service = getservbyname (SERVICE_NAME, 0);
	if (service == NULL) {
		fprintf (stderr, "Printclient: cannot
				find the service named
				 %s in /etc/services\n", SERVICE_NAME);
		exit (1);
	}
*/


	host = gethostbyname (server_host_name);
	if (host == NULL) {
		fprintf (stderr, "Printclient: cannot find a host named %s\n",
					server_host_name);
		exit(1);
	}
#ifdef DEBUG
	printf("host is %d\n",host->h_addr);
#endif

/*
 * Create the destination address. Copy the host address into
 * the sin_addr field of the internet address, and set the
 * sin_family and the sin_port fields according to the stuff
 * gotten from the service table entry and the host table
 * entry.
 */

	bzero ((char *)&to, sizeof(to));
	bcopy (host->h_addr, (char *)&to.sin_addr, host->h_length);
	to.sin_family = host->h_addrtype;
	to.sin_port = PORT_NUM;


/*
 * Create a socket of type stream in the INET address family.
 */

	sock = socket(AF_INET, SOCK_STREAM, 0);
	if (sock == -1) {
		perror("stream socket");
		exit(1);
	}
#ifdef DEBUG
	printf("sock = %d\n",sock);
#endif

/*
 * Read buffers from the file until EOF is reached. Send each line
 * to the server, get reply from server and print.
 */

	if ((fd = open (filename, O_RDONLY, 0)) < 0) {
	    fprintf(stderr, "Princlient: cannot open ");
	    perror(filename);
	    return(-1);
	}

	if (connect(sock, &to, sizeof(to)) < 0){
	    perror("Printclient: connect");
	    exit(1);
	}
#ifdef DEBUG
	printf("connect okay\n");
#endif
	bzero(buffer, sizeof(buffer));
	strcpy(buffer,filename);
	strcat(buffer, "  ");
	strcat(buffer, "text");
	buffer[strlen(buffer)] = '\n';
	result = write (sock, buffer, strlen(buffer));
	if (result == -1) {
	    perror("Printclient: write");
	    shutdown(sock,2);
	    close(sock);
	    exit(1);
	}

#ifdef DEBUG
	bzero(buffer, sizeof(buffer));
	for(foo = 0; foo < 5 ; foo++) {
	    res = ioctl(sock, FIONREAD, &numtoread);
	    if (res < 0) perror("Princlient: ioctl");
	    printf("id the ioctl, %d chars to read\n", numtoread);
	    if (numtoread > 0) {
		res = read (sock, buffer, numtoread);
		if (res < 0) { perror("Read");}
		else {
		    buffer[res] = '\0';
		    printf("read %d, they are %s first %d", res, buffer, buffer[0]);
		    break;
		}
	    }
	    sleep(15);
	}
#endif
/*
	printf("about to read one char\n");
	result = read(sock, buffer, 1);
	if (result == -1) {
	    perror ("Printclient: read");
	    shutdown(sock, 2);
	    close(sock);
	    exit(1);
	}
	printf("read = %d char = %c\n",result, buffer[0]);
*/


	while ((result = read(fd, buf, BUFSIZ)) > 0) {
	    result = write (sock, buf, result);
	    if (result == -1) {
		perror("Printclient: write");
		shutdown(sock,2);
		close(sock);
		exit(1);
	    }
#ifdef DEBUG
	    printf("sendto = %d\n",result);
#endif
	    from_length = sizeof(from);
	}
	write(sock, EOF, 1);

#ifdef DEBUG
	bzero(buffer, sizeof(buffer));
	for(foo = 0; foo < 5 ; foo++) {
	    res = ioctl(sock, FIONREAD, &numtoread);
	    if (res < 0) perror("Princlient: ioctl");
	    printf("id the ioctl, %d chars to read\n", numtoread);
	    if (numtoread > 0) {
		res = read (sock, buffer, numtoread);
		if (res < 0) { perror("Read");}
		else {
		    buffer[res] = '\0';
		    printf("read %d, they are %s first %d", res, buffer, buffer[0]);
		    break;
		}
	    }
	    sleep(15);
	}
#endif    

	shutdown(sock, 2);
	close(sock);
#ifdef DEBUG
	printf("did close\n");
#endif
}
	



char *
readline(fd)
int fd;
{

    static char	line[BUFSIZ];
    static int 	c = 0;
    static int 	max = 0;
    int		j = 0;


    if (c >= max) {
	max = read(fd, buf, BUFSIZ);
	c = 0;
	if (max == 0)
	    return((char *) NULL);
	if (max < 0){
	    fprintf(stderr, "Printclient: read error ");
	    perror();
	    exit(1);
	}
    }
	

    bzero(line, sizeof(line));
    j = 0;
    while (buf[c] != '\n'){
	line[j] = buf[c];
	c++;
	j++;
	if (c >= max) {
		max = read(fd, buf, BUFSIZ);
		c = 0;
		if (max == 0) break;
		if (max < 0){
		    fprintf(stderr, "Printclient: read error ");
		    perror();
		    exit(1);
		}
	}    
    }
    c++;
    line[j] = '\n';		/* used to be '/0' */
    return(line);
}

	

