;;; Extension to IFT for pop-up-menu.lisp
;;; by Daniel LaLiberte (liberte@ncsa.uiuc.edu)  August 1992

#| Load up the interface builder and extensions.
(load "ccl:Interface Tools;make-ift")
(ift::load-ift)
(load "ccl:Interface Tools;ift-icon-dialog-item")
(load "ccl:Interface Tools;ift-pop-up-menu")
|#

(in-package :interface-tools)

(add-editable-dialog-item (make-instance 'ccl:pop-up-menu
                            :item-display "item 1"
                            :dialog-item-text "Popup"
                            :menu-items 
                            (list 
                             (make-instance 'menu-item
                               :menu-item-title "item one"
                               :menu-item-action #'(lambda ()
                                                           )))))

;;(remove-editable-dialog-item 'ccl:pop-up-menu)

(defmethod add-editor-items :after ((popup-item ccl:pop-up-menu) editor)
  (let* ((position *editor-items-start-pos*)
         (size #@(116 16))
         ;;(delta (make-point 0 (+ (point-v size) 5)))
         )
    (add-subviews 
     editor
     (make-dialog-item 'button-dialog-item
                       position
                       ;;(setq position (add-points position delta))
                       size "Set menu items"
                       #'(lambda (item)
                             (declare (ignore item))
                             (make-instance 'menu-editor :menu popup-item)
                             ))
     )))