;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;hardcopy.lisp
;;
;;
;;copyright 1988-89 Apple Computer, Inc.
;;
;; defines a very basic printing routine for windows
;;
;; This code sets the window's wptr to a printer grafport
;; and then calls view-draw-contents

(defclass hardcopy-window
  (window)
  ((hardcopy-in-progress
    :initform nil
    :accessor hardcopy-in-progress)))

(defmethod set-view-wptr ((view view) new-wptr)
  (setf (slot-value view 'wptr) new-wptr)
  (do-subviews (subview view)
    (set-view-wptr subview new-wptr)))

(defmethod window-draw-grow-icon ((window hardcopy-window))
  (unless (hardcopy-in-progress window)
    (call-next-method)))

(defmethod window-hardcopy ((window hardcopy-window) &optional (show-dialog t))
  (declare (ignore show-dialog)) ;you fix it
  (window-select window)
  (let ((pRec (make-record :TPrint)))
    (unwind-protect
      (with-cursor *arrow-cursor*
        (#_PrOpen)
        (ccl::prchk)
        (when (#_PrJobDialog :ptr pRec :boolean)
          (let ((ccl::*hc-page-open-p* nil) (ccl::*inhibit-error* t))
            (declare (special ccl::*hc-page-open-p* ccl::*inhibit-error*))
            (setf (hardcopy-in-progress window) t)
            (ignore-errors
             (without-interrupts
              (let ((window-ptr (wptr window))
                    (hardcopy-ptr (#_PrOpenDoc :ptr pRec :long 0 :long 0 :ptr)))
                (rlet ((pstate :penstate))
                  (#_GetPenState :ptr pstate)
                  (unwind-protect
                    (progn
                      (#_SetPenState :ptr pstate)
                      (#_TextFont :word (rref window-ptr :GrafPort.txFont))
                      (#_TextFace :word (rref window-ptr :GrafPort.txFace))
                      (#_TextMode :word (rref window-ptr :GrafPort.txMode))
                      (#_TextSize :word (rref window-ptr :GrafPort.txSize))
                      (#_SpaceExtra :long (rref window-ptr :GrafPort.spExtra))
                      (with-dereferenced-handles ((ppRec pRec))
                        pprec
                        (ccl::prchk)
                        (unwind-protect
                          (progn
                            (set-view-wptr window hardcopy-ptr)
                            (#_PrOpenPage :ptr hardcopy-ptr :long 0)
                            (with-port hardcopy-ptr
                              (view-draw-contents window))
                            (#_PrClosePage :ptr hardcopy-ptr))
                          (set-view-wptr window window-ptr))))
                    (#_PrCloseDoc :ptr hardcopy-ptr))))
              (when (eq (href pRec :TprJob.bJDocLoop)
                        #$bSpoolLoop)
                (ccl::prchk)
                (rlet ((StRec :tprstatus))
                  (#_PrPicFile :ptr pRec :long 0 :long 0 :long 0 :ptr StRec))
                (ccl::prchk))))
            t)))
      (setf (hardcopy-in-progress window) nil)
      (dispose-record pRec)
      (#_PrClose))))

#|
(require 'quickdraw)
(setq a-window (make-instance 'hardcopy-window))

(defmethod view-draw-contents ((window (eql a-window)))
  (frame-rect window 10 10 100 100)
  (fill-oval window *black-pattern* 20 20 90 90))

(window-hardcopy a-window)
|#
