;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;	directory-menu.lisp
;;
;;	copyright  1992 Apple Computer, Inc.
;;
;;	This file installs a directory menu which allows you to easily change between
;;	a set of directories.  Changing a directory effects the mac-default-directory
;;	and the choose-file-default-directory.
;;	The current directory can be shown in a dialog or pasted in an
;;	editable dialog item or fred window. Additional directories can be choosen
;;	and installed in the menu using the "Set Directory" dialog, or by calling
;;	add-directory-menu-item which takes a path name.
;;
;;	Usage Tip:  Very handy for pasting long directory names in the Search Files dialog.
;;

(in-package :ccl)

(export '(add-directory-menu-item
          do-show-directory
          do-paste-directory))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;  Mod Hisory
;;
;; 03/27/92 drw		First draft for MCL 2.0 - Derek White.
;;

(defclass dir-menu-item (menu-item) ())

(defvar *dir-menu* nil)

(defun set-default-directory (dir-name)
  (set-mac-default-directory dir-name)
  (set-choose-file-default-directory dir-name))

(defmethod menu-item-action ((item dir-menu-item))
  (set-default-directory (menu-item-title item)))

(defun add-directory-menu-item (path)
  (let ((title (directory-namestring (translate-logical-pathname path))))
    (unless (find-menu-item *dir-menu* title)
      (let ((menu (make-instance 'dir-menu-item :menu-item-title title)))
        (add-menu-items *dir-menu*  menu)))))
  
(defun do-show-directory ()
  (message-dialog (format nil "Default Directory: ~%~%~A" (namestring (choose-file-default-directory)))))

(defmethod do-paste-directory ((fred-thing fred-mixin)) ; fred-windows, and fred-dialog-items
  (multiple-value-bind (b e) (selection-range fred-thing)
    (ed-replace-with-undo fred-thing b e (namestring (choose-file-default-directory)))
    (fred-update fred-thing)))

(defmethod do-paste-directory ((w window)) ; not a fred-window
  (let ((fred-thing (current-key-handler w)))
    (if (and fred-thing (typep fred-thing 'fred-mixin))
      (do-paste-directory fred-thing)
      (ed-beep))))

(defun do-set-directory ()
  (let ((dir (choose-directory-dialog)))
    (set-default-directory dir)
    (add-directory-menu-item dir)))

;--------------- create and install menu -------------

(setq *dir-menu* (make-instance 'menu
                   :menu-title "Directory"
                   :menu-items (list (make-instance 'menu-item
                                       :menu-item-title "Show Directory"
                                       :menu-item-action #'do-show-directory)
                                     (make-instance 'window-menu-item
                                       :menu-item-title "Paste Directory"
                                       :menu-item-action #'do-paste-directory)
                                     (make-instance 'menu-item
                                       :menu-item-title "Set Directory..."
                                       :menu-item-action #'do-set-directory)
                                     (make-instance 'menu-item
                                       :menu-item-title "-"
                                       :disabled t))))

(add-directory-menu-item "ccl:")
(add-directory-menu-item "home:")

(menu-install *dir-menu*)

; (menu-deinstall (find-menu "directory"))
