;;; -*- Mode:Common-Lisp; Package:Yes-Way; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; This code was written by James Rice.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.

;;; The development of this software was assisted by the following grants:
;;; Biomedical Research Technology Program of the National Institutes
;;; of Health under grant RR-00785
;;; Information Systems Technologies office of the Defense Advanced
;;; Research Projects Agency under contract N00039-86-C0033.

;;; **********************************************************************

;;; Make sure the command tables are fully composed.
(Build-All-Command-Tables)

;-------------------------------------------------------------------------------

;;; Define a new type of initialization.
(Defvar After-Login-Initialization-List :Unbound
  "Initializations to be run after logging in."
)

;;; Add the initialization.
(nconc si:Initialization-Keywords
       '((After-Login After-Login-Initialization-List))
)

;;; Attach the initialization to login.
(defadvise login (:After-Login-Initializations) ()
  (let ((results (multiple-value-list :Do-It)))
       (sys:initializations 'After-Login-Initialization-List)
       (values-list results)
  )
)

;;; Create the default rule set.
(or (rule-set-named "Default")
    (make-instance 'Rule-Set :Name "Default"
		   :Documentation
		   "The default rule set into which rules are put."
    )
)

;;; Make sure that IMAP starts up properly and that we reset vars appropriately.
(Add-Initialization "Close down IMAP"
  '(close-down-yw)
  '(:Logout :Normal)
)

(Add-Initialization "Start up IMAP"
  '(start-up-yw)
  '(:After-Login :Normal)
)

(Add-Initialization "Reset IMAP vars"
  '(reset-reset-vars)
  '(:Login :Normal)
)

(Add-Initialization "Reset IMAP vars"
  '(reset-reset-vars)
  '(:Full-GC :Normal)
)

(Add-Initialization "Clear IMAP vars"
  '(clear-reset-vars)
  '(:Cold :Normal)
)

(Add-Initialization "Reset Daemon Processes"
  '(warm-reset)
  '(:Warm :Normal)
)

(mapcar 'sys:try-to-compile-flavor-methods
  '(;;; These are the flavors defined by the IMAP client.
    filtration-mixin
    imap-stream
    mail-control-window
    mailbox-selector
    message-display-pane
    message-sequence
    yw-daemon
    yw-prompt-window
    yw-zwei:copying-stream
    yw-zwei:corsorposing-stream
    yw-zwei:untyoing-stream
    summary-window
    task-server
    user-filter-sequence
   )
)

(w:add-system-key
  #\N
  '(get-mail-control-window)
  "Process mail on a remote server." NIL
)
(w:add-system-key
  #\M
  '(if *userp-system-m-key* (get-mail-control-window) (zwei:read-mail))
  "Process mail on a remote server or use ZMail." NIL
)
(w:add-system-key
  #\-
  '(or *yw-daemon* (find-window-of-flavor 'Yw-Daemon))
  "YW Daemon." NIL
)
(w:add-system-key
  #\_
  '(or *edit-server* (find-window-of-flavor 'task-server))
  "Mailer Task Server." NIL
)
(w:add-system-key
  #\
  '(identity *address-server*)
  "Mailer Address Server." NIL
)
(w:add-system-key
  #\
  '(identity *rule-processor*)
  "Mailer Rule Processor." NIL
)

(export '(
	  defadvise
	  defadvise-within
	  defcommand-short-form
	  defcommand-table
	  deffilter
	  defimmediate-command
	  defmacro-command
	  defnonimmediate-command
	  defparent
	  undefcommand-short-form
	  undeffilter
	  undefimmediate-command
	  undefmacro-command
	  undefnonimmediate-command
	 )
	'YW
)


;;; See whether we've changed the shape of any windows.
(Check-Window-Resource 'summary-windows 'summary-window)
(Check-Window-Resource 'mailer-windows 'mail-control-window)

(defun remake-yw (&optional (force-p nil))
"Simple makesystem for YW."
  (make-system :Yw :Noconfirm :Really-Nowarn (if force-p :Reload :Noop))
)

;-------------------------------------------------------------------------------

;;; Advise Break so that we don't get rubout handler lossage in the YW
;;; window.
(defadvise break (:Reset-rh) ()
  (letf ((#'sys:internal-read-char
	  (or *old-internal-read-char* #'sys:internal-read-char)
	 )
	)
	:Do-It
  )
)