;;; -*- Mode:Common-Lisp; Package:Yes-Way; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; This code was written by James Rice.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.

;;; The development of this software was assisted by the following grants:
;;; Biomedical Research Technology Program of the National Institutes
;;; of Health under grant RR-00785
;;; Information Systems Technologies office of the Defense Advanced
;;; Research Projects Agency under contract N00039-86-C0033.

;;; **********************************************************************

(Defflavor YW-Top-Level-Command-Names
	   ()
	   (ucl:Top-Level-Command-Names)
  (:Documentation "A typein mode for yw top level command names.")
)

(Defwhopper (YW-Top-Level-Command-Names :complete-p) (syntax)
"Is willing to complete an YW command pretty well any time."
  (if (member syntax '(function :first-atom atom) :test #'eq)
      "Commands"
      (continue-whopper syntax)
  )
)

(defparameter YW-Top-Level-Command-Names
	      (make-instance ' YW-Top-Level-Command-Names)
"The instance of the yw top level command names typein mode."
)

(defmethod (Yw-Top-Level-Command-Names :get-command-for-string) (string)
"Given a string, returns the command that matches it."
  (let ((command nil))
       (ucl:Looping-Through-Command-Tables Nil
	 (let ((match (send ucl:command-table :lookup-name string)))
	      (if match
		  (progn (setq command match)
			 (return)
		  )
		  nil
	      )
	 )
       )
       command
  )
)

